/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import android.app.Application;
import android.content.Context;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.AgentUtil;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ConfigurationPreset;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.lifecycle.OneAgentLifecycleManagerBridge;
import com.dynatrace.android.agent.mixed.WebRequestTraceContext;
import com.dynatrace.android.agent.useraction.OneAgentUserInteractionManagerBridge;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.CbWebReqTracker;
import com.dynatrace.android.callback.ConnStateParms;
import com.dynatrace.android.callback.TextViewHelper;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

final class CallbackCore {
    private static final String LOGTAG = Global.LOG_PREFIX + "CallbackCore";
    private static final String TOUCH_ON = "Touch on ";
    private static final String INITIATE = "Initiate ";
    static AtomicBoolean isInitialized = new AtomicBoolean(false);
    static Configuration configuration = ConfigurationPreset.generateImproperConfiguration();
    static boolean captureTestData = false;
    private static WeakHashMap<HttpURLConnection, CbWebReqTracker> httpConns = new WeakHashMap();
    private static volatile DTXAutoAction currentAutoAction = null;
    private static volatile ListenerActionType currentActionType = null;

    private CallbackCore() {
    }

    static String defaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java/" + System.getProperty("java.version");
    }

    static void init(Context context, Configuration config) {
        OneAgentLifecycleManagerBridge oneAgentLifecycleManagerBridge;
        ServerConfiguration serverConfiguration;
        if (context == null) {
            return;
        }
        Application application = (Application)context.getApplicationContext();
        if (isInitialized.getAndSet(true)) {
            return;
        }
        if (AdkSettings.getInstance().getConfiguration() != null) {
            config = AdkSettings.getInstance().getConfiguration();
        } else if (config == null) {
            return;
        }
        if (config.debugLogLevel) {
            Global.DEBUG = true;
        }
        configuration = config;
        if (!CallbackCore.configuration.autoStart && Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)("Runtime properties: " + configuration));
        }
        if (Utility.isIsolatedProcess()) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Isolated service detected. Monitoring deactivated for this process");
            }
            return;
        }
        if (CallbackCore.configuration.autoStart) {
            Dynatrace.startup((Application)application, (Configuration)configuration);
        }
        if (AdkSettings.getInstance().getContext() == null) {
            try {
                AdkSettings.getInstance().setup(configuration, (Context)application);
            }
            catch (Exception exception) {
                if (Global.DEBUG) {
                    Utility.zlogD((String)LOGTAG, (String)"unable to start agent, problem in settings setup", (Throwable)exception);
                }
                return;
            }
        }
        if ((serverConfiguration = AdkSettings.getInstance().getServerConfiguration()).isGen3Enabled() && (oneAgentLifecycleManagerBridge = Core.getOneAgentLifecycleManagerBridge()) != null) {
            oneAgentLifecycleManagerBridge.onAppStart();
        }
        if (CallbackCore.configuration.applicationMonitoring) {
            Core.getApplicationStartMonitor().onApplicationStart(TimeLineProvider.GLOBAL_TIME_LINE_PROVIDER);
        }
    }

    static CbWebReqTracker addConnection(HttpURLConnection conn, boolean isDefaultImpl) {
        if (conn == null) {
            return null;
        }
        if (!Dynatrace.getCaptureStatus() || !Session.currentSession().getPrivacyRules().shouldCollectEvent(EventType.WEB_REQUEST)) {
            return null;
        }
        ConnRegistration cr = new ConnRegistration(conn);
        if (isDefaultImpl) {
            return cr.register();
        }
        try {
            conn.getURL().toString();
            return cr.register();
        }
        catch (Exception e) {
            cr.start();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CbWebReqTracker registerConn(HttpURLConnection conn) {
        CbWebReqTracker webReqState;
        WebReqTag tag;
        block11: {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("Add WR %s to %s", conn.getClass().getSimpleName(), conn.getURL().toString()));
            }
            if (!isInitialized.get()) {
                if (Global.DEBUG) {
                    Utility.zlogD((String)LOGTAG, (String)"OneAgent not correctly initialized");
                }
                return null;
            }
            if (!CallbackCore.configuration.webRequestTiming) {
                return null;
            }
            DTXAutoAction action = DTXAutoAction.getAutoAction();
            tag = CallbackCore.generateWebReqTag(action, conn);
            if (tag == null) {
                return null;
            }
            webReqState = new CbWebReqTracker(action, tag.getSession());
            if (tag.getSession().isGrailEventsShouldBeCaptured()) {
                WebRequestTraceContext traceContext = new WebRequestTraceContext();
                webReqState.setTraceContext(traceContext);
                try {
                    conn.setRequestProperty("traceparent", traceContext.getTraceparentId());
                }
                catch (Exception e) {
                    if (!Global.DEBUG) break block11;
                    Utility.zlogE((String)LOGTAG, (String)e.toString());
                }
            }
        }
        WeakHashMap<HttpURLConnection, CbWebReqTracker> weakHashMap = httpConns;
        synchronized (weakHashMap) {
            httpConns.put(conn, webReqState);
        }
        webReqState.setWebReqTag(tag);
        return webReqState;
    }

    private static WebReqTag generateWebReqTag(DTXAutoAction action, HttpURLConnection conn) {
        WebReqTag dtTag;
        if (action != null && (dtTag = AgentUtil.internalTagRequest((DTXActionImpl)action, conn)) != null) {
            return dtTag;
        }
        return AgentUtil.getRequestTag();
    }

    public static void setWebReqTag(HttpURLConnection connection) {
        CbWebReqTracker webReqState = httpConns.get(connection);
        if (webReqState != null) {
            connection.setRequestProperty(Dynatrace.getRequestTagHeader(), webReqState.webReqTag.toString());
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)("webReqState is: " + webReqState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateConnection(ConnStateParms parm) {
        if (parm.conn != null && CallbackCore.configuration.webRequestTiming) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("%s of %s of %s to %s", new Object[]{parm.state, parm.trackingMethod, parm.conn.getClass().getSimpleName(), parm.getRequestDesc()}));
            }
        } else {
            return;
        }
        CbWebReqTracker webReqState = httpConns.get(parm.conn);
        if (webReqState == null) {
            return;
        }
        if (CbConstants.WrStates.PRE_EXEC == parm.state) {
            String dynatraceTag = WebReqTag.fetchWebReqTag((URLConnection)parm.conn, (String)Dynatrace.getRequestTagHeader());
            String xDtcTag = WebReqTag.fetchWebReqTag((URLConnection)parm.conn, (String)"x-dtc");
            webReqState.checkForManualTag(dynatraceTag, xDtcTag);
        }
        webReqState.procNewState(parm);
        if (webReqState.canFinalize) {
            WeakHashMap<HttpURLConnection, CbWebReqTracker> weakHashMap = httpConns;
            synchronized (weakHashMap) {
                httpConns.remove(parm.conn);
            }
            webReqState.sendEvents(parm);
        }
    }

    static void onUserActionEnter(ListenerActionType actionType) {
        CallbackCore.onUserActionEnter(actionType, INITIATE + actionType.toString());
    }

    static void onUserActionEnter(ListenerActionType actionType, View view) {
        if (view == null) {
            CallbackCore.onUserActionEnter(actionType);
        } else {
            CallbackCore.onUserActionEnter(actionType, CallbackCore.getViewDesc(view));
            OneAgentUserInteractionManagerBridge userInteractionManagerBridge = Core.getOneAgentUserInteractionManagerBridge();
            if (userInteractionManagerBridge != null) {
                userInteractionManagerBridge.onViewClick(view);
            }
        }
    }

    static void onUserActionEnter(ListenerActionType actionType, MenuItem menuItem) {
        if (menuItem == null) {
            CallbackCore.onUserActionEnter(actionType);
        } else {
            CallbackCore.onUserActionEnter(actionType, CallbackCore.getMenuDesc(menuItem));
        }
    }

    static void onUserActionEnter(ListenerActionType actionType, String actionName) {
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)String.format("onUA: %s entry=true actionName=%s", new Object[]{actionType, actionName}));
        }
        if (currentAutoAction != null && currentActionType != actionType) {
            currentAutoAction.startTimer(0);
            currentAutoAction = null;
            currentActionType = null;
        }
        if (currentAutoAction == null && Global.isAlive.get()) {
            Session session = Session.determineActiveSession((boolean)false);
            int serverId = AdkSettings.getInstance().serverId;
            currentAutoAction = DTXAutoAction.createAutoAction((String)actionName, (Session)session, (int)serverId);
            currentActionType = actionType;
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)String.format("onUA: %s entry=true", new Object[]{actionType}));
        }
    }

    static void onUserActionExit(ListenerActionType actionType) {
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)("onUA: " + (Object)((Object)actionType) + " entry=false"));
        }
        if (currentAutoAction != null && currentActionType == actionType) {
            currentAutoAction.startTimer();
            currentAutoAction = null;
            currentActionType = null;
        }
    }

    private static String getViewDesc(View view) {
        if (CallbackCore.configuration.namePrivacy) {
            return TOUCH_ON + view.getClass().getSimpleName();
        }
        CharSequence contentDescription = view.getContentDescription();
        if (contentDescription != null && contentDescription.length() > 0) {
            return TOUCH_ON + contentDescription;
        }
        if (view instanceof TextView) {
            int inputType = ((TextView)view).getInputType();
            if (TextViewHelper.isPasswordInputType(inputType) || TextViewHelper.isVisiblePasswordInputType(inputType)) {
                return "Touch on ****";
            }
            CharSequence text = ((TextView)view).getText();
            if (text != null && text.length() > 0) {
                return TOUCH_ON + text;
            }
        }
        return TOUCH_ON + view.getClass().getSimpleName();
    }

    private static String getMenuDesc(MenuItem menuItem) {
        if (CallbackCore.configuration.namePrivacy) {
            return TOUCH_ON + menuItem.getClass().getSimpleName();
        }
        CharSequence title = menuItem.getTitle();
        if (title != null && title.length() > 0) {
            return TOUCH_ON + title;
        }
        return TOUCH_ON + menuItem.getClass().getSimpleName();
    }

    private static class ConnRegistration
    extends Thread {
        private static HashSet<Integer> requests = new HashSet();
        private HttpURLConnection conn;

        private ConnRegistration(HttpURLConnection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            this.register();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CbWebReqTracker register() {
            block14: {
                try {
                    CbWebReqTracker webReqState = (CbWebReqTracker)httpConns.get(this.conn);
                    if (webReqState != null) {
                        return webReqState;
                    }
                    String wrt = WebReqTag.fetchWebReqTag((URLConnection)this.conn, (String)Dynatrace.getRequestTagHeader());
                    if (wrt == null) break block14;
                    WeakHashMap tempHttpConns = null;
                    WeakHashMap weakHashMap = httpConns;
                    synchronized (weakHashMap) {
                        tempHttpConns = new WeakHashMap(httpConns);
                    }
                    for (Map.Entry entry : tempHttpConns.entrySet()) {
                        WebReqTag webReqTag = ((CbWebReqTracker)entry.getValue()).webReqTag;
                        if (!webReqTag.sameAs(wrt)) continue;
                        if (Global.DEBUG) {
                            Utility.zlogD((String)LOGTAG, (String)("replace tracking for tag " + wrt));
                        }
                        httpConns.remove(entry.getKey());
                        httpConns.put(this.conn, (CbWebReqTracker)entry.getValue());
                        return (CbWebReqTracker)entry.getValue();
                    }
                    return null;
                }
                catch (Exception e) {
                    if (!Global.DEBUG) break block14;
                    Utility.zlogD((String)LOGTAG, (String)"can't access tracking state", (Throwable)e);
                }
            }
            if (requests.contains(this.conn.hashCode())) {
                return null;
            }
            requests.add(this.conn.hashCode());
            int count = 0;
            CbWebReqTracker cwrt = null;
            while (count++ <= 3) {
                try {
                    cwrt = CallbackCore.registerConn(this.conn);
                    break;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            requests.remove(this.conn.hashCode());
            return cwrt;
        }
    }

    static enum ListenerActionType {
        Clicked,
        ItemClicked,
        ItemSelected,
        MenuItemClick,
        OptionsItemSelected,
        PageSelected,
        SwipeToRefresh;

    }
}

