/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;

public class ErrorSegment
extends CustomSegment {
    protected String exceptionName;
    protected String reason;
    protected String stacktrace;
    protected String platformType;
    protected boolean forwardToGrail = true;

    protected ErrorSegment(String name, String exceptionName, String reason, String stacktrace, long parentTagId, Session session, int serverId, String platformType, boolean forwardToGrail) {
        this(name, 6, EventType.ERROR_EXCEPTION, exceptionName, reason, stacktrace, parentTagId, session, serverId, platformType, forwardToGrail);
    }

    protected ErrorSegment(String name, int type, EventType eventType, String exceptionName, String reason, String stacktrace, long parentTagId, Session session, int serverId, String platformType, boolean forwardToGrail) {
        super(name, type, eventType, parentTagId, session, serverId, forwardToGrail);
        this.exceptionName = exceptionName;
        this.reason = reason;
        this.stacktrace = stacktrace;
        this.platformType = platformType;
        this.forwardToGrail = forwardToGrail;
    }

    @Override
    public StringBuilder createEventData() {
        StringBuilder sb = new StringBuilder();
        sb.append("et=").append(this.eventType.getProtocolId());
        sb.append("&na=").append(Utility.urlEncode((String)this.getName()));
        sb.append("&it=").append(Utility.getCurrentThreadId());
        sb.append("&pa=").append(this.getParentTagId());
        sb.append("&s0=").append(this.getLcSeqNum());
        sb.append("&t0=").append(this.getStartTime());
        this.appendOptionalValue(sb, "&rs=", Utility.urlEncode((String)this.reason));
        this.appendOptionalValue(sb, "&ev=", Utility.urlEncode((String)this.exceptionName));
        this.appendOptionalValue(sb, "&st=", Utility.urlEncode((String)this.stacktrace));
        sb.append("&tt=").append(this.platformType);
        sb.append("&fw=").append(this.forwardToGrail ? "1" : "0");
        return sb;
    }
}

