/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.agent.AgentUtil;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.mixed.WebRequestTraceContext;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CallbackCore;
import com.dynatrace.android.callback.CbWebReqTracker;
import com.dynatrace.android.callback.OkRequestStateParms;
import java.io.IOException;
import java.util.WeakHashMap;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class OkInterceptor
implements Interceptor {
    static final OkInterceptor theInterceptor = new OkInterceptor();
    private static final String LOGTAG = Global.LOG_PREFIX + "OkInterceptor";
    static WeakHashMap<Request, CbWebReqTracker> reqTracker = new WeakHashMap();

    private OkInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        WebReqTag tag;
        CbWebReqTracker webReqState;
        if (!Global.isAlive.get()) {
            return chain.proceed(chain.request());
        }
        Request curReq = chain.request();
        Request origReq = this.fetchOrigReq(curReq);
        CbWebReqTracker cbWebReqTracker = webReqState = origReq == null ? null : reqTracker.get(origReq);
        if (webReqState == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("missed request %s - orig hc=%s, cur hc=%s", curReq.url().toString(), origReq == null ? 0 : origReq.hashCode(), curReq.hashCode()));
            }
            return chain.proceed(curReq);
        }
        String dtTag = curReq.header(Dynatrace.getRequestTagHeader());
        if (dtTag == null) {
            return chain.proceed(this.tagRequest(curReq, webReqState));
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)String.format("Existing %s - linked to hc=%s", dtTag, origReq == null ? 0 : origReq.hashCode()));
        }
        WeakHashMap<Request, CbWebReqTracker> weakHashMap = reqTracker;
        synchronized (weakHashMap) {
            reqTracker.remove(origReq);
        }
        DTXAutoAction action = webReqState.action;
        if (action != null && (tag = webReqState.webReqTag) != null) {
            action.onWrFinished(tag.getParentTagId());
        }
        webReqState.setWebReqTag(null);
        return chain.proceed(curReq);
    }

    Request fetchOrigReq(Request srcReq) {
        if (srcReq == null) {
            return null;
        }
        if (reqTracker.containsKey(srcReq)) {
            return srcReq;
        }
        Request req = srcReq;
        Object obj = srcReq.tag();
        while (!req.equals(obj) && obj instanceof Request) {
            req = (Request)obj;
            if (reqTracker.containsKey(req)) {
                return req;
            }
            obj = req.tag();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CbWebReqTracker addRequest(Request request, OkRequestStateParms stateParm) {
        if (request == null) {
            return null;
        }
        if (!CallbackCore.isInitialized.get()) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"OneAgent not correctly initialized");
            }
            return null;
        }
        if (!Dynatrace.getCaptureStatus() || !Session.currentSession().getPrivacyRules().shouldCollectEvent(EventType.WEB_REQUEST)) {
            return null;
        }
        String dtTag = request.header(Dynatrace.getRequestTagHeader());
        if (dtTag != null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("Ignore WR %s to %s (hc=%d)", request.getClass().getName(), stateParm.getRequestDesc(), stateParm.request.hashCode()));
            }
            return null;
        }
        String xDtcTag = request.header("x-dtc");
        if (xDtcTag != null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)("Ignore WR, request already tagged with x-dtc: " + xDtcTag));
            }
            return null;
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)String.format("Add WR %s to %s (hc=%d)", request.getClass().getName(), stateParm.getRequestDesc(), stateParm.request.hashCode()));
        }
        if (!CallbackCore.configuration.webRequestTiming) {
            return null;
        }
        DTXAutoAction action = DTXAutoAction.getAutoAction();
        WebReqTag tag = this.generateWebReqTag(action);
        if (tag == null) {
            return null;
        }
        CbWebReqTracker webReqState = new CbWebReqTracker(action, tag.getSession());
        webReqState.stateParm = stateParm;
        webReqState.setWebReqTag(tag);
        WeakHashMap<Request, CbWebReqTracker> weakHashMap = reqTracker;
        synchronized (weakHashMap) {
            reqTracker.put(request, webReqState);
        }
        return webReqState;
    }

    private WebReqTag generateWebReqTag(DTXAutoAction action) {
        WebReqTag dtTag;
        if (action != null && (dtTag = AgentUtil.internalTagRequest((DTXActionImpl)action)) != null) {
            return dtTag;
        }
        return AgentUtil.getRequestTag();
    }

    Request tagRequest(Request curReq, CbWebReqTracker webReqState) {
        if (webReqState == null) {
            return curReq;
        }
        Request.Builder taggedBuilder = curReq.newBuilder();
        OkRequestStateParms stateParm = (OkRequestStateParms)webReqState.stateParm;
        WebReqTag dtTag = webReqState.webReqTag;
        if (dtTag != null) {
            if (dtTag.getSession().isGrailEventsShouldBeCaptured()) {
                WebRequestTraceContext traceContext = new WebRequestTraceContext();
                webReqState.setTraceContext(traceContext);
                String traceparentId = traceContext.getTraceparentId();
                taggedBuilder.header("traceparent", traceparentId);
                Utility.devLog((String)"dtxEventGeneration", (String)("okhttp traceparent header is defined: " + traceparentId));
            }
            Request taggedReq = taggedBuilder.header(Dynatrace.getRequestTagHeader(), dtTag.toString()).build();
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("Tagged WR %s (hc=%d) with %s", stateParm.getRequestDesc(), stateParm.request.hashCode(), dtTag));
            }
            return taggedReq;
        }
        webReqState.setWebReqTag(null);
        return taggedBuilder.build();
    }
}

