/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.view;

import com.dynatrace.agent.util.HexGenerator;
import com.dynatrace.agent.view.ViewContext;
import com.dynatrace.agent.view.ViewSummary;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/dynatrace/agent/view/ViewSummarizer;", "", "<init>", "()V", "viewContext", "Lcom/dynatrace/agent/view/ViewContext;", "creationTimeMs", "", "errorCount", "", "errorExceptionCount", "errorHttp4xxCount", "errorHttp5xxCount", "errorHttpOtherCount", "errorRequestOtherCount", "hasCrash", "", "resetViewSummary", "", "openViewSummary", "viewName", "", "obtainViewContext", "incorporateEvent", "jsonEvent", "Lorg/json/JSONObject;", "generateViewSummary", "Lcom/dynatrace/agent/view/ViewSummary;", "endTimeMs", "com.dynatrace.agent_release"})
public final class ViewSummarizer {
    @Nullable
    private ViewContext viewContext;
    private long creationTimeMs;
    private int errorCount;
    private int errorExceptionCount;
    private int errorHttp4xxCount;
    private int errorHttp5xxCount;
    private int errorHttpOtherCount;
    private int errorRequestOtherCount;
    private boolean hasCrash;

    public final void resetViewSummary() {
        this.viewContext = null;
        this.creationTimeMs = 0L;
        this.errorCount = 0;
        this.errorExceptionCount = 0;
        this.errorHttp4xxCount = 0;
        this.errorHttp5xxCount = 0;
        this.errorHttpOtherCount = 0;
        this.errorRequestOtherCount = 0;
        this.hasCrash = false;
    }

    public final void openViewSummary(@NotNull String viewName, long creationTimeMs) {
        Intrinsics.checkNotNullParameter((Object)viewName, (String)"viewName");
        this.creationTimeMs = creationTimeMs;
        this.viewContext = new ViewContext(HexGenerator.generateRandomHex(8), viewName);
    }

    @Nullable
    public final ViewContext obtainViewContext() {
        return this.viewContext;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void incorporateEvent(@NotNull JSONObject jsonEvent) {
        boolean hasFailedRequest;
        boolean hasException;
        block9: {
            block8: {
                int n;
                Intrinsics.checkNotNullParameter((Object)jsonEvent, (String)"jsonEvent");
                boolean hasRequest = jsonEvent.optBoolean("characteristics.has_request");
                boolean hasError = jsonEvent.optBoolean("characteristics.has_error");
                hasException = jsonEvent.optBoolean("characteristics.has_exception");
                hasFailedRequest = jsonEvent.optBoolean("characteristics.has_failed_request");
                int statusCode = jsonEvent.optInt("http.response.status_code", -1);
                boolean bl = this.hasCrash = this.hasCrash || jsonEvent.optBoolean("characteristics.has_crash");
                if (hasException) {
                    n = this.errorExceptionCount;
                    this.errorExceptionCount = n + 1;
                }
                if (hasError) {
                    n = this.errorCount;
                    this.errorCount = n + 1;
                }
                if (!hasRequest) return;
                n = statusCode;
                boolean bl2 = 400 <= n ? n < 500 : false;
                if (bl2) {
                    int n2 = this.errorHttp4xxCount;
                    this.errorHttp4xxCount = n2 + 1;
                    return;
                }
                boolean bl3 = 500 <= n ? n < 600 : false;
                if (bl3) {
                    int n3 = this.errorHttp5xxCount;
                    this.errorHttp5xxCount = n3 + 1;
                    return;
                }
                if (0 <= n ? n < 100 : false) break block8;
                boolean bl4 = 600 <= n ? n <= Integer.MAX_VALUE : false;
                if (!bl4) break block9;
            }
            int n = this.errorHttpOtherCount;
            this.errorHttpOtherCount = n + 1;
            return;
        }
        if (!hasFailedRequest) {
            if (!hasException) return;
        }
        int n = this.errorRequestOtherCount;
        this.errorRequestOtherCount = n + 1;
    }

    @NotNull
    public final ViewSummary generateViewSummary(long endTimeMs) {
        return new ViewSummary(this.creationTimeMs, endTimeMs - this.creationTimeMs, this.errorCount, this.errorExceptionCount, this.errorHttp4xxCount, this.errorHttp5xxCount, this.errorHttpOtherCount, this.errorRequestOtherCount, this.hasCrash);
    }
}

