/*
 * Decompiled with CFR 0.152.
 */
package com.dwolla.java.sdk.requests;

import com.dwolla.java.sdk.models.AdditionalFee;
import java.util.Arrays;

public class SendRequest {
    public String oauth_token;
    public String pin;
    public String destinationId;
    public double amount;
    public boolean assumeCosts = false;
    public String destinationType = null;
    public String facilitatorAmount = null;
    public String notes = null;
    public String fundsSource = null;
    public AdditionalFee[] additionalFees = null;

    public SendRequest(String oauth_token, String pin, String destinationId, double amount) {
        this.oauth_token = oauth_token;
        this.pin = pin;
        this.destinationId = destinationId;
        this.amount = amount;
    }

    public SendRequest(String oauth_token, String pin, String destinationId, double amount, boolean assumeCosts, String destinationType, String facilitatorAmount, String notes, String fundsSource, AdditionalFee[] additionalFees) {
        this.oauth_token = oauth_token;
        this.pin = pin;
        this.destinationId = destinationId;
        this.amount = amount;
        this.assumeCosts = assumeCosts;
        this.destinationType = destinationType;
        this.facilitatorAmount = facilitatorAmount;
        this.notes = notes;
        this.fundsSource = fundsSource;
        this.additionalFees = additionalFees;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.additionalFees);
        long temp = Double.doubleToLongBits(this.amount);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.assumeCosts ? 1231 : 1237);
        result = 31 * result + (this.destinationId == null ? 0 : this.destinationId.hashCode());
        result = 31 * result + (this.destinationType == null ? 0 : this.destinationType.hashCode());
        result = 31 * result + (this.facilitatorAmount == null ? 0 : this.facilitatorAmount.hashCode());
        result = 31 * result + (this.fundsSource == null ? 0 : this.fundsSource.hashCode());
        result = 31 * result + (this.notes == null ? 0 : this.notes.hashCode());
        result = 31 * result + (this.oauth_token == null ? 0 : this.oauth_token.hashCode());
        result = 31 * result + (this.pin == null ? 0 : this.pin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SendRequest other = (SendRequest)obj;
        if (!Arrays.equals(this.additionalFees, other.additionalFees)) {
            return false;
        }
        if (Double.doubleToLongBits(this.amount) != Double.doubleToLongBits(other.amount)) {
            return false;
        }
        if (this.assumeCosts != other.assumeCosts) {
            return false;
        }
        if (this.destinationId == null ? other.destinationId != null : !this.destinationId.equals(other.destinationId)) {
            return false;
        }
        if (this.destinationType == null ? other.destinationType != null : !this.destinationType.equals(other.destinationType)) {
            return false;
        }
        if (this.facilitatorAmount == null ? other.facilitatorAmount != null : !this.facilitatorAmount.equals(other.facilitatorAmount)) {
            return false;
        }
        if (this.fundsSource == null ? other.fundsSource != null : !this.fundsSource.equals(other.fundsSource)) {
            return false;
        }
        if (this.notes == null ? other.notes != null : !this.notes.equals(other.notes)) {
            return false;
        }
        if (this.oauth_token == null ? other.oauth_token != null : !this.oauth_token.equals(other.oauth_token)) {
            return false;
        }
        return !(this.pin == null ? other.pin != null : !this.pin.equals(other.pin));
    }
}

