/*
 * Decompiled with CFR 0.152.
 */
package com.dwolla.java.sdk;

import com.dwolla.java.sdk.DwollaTypedBytes;
import com.dwolla.java.sdk.responses.AccountInformationResponse;
import com.dwolla.java.sdk.responses.BalanceResponse;
import com.dwolla.java.sdk.responses.BasicAccountInformationResponse;
import com.dwolla.java.sdk.responses.DepositWithdrawResponse;
import com.dwolla.java.sdk.responses.FulfillRequestResponse;
import com.dwolla.java.sdk.responses.FundingSourcesByIdResponse;
import com.dwolla.java.sdk.responses.FundingSourcesListingResponse;
import com.dwolla.java.sdk.responses.NearbySpotsResponse;
import com.dwolla.java.sdk.responses.NearbyUsersResponse;
import com.dwolla.java.sdk.responses.PendingRequestsResponse;
import com.dwolla.java.sdk.responses.RequestResponse;
import com.dwolla.java.sdk.responses.SendResponse;
import com.dwolla.java.sdk.responses.TransactionResponse;
import com.dwolla.java.sdk.responses.TransactionsResponse;
import com.dwolla.java.sdk.responses.UserContactsResponse;
import retrofit.http.Body;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.Query;

public interface DwollaServiceSync {
    @GET(value="/balance/")
    public BalanceResponse getBalance(@Query(value="oauth_token") String var1);

    @GET(value="/contacts/nearby")
    public NearbySpotsResponse getNearbySpots(@Query(value="client_id") String var1, @Query(value="client_secret") String var2, @Query(value="latitude") double var3, @Query(value="longitude") double var5, @Query(value="range") int var7, @Query(value="limit") int var8);

    @GET(value="/contacts/")
    public UserContactsResponse getUserContacts(@Query(value="oauth_token") String var1, @Query(value="search") String var2, @Query(value="types") String var3, @Query(value="limit") int var4);

    @GET(value="/fundingsources/{funding_id}")
    public FundingSourcesByIdResponse getFundingSourcesById(@Query(value="oauth_token") String var1, @Path(value="funding_id") String var2);

    @GET(value="/fundingsources/")
    public FundingSourcesListingResponse getFundingSourcesListing(@Query(value="oauth_token") String var1);

    @POST(value="/fundingsources/{funding_id}/deposit")
    public DepositWithdrawResponse deposit(@Body DwollaTypedBytes var1, @Path(value="funding_id") String var2);

    @POST(value="/fundingsources/{funding_id}/withdraw")
    public DepositWithdrawResponse withdraw(@Body DwollaTypedBytes var1, @Path(value="funding_id") String var2);

    @GET(value="/requests/")
    public PendingRequestsResponse getPendingRequests(@Query(value="oauth_token") String var1);

    @POST(value="/requests/{request_id}/fulfill")
    public FulfillRequestResponse fulfillRequest(@Body DwollaTypedBytes var1, @Path(value="request_id") String var2);

    @POST(value="/requests/")
    public RequestResponse request(@Body DwollaTypedBytes var1);

    @GET(value="/transactions/")
    public TransactionsResponse getTransactions(@Query(value="oauth_token") String var1, @Query(value="client_id") String var2, @Query(value="client_secret") String var3, @Query(value="since_date") String var4, @Query(value="types") String var5, @Query(value="limit") int var6, @Query(value="skip") int var7, @Query(value="group_id") String var8);

    @GET(value="/transactions/{transaction_id}")
    public TransactionResponse getTransaction(@Query(value="oauth_token") String var1, @Path(value="transaction_id") String var2);

    @POST(value="/transactions/send")
    public SendResponse send(@Body DwollaTypedBytes var1);

    @GET(value="/users/")
    public AccountInformationResponse getAccountInformation(@Query(value="oauth_token") String var1);

    @GET(value="/users/{account_identifier}")
    public BasicAccountInformationResponse getBasicAccountInformation(@Path(value="account_identifier") String var1, @Query(value="client_id") String var2, @Query(value="client_secret") String var3);

    @GET(value="/users/nearby")
    public NearbyUsersResponse getNearbyUsers(@Query(value="client_id") String var1, @Query(value="client_secret") String var2, @Query(value="latitude") double var3, @Query(value="longitude") double var5);
}

