/*
 * Decompiled with CFR 0.152.
 */
package com.dwolla.java.sdk;

import com.dwolla.java.sdk.DwollaTypedBytes;
import com.dwolla.java.sdk.responses.AccountInformationResponse;
import com.dwolla.java.sdk.responses.BalanceResponse;
import com.dwolla.java.sdk.responses.BasicAccountInformationResponse;
import com.dwolla.java.sdk.responses.DepositWithdrawResponse;
import com.dwolla.java.sdk.responses.FulfillRequestResponse;
import com.dwolla.java.sdk.responses.FundingSourcesByIdResponse;
import com.dwolla.java.sdk.responses.FundingSourcesListingResponse;
import com.dwolla.java.sdk.responses.NearbySpotsResponse;
import com.dwolla.java.sdk.responses.NearbyUsersResponse;
import com.dwolla.java.sdk.responses.PendingRequestsResponse;
import com.dwolla.java.sdk.responses.RequestResponse;
import com.dwolla.java.sdk.responses.SendResponse;
import com.dwolla.java.sdk.responses.TransactionResponse;
import com.dwolla.java.sdk.responses.TransactionsResponse;
import com.dwolla.java.sdk.responses.UserContactsResponse;
import retrofit.Callback;
import retrofit.http.Body;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.Query;

public interface DwollaServiceAsync {
    @GET(value="/balance/")
    public void getBalance(@Query(value="oauth_token") String var1, Callback<BalanceResponse> var2);

    @GET(value="/contacts/nearby")
    public void getNearbySpots(@Query(value="client_id") String var1, @Query(value="client_secret") String var2, @Query(value="latitude") double var3, @Query(value="longitude") double var5, @Query(value="range") int var7, @Query(value="limit") int var8, Callback<NearbySpotsResponse> var9);

    @GET(value="/contacts/")
    public void getUserContacts(@Query(value="oauth_token") String var1, @Query(value="search") String var2, @Query(value="types") String var3, @Query(value="limit") int var4, Callback<UserContactsResponse> var5);

    @GET(value="/fundingsources/{funding_id}")
    public void getFundingSourcesById(@Query(value="oauth_token") String var1, @Path(value="funding_id") String var2, Callback<FundingSourcesByIdResponse> var3);

    @GET(value="/fundingsources/")
    public void getFundingSourcesListing(@Query(value="oauth_token") String var1, Callback<FundingSourcesListingResponse> var2);

    @POST(value="/fundingsources/{funding_id}/deposit")
    public void deposit(@Body DwollaTypedBytes var1, @Path(value="funding_id") String var2, Callback<DepositWithdrawResponse> var3);

    @POST(value="/fundingsources/{funding_id}/withdraw")
    public void withdraw(@Body DwollaTypedBytes var1, @Path(value="funding_id") String var2, Callback<DepositWithdrawResponse> var3);

    @GET(value="/requests/")
    public void getPendingRequests(@Query(value="oauth_token") String var1, Callback<PendingRequestsResponse> var2);

    @POST(value="/requests/{request_id}/fulfill")
    public void fulfillRequest(@Body DwollaTypedBytes var1, @Path(value="request_id") String var2, Callback<FulfillRequestResponse> var3);

    @POST(value="/requests/")
    public void request(@Body DwollaTypedBytes var1, Callback<RequestResponse> var2);

    @GET(value="/transactions/")
    public void getTransactions(@Query(value="oauth_token") String var1, @Query(value="client_id") String var2, @Query(value="client_secret") String var3, @Query(value="since_date") String var4, @Query(value="types") String var5, @Query(value="limit") int var6, @Query(value="skip") int var7, @Query(value="group_id") String var8, Callback<TransactionsResponse> var9);

    @GET(value="/transactions/{transaction_id}")
    public void getTransaction(@Query(value="oauth_token") String var1, @Path(value="transaction_id") String var2, Callback<TransactionResponse> var3);

    @POST(value="/transactions/send")
    public void send(@Body DwollaTypedBytes var1, Callback<SendResponse> var2);

    @GET(value="/users/")
    public void getAccountInformation(@Query(value="oauth_token") String var1, Callback<AccountInformationResponse> var2);

    @GET(value="/users/{account_identifier}")
    public void getBasicAccountInformation(@Path(value="account_identifier") String var1, @Query(value="client_id") String var2, @Query(value="client_secret") String var3, Callback<BasicAccountInformationResponse> var4);

    @GET(value="/users/nearby")
    public void getNearbyUsers(@Query(value="client_id") String var1, @Query(value="client_secret") String var2, @Query(value="latitude") double var3, @Query(value="longitude") double var5, Callback<NearbyUsersResponse> var7);
}

