/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.monitor.model;

import com.docusign.monitor.model.Aggregation;
import com.docusign.monitor.model.Filter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class WebQuery {
    @JsonProperty(value="filters")
    private List<Filter> filters = null;
    @JsonProperty(value="aggregations")
    private List<Aggregation> aggregations = null;
    @JsonProperty(value="queryScope")
    private QueryScopeEnum queryScope = null;
    @JsonProperty(value="queryScopeId")
    private UUID queryScopeId = null;

    public WebQuery filters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public WebQuery addFiltersItem(Filter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public WebQuery aggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public WebQuery addAggregationsItem(Aggregation aggregationsItem) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<Aggregation>();
        }
        this.aggregations.add(aggregationsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Aggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public WebQuery queryScope(QueryScopeEnum queryScope) {
        this.queryScope = queryScope;
        return this;
    }

    @ApiModelProperty(value="")
    public QueryScopeEnum getQueryScope() {
        return this.queryScope;
    }

    public void setQueryScope(QueryScopeEnum queryScope) {
        this.queryScope = queryScope;
    }

    public WebQuery queryScopeId(UUID queryScopeId) {
        this.queryScopeId = queryScopeId;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getQueryScopeId() {
        return this.queryScopeId;
    }

    public void setQueryScopeId(UUID queryScopeId) {
        this.queryScopeId = queryScopeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebQuery webQuery = (WebQuery)o;
        return Objects.equals(this.filters, webQuery.filters) && Objects.equals(this.aggregations, webQuery.aggregations) && Objects.equals((Object)this.queryScope, (Object)webQuery.queryScope) && Objects.equals(this.queryScopeId, webQuery.queryScopeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filters, this.aggregations, this.queryScope, this.queryScopeId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebQuery {\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    queryScope: ").append(this.toIndentedString((Object)this.queryScope)).append("\n");
        sb.append("    queryScopeId: ").append(this.toIndentedString(this.queryScopeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum QueryScopeEnum {
        ACCOUNTID("AccountId"),
        ORGANIZATIONID("OrganizationId"),
        NONE("None");

        private String value;

        private QueryScopeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static QueryScopeEnum fromValue(String text) {
            for (QueryScopeEnum b : QueryScopeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

