/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.monitor.api;

import com.docusign.monitor.client.ApiClient;
import com.docusign.monitor.client.ApiException;
import com.docusign.monitor.client.Configuration;
import com.docusign.monitor.client.Pair;
import com.docusign.monitor.model.CursoredResult;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class DataSetApi {
    private ApiClient apiClient;

    public DataSetApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataSetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CursoredResult getStream(String version, String dataSetName) throws ApiException {
        return this.getStream(version, dataSetName, null);
    }

    public CursoredResult getStream(String version, String dataSetName, GetStreamOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling getStream");
        }
        if (dataSetName == null) {
            throw new ApiException(400, "Missing the required parameter 'dataSetName' when calling getStream");
        }
        String localVarPath = "/api/v{version}/datasets/{dataSetName}/stream".replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{dataSetName\\}", this.apiClient.escapeString(dataSetName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", options.cursor));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", options.limit));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CursoredResult> localVarReturnType = new GenericType<CursoredResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetStreamOptions {
        private String cursor = null;
        private Integer limit = null;

        public void setCursor(String cursor) {
            this.cursor = cursor;
        }

        public String getCursor() {
            return this.cursor;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public Integer getLimit() {
            return this.limit;
        }
    }
}

