/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Checkbox;
import com.docusign.esign.model.Date;
import com.docusign.esign.model.Email;
import com.docusign.esign.model.Number;
import com.docusign.esign.model.RadioGroup;
import com.docusign.esign.model.SenderCompany;
import com.docusign.esign.model.SenderName;
import com.docusign.esign.model.Ssn;
import com.docusign.esign.model.TabGroup;
import com.docusign.esign.model.Text;
import com.docusign.esign.model.Zip;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Prefill tabs are tabs that the sender can fill in before the envelope is sent. They are sometimes called sender tags or pre-fill fields.  Only the following tab types can be prefill tabs:  - text - check boxes - radio buttons    [Pre-Fill Your Own Document Fields][app] describes how prefill tabs work in the web application.   [Customize your envelopes with pre-fill fields][catblog] shows how to use prefill tabs in your application using the eSignature SDKs.  [app]:      https://support.docusign.com/en/guides/ndse-user-guide-prefill-fields [catblog]:  https://www.docusign.com/blog/developers/common-api-tasks-customize-your-envelopes-pre-fill-fields")
public class PrefillTabs {
    @JsonProperty(value="checkboxTabs")
    private List<Checkbox> checkboxTabs = null;
    @JsonProperty(value="dateTabs")
    private List<Date> dateTabs = null;
    @JsonProperty(value="emailTabs")
    private List<Email> emailTabs = null;
    @JsonProperty(value="numberTabs")
    private List<Number> numberTabs = null;
    @JsonProperty(value="radioGroupTabs")
    private List<RadioGroup> radioGroupTabs = null;
    @JsonProperty(value="senderCompanyTabs")
    private List<SenderCompany> senderCompanyTabs = null;
    @JsonProperty(value="senderNameTabs")
    private List<SenderName> senderNameTabs = null;
    @JsonProperty(value="ssnTabs")
    private List<Ssn> ssnTabs = null;
    @JsonProperty(value="tabGroups")
    private List<TabGroup> tabGroups = null;
    @JsonProperty(value="textTabs")
    private List<Text> textTabs = null;
    @JsonProperty(value="zipTabs")
    private List<Zip> zipTabs = null;

    public PrefillTabs checkboxTabs(List<Checkbox> checkboxTabs) {
        this.checkboxTabs = checkboxTabs;
        return this;
    }

    public PrefillTabs addCheckboxTabsItem(Checkbox checkboxTabsItem) {
        if (this.checkboxTabs == null) {
            this.checkboxTabs = new ArrayList<Checkbox>();
        }
        this.checkboxTabs.add(checkboxTabsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies a tag on the document in a location where the recipient can select an option.")
    public List<Checkbox> getCheckboxTabs() {
        return this.checkboxTabs;
    }

    public void setCheckboxTabs(List<Checkbox> checkboxTabs) {
        this.checkboxTabs = checkboxTabs;
    }

    public PrefillTabs dateTabs(List<Date> dateTabs) {
        this.dateTabs = dateTabs;
        return this;
    }

    public PrefillTabs addDateTabsItem(Date dateTabsItem) {
        if (this.dateTabs == null) {
            this.dateTabs = new ArrayList<Date>();
        }
        this.dateTabs.add(dateTabsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies a tab on the document where you want the recipient to enter a date. Date tabs are single-line fields that allow date information to be entered in any format. The tooltip for this tab recommends entering the date as MM/DD/YYYY, but this is not enforced. The format entered by the signer is retained.   If you need a particular date format enforced, DocuSign recommends using a Text tab with a Validation Pattern and Validation Message to enforce the format.")
    public List<Date> getDateTabs() {
        return this.dateTabs;
    }

    public void setDateTabs(List<Date> dateTabs) {
        this.dateTabs = dateTabs;
    }

    public PrefillTabs emailTabs(List<Email> emailTabs) {
        this.emailTabs = emailTabs;
        return this;
    }

    public PrefillTabs addEmailTabsItem(Email emailTabsItem) {
        if (this.emailTabs == null) {
            this.emailTabs = new ArrayList<Email>();
        }
        this.emailTabs.add(emailTabsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies a tag on the document where you want the recipient to enter an email. Email tags are single-line fields that accept any characters. The system checks that a valid email format (i.e. xxx@yyy.zzz) is entered in the tag. It uses the same parameters as a Text tab, with the validation message and pattern set for email information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.")
    public List<Email> getEmailTabs() {
        return this.emailTabs;
    }

    public void setEmailTabs(List<Email> emailTabs) {
        this.emailTabs = emailTabs;
    }

    public PrefillTabs numberTabs(List<Number> numberTabs) {
        this.numberTabs = numberTabs;
        return this;
    }

    public PrefillTabs addNumberTabsItem(Number numberTabsItem) {
        if (this.numberTabs == null) {
            this.numberTabs = new ArrayList<Number>();
        }
        this.numberTabs.add(numberTabsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies a tag on the document where you want the recipient to enter a number. It uses the same parameters as a Text tab, with the validation message and pattern set for number information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response. ")
    public List<Number> getNumberTabs() {
        return this.numberTabs;
    }

    public void setNumberTabs(List<Number> numberTabs) {
        this.numberTabs = numberTabs;
    }

    public PrefillTabs radioGroupTabs(List<RadioGroup> radioGroupTabs) {
        this.radioGroupTabs = radioGroupTabs;
        return this;
    }

    public PrefillTabs addRadioGroupTabsItem(RadioGroup radioGroupTabsItem) {
        if (this.radioGroupTabs == null) {
            this.radioGroupTabs = new ArrayList<RadioGroup>();
        }
        this.radioGroupTabs.add(radioGroupTabsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies a tag on the document in a location where the recipient can select one option from a group of options using a radio button. The radio buttons do not have to be on the same page in a document.")
    public List<RadioGroup> getRadioGroupTabs() {
        return this.radioGroupTabs;
    }

    public void setRadioGroupTabs(List<RadioGroup> radioGroupTabs) {
        this.radioGroupTabs = radioGroupTabs;
    }

    public PrefillTabs senderCompanyTabs(List<SenderCompany> senderCompanyTabs) {
        this.senderCompanyTabs = senderCompanyTabs;
        return this;
    }

    public PrefillTabs addSenderCompanyTabsItem(SenderCompany senderCompanyTabsItem) {
        if (this.senderCompanyTabs == null) {
            this.senderCompanyTabs = new ArrayList<SenderCompany>();
        }
        this.senderCompanyTabs.add(senderCompanyTabsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SenderCompany> getSenderCompanyTabs() {
        return this.senderCompanyTabs;
    }

    public void setSenderCompanyTabs(List<SenderCompany> senderCompanyTabs) {
        this.senderCompanyTabs = senderCompanyTabs;
    }

    public PrefillTabs senderNameTabs(List<SenderName> senderNameTabs) {
        this.senderNameTabs = senderNameTabs;
        return this;
    }

    public PrefillTabs addSenderNameTabsItem(SenderName senderNameTabsItem) {
        if (this.senderNameTabs == null) {
            this.senderNameTabs = new ArrayList<SenderName>();
        }
        this.senderNameTabs.add(senderNameTabsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SenderName> getSenderNameTabs() {
        return this.senderNameTabs;
    }

    public void setSenderNameTabs(List<SenderName> senderNameTabs) {
        this.senderNameTabs = senderNameTabs;
    }

    public PrefillTabs ssnTabs(List<Ssn> ssnTabs) {
        this.ssnTabs = ssnTabs;
        return this;
    }

    public PrefillTabs addSsnTabsItem(Ssn ssnTabsItem) {
        if (this.ssnTabs == null) {
            this.ssnTabs = new ArrayList<Ssn>();
        }
        this.ssnTabs.add(ssnTabsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies a tag on the document where you want the recipient to enter a Social Security Number (SSN). A SSN can be typed with or without dashes. It uses the same parameters as a Text tab, with the validation message and pattern set for SSN information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.")
    public List<Ssn> getSsnTabs() {
        return this.ssnTabs;
    }

    public void setSsnTabs(List<Ssn> ssnTabs) {
        this.ssnTabs = ssnTabs;
    }

    public PrefillTabs tabGroups(List<TabGroup> tabGroups) {
        this.tabGroups = tabGroups;
        return this;
    }

    public PrefillTabs addTabGroupsItem(TabGroup tabGroupsItem) {
        if (this.tabGroups == null) {
            this.tabGroups = new ArrayList<TabGroup>();
        }
        this.tabGroups.add(tabGroupsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TabGroup> getTabGroups() {
        return this.tabGroups;
    }

    public void setTabGroups(List<TabGroup> tabGroups) {
        this.tabGroups = tabGroups;
    }

    public PrefillTabs textTabs(List<Text> textTabs) {
        this.textTabs = textTabs;
        return this;
    }

    public PrefillTabs addTextTabsItem(Text textTabsItem) {
        if (this.textTabs == null) {
            this.textTabs = new ArrayList<Text>();
        }
        this.textTabs.add(textTabsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies a that that is an adaptable field that allows the recipient to enter different text information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.")
    public List<Text> getTextTabs() {
        return this.textTabs;
    }

    public void setTextTabs(List<Text> textTabs) {
        this.textTabs = textTabs;
    }

    public PrefillTabs zipTabs(List<Zip> zipTabs) {
        this.zipTabs = zipTabs;
        return this;
    }

    public PrefillTabs addZipTabsItem(Zip zipTabsItem) {
        if (this.zipTabs == null) {
            this.zipTabs = new ArrayList<Zip>();
        }
        this.zipTabs.add(zipTabsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies a tag on the document where you want the recipient to enter a ZIP code. The ZIP code can be a five numbers or the ZIP+4 format with nine numbers. The zip code can be typed with or without dashes. It uses the same parameters as a Text tab, with the validation message and pattern set for ZIP code information.  When getting information that includes this tab type, the original value of the tab when the associated envelope was sent is included in the response.")
    public List<Zip> getZipTabs() {
        return this.zipTabs;
    }

    public void setZipTabs(List<Zip> zipTabs) {
        this.zipTabs = zipTabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefillTabs prefillTabs = (PrefillTabs)o;
        return Objects.equals(this.checkboxTabs, prefillTabs.checkboxTabs) && Objects.equals(this.dateTabs, prefillTabs.dateTabs) && Objects.equals(this.emailTabs, prefillTabs.emailTabs) && Objects.equals(this.numberTabs, prefillTabs.numberTabs) && Objects.equals(this.radioGroupTabs, prefillTabs.radioGroupTabs) && Objects.equals(this.senderCompanyTabs, prefillTabs.senderCompanyTabs) && Objects.equals(this.senderNameTabs, prefillTabs.senderNameTabs) && Objects.equals(this.ssnTabs, prefillTabs.ssnTabs) && Objects.equals(this.tabGroups, prefillTabs.tabGroups) && Objects.equals(this.textTabs, prefillTabs.textTabs) && Objects.equals(this.zipTabs, prefillTabs.zipTabs);
    }

    public int hashCode() {
        return Objects.hash(this.checkboxTabs, this.dateTabs, this.emailTabs, this.numberTabs, this.radioGroupTabs, this.senderCompanyTabs, this.senderNameTabs, this.ssnTabs, this.tabGroups, this.textTabs, this.zipTabs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrefillTabs {\n");
        sb.append("    checkboxTabs: ").append(this.toIndentedString(this.checkboxTabs)).append("\n");
        sb.append("    dateTabs: ").append(this.toIndentedString(this.dateTabs)).append("\n");
        sb.append("    emailTabs: ").append(this.toIndentedString(this.emailTabs)).append("\n");
        sb.append("    numberTabs: ").append(this.toIndentedString(this.numberTabs)).append("\n");
        sb.append("    radioGroupTabs: ").append(this.toIndentedString(this.radioGroupTabs)).append("\n");
        sb.append("    senderCompanyTabs: ").append(this.toIndentedString(this.senderCompanyTabs)).append("\n");
        sb.append("    senderNameTabs: ").append(this.toIndentedString(this.senderNameTabs)).append("\n");
        sb.append("    ssnTabs: ").append(this.toIndentedString(this.ssnTabs)).append("\n");
        sb.append("    tabGroups: ").append(this.toIndentedString(this.tabGroups)).append("\n");
        sb.append("    textTabs: ").append(this.toIndentedString(this.textTabs)).append("\n");
        sb.append("    zipTabs: ").append(this.toIndentedString(this.zipTabs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

