/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ConnectEventData;
import com.docusign.esign.model.ConnectSalesforceObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The `connectCustomConfiguration` object describes how Connect is configured for your account.")
public class ConnectCustomConfiguration {
    @JsonProperty(value="allowEnvelopePublish")
    private String allowEnvelopePublish = null;
    @JsonProperty(value="allowSalesforcePublish")
    private String allowSalesforcePublish = null;
    @JsonProperty(value="allUsers")
    private String allUsers = null;
    @JsonProperty(value="allUsersExcept")
    private String allUsersExcept = null;
    @JsonProperty(value="configurationType")
    private String configurationType = null;
    @JsonProperty(value="connectId")
    private String connectId = null;
    @JsonProperty(value="deliveryMode")
    private String deliveryMode = null;
    @JsonProperty(value="disabledBy")
    private String disabledBy = null;
    @JsonProperty(value="enableLog")
    private String enableLog = null;
    @JsonProperty(value="envelopeEvents")
    private List<String> envelopeEvents = null;
    @JsonProperty(value="eventData")
    private ConnectEventData eventData = null;
    @JsonProperty(value="events")
    private List<String> events = null;
    @JsonProperty(value="externalFolderId")
    private String externalFolderId = null;
    @JsonProperty(value="externalFolderLabel")
    private String externalFolderLabel = null;
    @JsonProperty(value="groupIds")
    private List<String> groupIds = null;
    @JsonProperty(value="includeCertificateOfCompletion")
    private String includeCertificateOfCompletion = null;
    @JsonProperty(value="includeCertSoapHeader")
    private String includeCertSoapHeader = null;
    @JsonProperty(value="includeDocumentFields")
    private String includeDocumentFields = null;
    @JsonProperty(value="includeDocuments")
    private String includeDocuments = null;
    @JsonProperty(value="includeEnvelopeVoidReason")
    private String includeEnvelopeVoidReason = null;
    @JsonProperty(value="includeHMAC")
    private String includeHMAC = null;
    @JsonProperty(value="includeSenderAccountasCustomField")
    private String includeSenderAccountasCustomField = null;
    @JsonProperty(value="includeTimeZoneInformation")
    private String includeTimeZoneInformation = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="recipientEvents")
    private List<String> recipientEvents = null;
    @JsonProperty(value="requireMutualTls")
    private String requireMutualTls = null;
    @JsonProperty(value="requiresAcknowledgement")
    private String requiresAcknowledgement = null;
    @JsonProperty(value="salesforceApiVersion")
    private String salesforceApiVersion = null;
    @JsonProperty(value="salesforceAuthcode")
    private String salesforceAuthcode = null;
    @JsonProperty(value="salesforceCallBackUrl")
    private String salesforceCallBackUrl = null;
    @JsonProperty(value="salesforceDocumentsAsContentFiles")
    private String salesforceDocumentsAsContentFiles = null;
    @JsonProperty(value="senderOverride")
    private String senderOverride = null;
    @JsonProperty(value="senderSelectableItems")
    private List<String> senderSelectableItems = null;
    @JsonProperty(value="sfObjects")
    private List<ConnectSalesforceObject> sfObjects = null;
    @JsonProperty(value="signMessageWithX509Certificate")
    private String signMessageWithX509Certificate = null;
    @JsonProperty(value="soapNamespace")
    private String soapNamespace = null;
    @JsonProperty(value="urlToPublishTo")
    private String urlToPublishTo = null;
    @JsonProperty(value="userIds")
    private List<String> userIds = null;
    @JsonProperty(value="userName")
    private String userName = null;
    @JsonProperty(value="useSoapInterface")
    private String useSoapInterface = null;

    public ConnectCustomConfiguration allowEnvelopePublish(String allowEnvelopePublish) {
        this.allowEnvelopePublish = allowEnvelopePublish;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, data is sent to the urlToPublishTo web address. This option can be set to false to stop sending data while maintaining the Connect configuration information.")
    public String getAllowEnvelopePublish() {
        return this.allowEnvelopePublish;
    }

    public void setAllowEnvelopePublish(String allowEnvelopePublish) {
        this.allowEnvelopePublish = allowEnvelopePublish;
    }

    public ConnectCustomConfiguration allowSalesforcePublish(String allowSalesforcePublish) {
        this.allowSalesforcePublish = allowSalesforcePublish;
        return this;
    }

    @ApiModelProperty(value="")
    public String getAllowSalesforcePublish() {
        return this.allowSalesforcePublish;
    }

    public void setAllowSalesforcePublish(String allowSalesforcePublish) {
        this.allowSalesforcePublish = allowSalesforcePublish;
    }

    public ConnectCustomConfiguration allUsers(String allUsers) {
        this.allUsers = allUsers;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, the tracked envelope and recipient events for all users, including users that are added a later time, are sent through Connect.")
    public String getAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(String allUsers) {
        this.allUsers = allUsers;
    }

    public ConnectCustomConfiguration allUsersExcept(String allUsersExcept) {
        this.allUsersExcept = allUsersExcept;
        return this;
    }

    @ApiModelProperty(value="")
    public String getAllUsersExcept() {
        return this.allUsersExcept;
    }

    public void setAllUsersExcept(String allUsersExcept) {
        this.allUsersExcept = allUsersExcept;
    }

    public ConnectCustomConfiguration configurationType(String configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    @ApiModelProperty(value="If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.")
    public String getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(String configurationType) {
        this.configurationType = configurationType;
    }

    public ConnectCustomConfiguration connectId(String connectId) {
        this.connectId = connectId;
        return this;
    }

    @ApiModelProperty(value=" Specifies the DocuSign generated ID for the Connect configuration.  ")
    public String getConnectId() {
        return this.connectId;
    }

    public void setConnectId(String connectId) {
        this.connectId = connectId;
    }

    public ConnectCustomConfiguration deliveryMode(String deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(String deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public ConnectCustomConfiguration disabledBy(String disabledBy) {
        this.disabledBy = disabledBy;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDisabledBy() {
        return this.disabledBy;
    }

    public void setDisabledBy(String disabledBy) {
        this.disabledBy = disabledBy;
    }

    public ConnectCustomConfiguration enableLog(String enableLog) {
        this.enableLog = enableLog;
        return this;
    }

    @ApiModelProperty(value="This turns Connect logging on or off. When set to **true**, logging is turned on.")
    public String getEnableLog() {
        return this.enableLog;
    }

    public void setEnableLog(String enableLog) {
        this.enableLog = enableLog;
    }

    public ConnectCustomConfiguration envelopeEvents(List<String> envelopeEvents) {
        this.envelopeEvents = envelopeEvents;
        return this;
    }

    public ConnectCustomConfiguration addEnvelopeEventsItem(String envelopeEventsItem) {
        if (this.envelopeEvents == null) {
            this.envelopeEvents = new ArrayList<String>();
        }
        this.envelopeEvents.add(envelopeEventsItem);
        return this;
    }

    @ApiModelProperty(value="A comma separated list of \u00ef\u00bf\u00bdEnvelope\u00ef\u00bf\u00bd related events that are tracked through Connect. The possible event values are: Sent, Delivered, Completed, Declined, and Voided.")
    public List<String> getEnvelopeEvents() {
        return this.envelopeEvents;
    }

    public void setEnvelopeEvents(List<String> envelopeEvents) {
        this.envelopeEvents = envelopeEvents;
    }

    public ConnectCustomConfiguration eventData(ConnectEventData eventData) {
        this.eventData = eventData;
        return this;
    }

    @ApiModelProperty(value="Allows you to specify the format of the information the Connect webhooks returns. For more information, see [Connect webhooks with JSON notifications](https://www.docusign.com/blog/developers/connect-webhooks-json-notifications)")
    public ConnectEventData getEventData() {
        return this.eventData;
    }

    public void setEventData(ConnectEventData eventData) {
        this.eventData = eventData;
    }

    public ConnectCustomConfiguration events(List<String> events) {
        this.events = events;
        return this;
    }

    public ConnectCustomConfiguration addEventsItem(String eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public ConnectCustomConfiguration externalFolderId(String externalFolderId) {
        this.externalFolderId = externalFolderId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getExternalFolderId() {
        return this.externalFolderId;
    }

    public void setExternalFolderId(String externalFolderId) {
        this.externalFolderId = externalFolderId;
    }

    public ConnectCustomConfiguration externalFolderLabel(String externalFolderLabel) {
        this.externalFolderLabel = externalFolderLabel;
        return this;
    }

    @ApiModelProperty(value="")
    public String getExternalFolderLabel() {
        return this.externalFolderLabel;
    }

    public void setExternalFolderLabel(String externalFolderLabel) {
        this.externalFolderLabel = externalFolderLabel;
    }

    public ConnectCustomConfiguration groupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public ConnectCustomConfiguration addGroupIdsItem(String groupIdsItem) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<String>();
        }
        this.groupIds.add(groupIdsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public ConnectCustomConfiguration includeCertificateOfCompletion(String includeCertificateOfCompletion) {
        this.includeCertificateOfCompletion = includeCertificateOfCompletion;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, the Connect Service includes the Certificate of Completion with completed envelopes. ")
    public String getIncludeCertificateOfCompletion() {
        return this.includeCertificateOfCompletion;
    }

    public void setIncludeCertificateOfCompletion(String includeCertificateOfCompletion) {
        this.includeCertificateOfCompletion = includeCertificateOfCompletion;
    }

    public ConnectCustomConfiguration includeCertSoapHeader(String includeCertSoapHeader) {
        this.includeCertSoapHeader = includeCertSoapHeader;
        return this;
    }

    @ApiModelProperty(value="")
    public String getIncludeCertSoapHeader() {
        return this.includeCertSoapHeader;
    }

    public void setIncludeCertSoapHeader(String includeCertSoapHeader) {
        this.includeCertSoapHeader = includeCertSoapHeader;
    }

    public ConnectCustomConfiguration includeDocumentFields(String includeDocumentFields) {
        this.includeDocumentFields = includeDocumentFields;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, the Document Fields associated with envelope documents are included in the data. Document Fields are optional custom name-value pairs added to documents using the API. ")
    public String getIncludeDocumentFields() {
        return this.includeDocumentFields;
    }

    public void setIncludeDocumentFields(String includeDocumentFields) {
        this.includeDocumentFields = includeDocumentFields;
    }

    public ConnectCustomConfiguration includeDocuments(String includeDocuments) {
        this.includeDocuments = includeDocuments;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, Connect will send the PDF document along with the update XML.")
    public String getIncludeDocuments() {
        return this.includeDocuments;
    }

    public void setIncludeDocuments(String includeDocuments) {
        this.includeDocuments = includeDocuments;
    }

    public ConnectCustomConfiguration includeEnvelopeVoidReason(String includeEnvelopeVoidReason) {
        this.includeEnvelopeVoidReason = includeEnvelopeVoidReason;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, Connect will include the voidedReason for voided envelopes.")
    public String getIncludeEnvelopeVoidReason() {
        return this.includeEnvelopeVoidReason;
    }

    public void setIncludeEnvelopeVoidReason(String includeEnvelopeVoidReason) {
        this.includeEnvelopeVoidReason = includeEnvelopeVoidReason;
    }

    public ConnectCustomConfiguration includeHMAC(String includeHMAC) {
        this.includeHMAC = includeHMAC;
        return this;
    }

    @ApiModelProperty(value="")
    public String getIncludeHMAC() {
        return this.includeHMAC;
    }

    public void setIncludeHMAC(String includeHMAC) {
        this.includeHMAC = includeHMAC;
    }

    public ConnectCustomConfiguration includeSenderAccountasCustomField(String includeSenderAccountasCustomField) {
        this.includeSenderAccountasCustomField = includeSenderAccountasCustomField;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, Connect will include the sender account as Custom Field in the data.")
    public String getIncludeSenderAccountasCustomField() {
        return this.includeSenderAccountasCustomField;
    }

    public void setIncludeSenderAccountasCustomField(String includeSenderAccountasCustomField) {
        this.includeSenderAccountasCustomField = includeSenderAccountasCustomField;
    }

    public ConnectCustomConfiguration includeTimeZoneInformation(String includeTimeZoneInformation) {
        this.includeTimeZoneInformation = includeTimeZoneInformation;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, Connect will include the envelope time zone information.")
    public String getIncludeTimeZoneInformation() {
        return this.includeTimeZoneInformation;
    }

    public void setIncludeTimeZoneInformation(String includeTimeZoneInformation) {
        this.includeTimeZoneInformation = includeTimeZoneInformation;
    }

    public ConnectCustomConfiguration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the Connect configuration. The name helps identify the configuration in the list.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConnectCustomConfiguration password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectCustomConfiguration recipientEvents(List<String> recipientEvents) {
        this.recipientEvents = recipientEvents;
        return this;
    }

    public ConnectCustomConfiguration addRecipientEventsItem(String recipientEventsItem) {
        if (this.recipientEvents == null) {
            this.recipientEvents = new ArrayList<String>();
        }
        this.recipientEvents.add(recipientEventsItem);
        return this;
    }

    @ApiModelProperty(value="A comma separated list of \u00ef\u00bf\u00bdRecipient\u00ef\u00bf\u00bd related events that are tracked through Connect. The possible event values are: Sent, Delivered, Completed, Declined, AuthenticationFailed, and AutoResponded.")
    public List<String> getRecipientEvents() {
        return this.recipientEvents;
    }

    public void setRecipientEvents(List<String> recipientEvents) {
        this.recipientEvents = recipientEvents;
    }

    public ConnectCustomConfiguration requireMutualTls(String requireMutualTls) {
        this.requireMutualTls = requireMutualTls;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRequireMutualTls() {
        return this.requireMutualTls;
    }

    public void setRequireMutualTls(String requireMutualTls) {
        this.requireMutualTls = requireMutualTls;
    }

    public ConnectCustomConfiguration requiresAcknowledgement(String requiresAcknowledgement) {
        this.requiresAcknowledgement = requiresAcknowledgement;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, and a publication message fails to be acknowledged, the message goes back into the queue and the system will retry delivery after a successful acknowledgement is received. If the delivery fails a second time, the message is not returned to the queue for sending until Connect receives a successful acknowledgement and it has been at least 24 hours since the previous retry. There is a maximum of ten retries Alternately, you can use Republish Connect Information to manually republish the envelope information.")
    public String getRequiresAcknowledgement() {
        return this.requiresAcknowledgement;
    }

    public void setRequiresAcknowledgement(String requiresAcknowledgement) {
        this.requiresAcknowledgement = requiresAcknowledgement;
    }

    public ConnectCustomConfiguration salesforceApiVersion(String salesforceApiVersion) {
        this.salesforceApiVersion = salesforceApiVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSalesforceApiVersion() {
        return this.salesforceApiVersion;
    }

    public void setSalesforceApiVersion(String salesforceApiVersion) {
        this.salesforceApiVersion = salesforceApiVersion;
    }

    public ConnectCustomConfiguration salesforceAuthcode(String salesforceAuthcode) {
        this.salesforceAuthcode = salesforceAuthcode;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSalesforceAuthcode() {
        return this.salesforceAuthcode;
    }

    public void setSalesforceAuthcode(String salesforceAuthcode) {
        this.salesforceAuthcode = salesforceAuthcode;
    }

    public ConnectCustomConfiguration salesforceCallBackUrl(String salesforceCallBackUrl) {
        this.salesforceCallBackUrl = salesforceCallBackUrl;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSalesforceCallBackUrl() {
        return this.salesforceCallBackUrl;
    }

    public void setSalesforceCallBackUrl(String salesforceCallBackUrl) {
        this.salesforceCallBackUrl = salesforceCallBackUrl;
    }

    public ConnectCustomConfiguration salesforceDocumentsAsContentFiles(String salesforceDocumentsAsContentFiles) {
        this.salesforceDocumentsAsContentFiles = salesforceDocumentsAsContentFiles;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSalesforceDocumentsAsContentFiles() {
        return this.salesforceDocumentsAsContentFiles;
    }

    public void setSalesforceDocumentsAsContentFiles(String salesforceDocumentsAsContentFiles) {
        this.salesforceDocumentsAsContentFiles = salesforceDocumentsAsContentFiles;
    }

    public ConnectCustomConfiguration senderOverride(String senderOverride) {
        this.senderOverride = senderOverride;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSenderOverride() {
        return this.senderOverride;
    }

    public void setSenderOverride(String senderOverride) {
        this.senderOverride = senderOverride;
    }

    public ConnectCustomConfiguration senderSelectableItems(List<String> senderSelectableItems) {
        this.senderSelectableItems = senderSelectableItems;
        return this;
    }

    public ConnectCustomConfiguration addSenderSelectableItemsItem(String senderSelectableItemsItem) {
        if (this.senderSelectableItems == null) {
            this.senderSelectableItems = new ArrayList<String>();
        }
        this.senderSelectableItems.add(senderSelectableItemsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getSenderSelectableItems() {
        return this.senderSelectableItems;
    }

    public void setSenderSelectableItems(List<String> senderSelectableItems) {
        this.senderSelectableItems = senderSelectableItems;
    }

    public ConnectCustomConfiguration sfObjects(List<ConnectSalesforceObject> sfObjects) {
        this.sfObjects = sfObjects;
        return this;
    }

    public ConnectCustomConfiguration addSfObjectsItem(ConnectSalesforceObject sfObjectsItem) {
        if (this.sfObjects == null) {
            this.sfObjects = new ArrayList<ConnectSalesforceObject>();
        }
        this.sfObjects.add(sfObjectsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ConnectSalesforceObject> getSfObjects() {
        return this.sfObjects;
    }

    public void setSfObjects(List<ConnectSalesforceObject> sfObjects) {
        this.sfObjects = sfObjects;
    }

    public ConnectCustomConfiguration signMessageWithX509Certificate(String signMessageWithX509Certificate) {
        this.signMessageWithX509Certificate = signMessageWithX509Certificate;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, Connect messages are signed with an X509 certificate. This provides support for 2-way SSL.")
    public String getSignMessageWithX509Certificate() {
        return this.signMessageWithX509Certificate;
    }

    public void setSignMessageWithX509Certificate(String signMessageWithX509Certificate) {
        this.signMessageWithX509Certificate = signMessageWithX509Certificate;
    }

    public ConnectCustomConfiguration soapNamespace(String soapNamespace) {
        this.soapNamespace = soapNamespace;
        return this;
    }

    @ApiModelProperty(value="The namespace of the SOAP interface.  The namespace value must be set if useSoapInterface is set to true.")
    public String getSoapNamespace() {
        return this.soapNamespace;
    }

    public void setSoapNamespace(String soapNamespace) {
        this.soapNamespace = soapNamespace;
    }

    public ConnectCustomConfiguration urlToPublishTo(String urlToPublishTo) {
        this.urlToPublishTo = urlToPublishTo;
        return this;
    }

    @ApiModelProperty(value="This is the web address and name of your listener or Retrieving Service endpoint. You need to include HTTPS:// in the web address.")
    public String getUrlToPublishTo() {
        return this.urlToPublishTo;
    }

    public void setUrlToPublishTo(String urlToPublishTo) {
        this.urlToPublishTo = urlToPublishTo;
    }

    public ConnectCustomConfiguration userIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public ConnectCustomConfiguration addUserIdsItem(String userIdsItem) {
        if (this.userIds == null) {
            this.userIds = new ArrayList<String>();
        }
        this.userIds.add(userIdsItem);
        return this;
    }

    @ApiModelProperty(value="A comma separated list of userIds. This sets the users associated with the tracked envelope and recipient events. When one of the event occurs for a set user, the information is sent through Connect.   ###### Note: If allUsers is set to \u00ef\u00bf\u00bdfalse\u00ef\u00bf\u00bd then you must provide a list of user id\u00ef\u00bf\u00bds.")
    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public ConnectCustomConfiguration userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ConnectCustomConfiguration useSoapInterface(String useSoapInterface) {
        this.useSoapInterface = useSoapInterface;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, indicates that the `urlToPublishTo` property contains a SOAP endpoint.")
    public String getUseSoapInterface() {
        return this.useSoapInterface;
    }

    public void setUseSoapInterface(String useSoapInterface) {
        this.useSoapInterface = useSoapInterface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectCustomConfiguration connectCustomConfiguration = (ConnectCustomConfiguration)o;
        return Objects.equals(this.allowEnvelopePublish, connectCustomConfiguration.allowEnvelopePublish) && Objects.equals(this.allowSalesforcePublish, connectCustomConfiguration.allowSalesforcePublish) && Objects.equals(this.allUsers, connectCustomConfiguration.allUsers) && Objects.equals(this.allUsersExcept, connectCustomConfiguration.allUsersExcept) && Objects.equals(this.configurationType, connectCustomConfiguration.configurationType) && Objects.equals(this.connectId, connectCustomConfiguration.connectId) && Objects.equals(this.deliveryMode, connectCustomConfiguration.deliveryMode) && Objects.equals(this.disabledBy, connectCustomConfiguration.disabledBy) && Objects.equals(this.enableLog, connectCustomConfiguration.enableLog) && Objects.equals(this.envelopeEvents, connectCustomConfiguration.envelopeEvents) && Objects.equals(this.eventData, connectCustomConfiguration.eventData) && Objects.equals(this.events, connectCustomConfiguration.events) && Objects.equals(this.externalFolderId, connectCustomConfiguration.externalFolderId) && Objects.equals(this.externalFolderLabel, connectCustomConfiguration.externalFolderLabel) && Objects.equals(this.groupIds, connectCustomConfiguration.groupIds) && Objects.equals(this.includeCertificateOfCompletion, connectCustomConfiguration.includeCertificateOfCompletion) && Objects.equals(this.includeCertSoapHeader, connectCustomConfiguration.includeCertSoapHeader) && Objects.equals(this.includeDocumentFields, connectCustomConfiguration.includeDocumentFields) && Objects.equals(this.includeDocuments, connectCustomConfiguration.includeDocuments) && Objects.equals(this.includeEnvelopeVoidReason, connectCustomConfiguration.includeEnvelopeVoidReason) && Objects.equals(this.includeHMAC, connectCustomConfiguration.includeHMAC) && Objects.equals(this.includeSenderAccountasCustomField, connectCustomConfiguration.includeSenderAccountasCustomField) && Objects.equals(this.includeTimeZoneInformation, connectCustomConfiguration.includeTimeZoneInformation) && Objects.equals(this.name, connectCustomConfiguration.name) && Objects.equals(this.password, connectCustomConfiguration.password) && Objects.equals(this.recipientEvents, connectCustomConfiguration.recipientEvents) && Objects.equals(this.requireMutualTls, connectCustomConfiguration.requireMutualTls) && Objects.equals(this.requiresAcknowledgement, connectCustomConfiguration.requiresAcknowledgement) && Objects.equals(this.salesforceApiVersion, connectCustomConfiguration.salesforceApiVersion) && Objects.equals(this.salesforceAuthcode, connectCustomConfiguration.salesforceAuthcode) && Objects.equals(this.salesforceCallBackUrl, connectCustomConfiguration.salesforceCallBackUrl) && Objects.equals(this.salesforceDocumentsAsContentFiles, connectCustomConfiguration.salesforceDocumentsAsContentFiles) && Objects.equals(this.senderOverride, connectCustomConfiguration.senderOverride) && Objects.equals(this.senderSelectableItems, connectCustomConfiguration.senderSelectableItems) && Objects.equals(this.sfObjects, connectCustomConfiguration.sfObjects) && Objects.equals(this.signMessageWithX509Certificate, connectCustomConfiguration.signMessageWithX509Certificate) && Objects.equals(this.soapNamespace, connectCustomConfiguration.soapNamespace) && Objects.equals(this.urlToPublishTo, connectCustomConfiguration.urlToPublishTo) && Objects.equals(this.userIds, connectCustomConfiguration.userIds) && Objects.equals(this.userName, connectCustomConfiguration.userName) && Objects.equals(this.useSoapInterface, connectCustomConfiguration.useSoapInterface);
    }

    public int hashCode() {
        return Objects.hash(this.allowEnvelopePublish, this.allowSalesforcePublish, this.allUsers, this.allUsersExcept, this.configurationType, this.connectId, this.deliveryMode, this.disabledBy, this.enableLog, this.envelopeEvents, this.eventData, this.events, this.externalFolderId, this.externalFolderLabel, this.groupIds, this.includeCertificateOfCompletion, this.includeCertSoapHeader, this.includeDocumentFields, this.includeDocuments, this.includeEnvelopeVoidReason, this.includeHMAC, this.includeSenderAccountasCustomField, this.includeTimeZoneInformation, this.name, this.password, this.recipientEvents, this.requireMutualTls, this.requiresAcknowledgement, this.salesforceApiVersion, this.salesforceAuthcode, this.salesforceCallBackUrl, this.salesforceDocumentsAsContentFiles, this.senderOverride, this.senderSelectableItems, this.sfObjects, this.signMessageWithX509Certificate, this.soapNamespace, this.urlToPublishTo, this.userIds, this.userName, this.useSoapInterface);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectCustomConfiguration {\n");
        sb.append("    allowEnvelopePublish: ").append(this.toIndentedString(this.allowEnvelopePublish)).append("\n");
        sb.append("    allowSalesforcePublish: ").append(this.toIndentedString(this.allowSalesforcePublish)).append("\n");
        sb.append("    allUsers: ").append(this.toIndentedString(this.allUsers)).append("\n");
        sb.append("    allUsersExcept: ").append(this.toIndentedString(this.allUsersExcept)).append("\n");
        sb.append("    configurationType: ").append(this.toIndentedString(this.configurationType)).append("\n");
        sb.append("    connectId: ").append(this.toIndentedString(this.connectId)).append("\n");
        sb.append("    deliveryMode: ").append(this.toIndentedString(this.deliveryMode)).append("\n");
        sb.append("    disabledBy: ").append(this.toIndentedString(this.disabledBy)).append("\n");
        sb.append("    enableLog: ").append(this.toIndentedString(this.enableLog)).append("\n");
        sb.append("    envelopeEvents: ").append(this.toIndentedString(this.envelopeEvents)).append("\n");
        sb.append("    eventData: ").append(this.toIndentedString(this.eventData)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    externalFolderId: ").append(this.toIndentedString(this.externalFolderId)).append("\n");
        sb.append("    externalFolderLabel: ").append(this.toIndentedString(this.externalFolderLabel)).append("\n");
        sb.append("    groupIds: ").append(this.toIndentedString(this.groupIds)).append("\n");
        sb.append("    includeCertificateOfCompletion: ").append(this.toIndentedString(this.includeCertificateOfCompletion)).append("\n");
        sb.append("    includeCertSoapHeader: ").append(this.toIndentedString(this.includeCertSoapHeader)).append("\n");
        sb.append("    includeDocumentFields: ").append(this.toIndentedString(this.includeDocumentFields)).append("\n");
        sb.append("    includeDocuments: ").append(this.toIndentedString(this.includeDocuments)).append("\n");
        sb.append("    includeEnvelopeVoidReason: ").append(this.toIndentedString(this.includeEnvelopeVoidReason)).append("\n");
        sb.append("    includeHMAC: ").append(this.toIndentedString(this.includeHMAC)).append("\n");
        sb.append("    includeSenderAccountasCustomField: ").append(this.toIndentedString(this.includeSenderAccountasCustomField)).append("\n");
        sb.append("    includeTimeZoneInformation: ").append(this.toIndentedString(this.includeTimeZoneInformation)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    recipientEvents: ").append(this.toIndentedString(this.recipientEvents)).append("\n");
        sb.append("    requireMutualTls: ").append(this.toIndentedString(this.requireMutualTls)).append("\n");
        sb.append("    requiresAcknowledgement: ").append(this.toIndentedString(this.requiresAcknowledgement)).append("\n");
        sb.append("    salesforceApiVersion: ").append(this.toIndentedString(this.salesforceApiVersion)).append("\n");
        sb.append("    salesforceAuthcode: ").append(this.toIndentedString(this.salesforceAuthcode)).append("\n");
        sb.append("    salesforceCallBackUrl: ").append(this.toIndentedString(this.salesforceCallBackUrl)).append("\n");
        sb.append("    salesforceDocumentsAsContentFiles: ").append(this.toIndentedString(this.salesforceDocumentsAsContentFiles)).append("\n");
        sb.append("    senderOverride: ").append(this.toIndentedString(this.senderOverride)).append("\n");
        sb.append("    senderSelectableItems: ").append(this.toIndentedString(this.senderSelectableItems)).append("\n");
        sb.append("    sfObjects: ").append(this.toIndentedString(this.sfObjects)).append("\n");
        sb.append("    signMessageWithX509Certificate: ").append(this.toIndentedString(this.signMessageWithX509Certificate)).append("\n");
        sb.append("    soapNamespace: ").append(this.toIndentedString(this.soapNamespace)).append("\n");
        sb.append("    urlToPublishTo: ").append(this.toIndentedString(this.urlToPublishTo)).append("\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    useSoapInterface: ").append(this.toIndentedString(this.useSoapInterface)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

