/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AccountIdentityInputOption;
import com.docusign.esign.model.AccountIdentityVerificationStep;
import com.docusign.esign.model.AccountSignatureProvider;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Specifies an Identity Verification workflow.")
public class AccountIdentityVerificationWorkflow {
    @JsonProperty(value="defaultDescription")
    private String defaultDescription = null;
    @JsonProperty(value="defaultName")
    private String defaultName = null;
    @JsonProperty(value="inputOptions")
    private List<AccountIdentityInputOption> inputOptions = null;
    @JsonProperty(value="signatureProvider")
    private AccountSignatureProvider signatureProvider = null;
    @JsonProperty(value="steps")
    private List<AccountIdentityVerificationStep> steps = null;
    @JsonProperty(value="workflowId")
    private String workflowId = null;
    @JsonProperty(value="workflowResourceKey")
    private String workflowResourceKey = null;

    public AccountIdentityVerificationWorkflow defaultDescription(String defaultDescription) {
        this.defaultDescription = defaultDescription;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDefaultDescription() {
        return this.defaultDescription;
    }

    public void setDefaultDescription(String defaultDescription) {
        this.defaultDescription = defaultDescription;
    }

    public AccountIdentityVerificationWorkflow defaultName(String defaultName) {
        this.defaultName = defaultName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    public AccountIdentityVerificationWorkflow inputOptions(List<AccountIdentityInputOption> inputOptions) {
        this.inputOptions = inputOptions;
        return this;
    }

    public AccountIdentityVerificationWorkflow addInputOptionsItem(AccountIdentityInputOption inputOptionsItem) {
        if (this.inputOptions == null) {
            this.inputOptions = new ArrayList<AccountIdentityInputOption>();
        }
        this.inputOptions.add(inputOptionsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<AccountIdentityInputOption> getInputOptions() {
        return this.inputOptions;
    }

    public void setInputOptions(List<AccountIdentityInputOption> inputOptions) {
        this.inputOptions = inputOptions;
    }

    public AccountIdentityVerificationWorkflow signatureProvider(AccountSignatureProvider signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    @ApiModelProperty(value="The signature provider associated with the Identity Verification workflow.")
    public AccountSignatureProvider getSignatureProvider() {
        return this.signatureProvider;
    }

    public void setSignatureProvider(AccountSignatureProvider signatureProvider) {
        this.signatureProvider = signatureProvider;
    }

    public AccountIdentityVerificationWorkflow steps(List<AccountIdentityVerificationStep> steps) {
        this.steps = steps;
        return this;
    }

    public AccountIdentityVerificationWorkflow addStepsItem(AccountIdentityVerificationStep stepsItem) {
        if (this.steps == null) {
            this.steps = new ArrayList<AccountIdentityVerificationStep>();
        }
        this.steps.add(stepsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<AccountIdentityVerificationStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<AccountIdentityVerificationStep> steps) {
        this.steps = steps;
    }

    public AccountIdentityVerificationWorkflow workflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public AccountIdentityVerificationWorkflow workflowResourceKey(String workflowResourceKey) {
        this.workflowResourceKey = workflowResourceKey;
        return this;
    }

    @ApiModelProperty(value="")
    public String getWorkflowResourceKey() {
        return this.workflowResourceKey;
    }

    public void setWorkflowResourceKey(String workflowResourceKey) {
        this.workflowResourceKey = workflowResourceKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountIdentityVerificationWorkflow accountIdentityVerificationWorkflow = (AccountIdentityVerificationWorkflow)o;
        return Objects.equals(this.defaultDescription, accountIdentityVerificationWorkflow.defaultDescription) && Objects.equals(this.defaultName, accountIdentityVerificationWorkflow.defaultName) && Objects.equals(this.inputOptions, accountIdentityVerificationWorkflow.inputOptions) && Objects.equals(this.signatureProvider, accountIdentityVerificationWorkflow.signatureProvider) && Objects.equals(this.steps, accountIdentityVerificationWorkflow.steps) && Objects.equals(this.workflowId, accountIdentityVerificationWorkflow.workflowId) && Objects.equals(this.workflowResourceKey, accountIdentityVerificationWorkflow.workflowResourceKey);
    }

    public int hashCode() {
        return Objects.hash(this.defaultDescription, this.defaultName, this.inputOptions, this.signatureProvider, this.steps, this.workflowId, this.workflowResourceKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountIdentityVerificationWorkflow {\n");
        sb.append("    defaultDescription: ").append(this.toIndentedString(this.defaultDescription)).append("\n");
        sb.append("    defaultName: ").append(this.toIndentedString(this.defaultName)).append("\n");
        sb.append("    inputOptions: ").append(this.toIndentedString(this.inputOptions)).append("\n");
        sb.append("    signatureProvider: ").append(this.toIndentedString(this.signatureProvider)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    workflowId: ").append(this.toIndentedString(this.workflowId)).append("\n");
        sb.append("    workflowResourceKey: ").append(this.toIndentedString(this.workflowResourceKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

