/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.Attachment;
import com.docusign.esign.model.ChunkedUploadRequest;
import com.docusign.esign.model.ChunkedUploadResponse;
import com.docusign.esign.model.CommentHistoryResult;
import com.docusign.esign.model.CommentsPublish;
import com.docusign.esign.model.ConnectHistoricalEnvelopeRepublish;
import com.docusign.esign.model.ConsoleViewRequest;
import com.docusign.esign.model.ConsumerDisclosure;
import com.docusign.esign.model.CorrectViewRequest;
import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.CustomFieldsEnvelope;
import com.docusign.esign.model.DelayedRouting;
import com.docusign.esign.model.Document;
import com.docusign.esign.model.DocumentFieldsInformation;
import com.docusign.esign.model.DocumentHtmlDefinition;
import com.docusign.esign.model.DocumentHtmlDefinitionOriginals;
import com.docusign.esign.model.DocumentHtmlDefinitions;
import com.docusign.esign.model.DocumentTemplateList;
import com.docusign.esign.model.DocumentVisibilityList;
import com.docusign.esign.model.EmailSettings;
import com.docusign.esign.model.Envelope;
import com.docusign.esign.model.EnvelopeAttachmentsRequest;
import com.docusign.esign.model.EnvelopeAttachmentsResult;
import com.docusign.esign.model.EnvelopeAuditEventResponse;
import com.docusign.esign.model.EnvelopeDefinition;
import com.docusign.esign.model.EnvelopeDocument;
import com.docusign.esign.model.EnvelopeDocumentsResult;
import com.docusign.esign.model.EnvelopeFormData;
import com.docusign.esign.model.EnvelopeIdsRequest;
import com.docusign.esign.model.EnvelopeNotificationRequest;
import com.docusign.esign.model.EnvelopePublishTransaction;
import com.docusign.esign.model.EnvelopeSummary;
import com.docusign.esign.model.EnvelopeTransferRule;
import com.docusign.esign.model.EnvelopeTransferRuleInformation;
import com.docusign.esign.model.EnvelopeTransferRuleRequest;
import com.docusign.esign.model.EnvelopeUpdateSummary;
import com.docusign.esign.model.EnvelopesInformation;
import com.docusign.esign.model.IdEvidenceResourceToken;
import com.docusign.esign.model.IdEvidenceViewLink;
import com.docusign.esign.model.LockInformation;
import com.docusign.esign.model.LockRequest;
import com.docusign.esign.model.Notification;
import com.docusign.esign.model.PageImages;
import com.docusign.esign.model.PageRequest;
import com.docusign.esign.model.RecipientPreviewRequest;
import com.docusign.esign.model.RecipientViewRequest;
import com.docusign.esign.model.Recipients;
import com.docusign.esign.model.RecipientsUpdateSummary;
import com.docusign.esign.model.ReturnUrlRequest;
import com.docusign.esign.model.ScheduledSending;
import com.docusign.esign.model.Tabs;
import com.docusign.esign.model.TemplateDocumentVisibilityList;
import com.docusign.esign.model.TemplateInformation;
import com.docusign.esign.model.UserSignature;
import com.docusign.esign.model.ViewUrl;
import com.docusign.esign.model.Workflow;
import com.docusign.esign.model.WorkflowStep;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class EnvelopesApi {
    private ApiClient apiClient;

    public EnvelopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvelopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DocumentTemplateList applyTemplate(String accountId, String envelopeId, DocumentTemplateList documentTemplateList) throws ApiException {
        return this.applyTemplate(accountId, envelopeId, documentTemplateList, null);
    }

    public DocumentTemplateList applyTemplate(String accountId, String envelopeId, DocumentTemplateList documentTemplateList, ApplyTemplateOptions options) throws ApiException {
        ApiResponse<DocumentTemplateList> localVarResponse = this.applyTemplateWithHttpInfo(accountId, envelopeId, documentTemplateList, options);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentTemplateList> applyTemplateWithHttpInfo(String accountId, String envelopeId, DocumentTemplateList documentTemplateList, ApplyTemplateOptions options) throws ApiException {
        DocumentTemplateList localVarPostBody = documentTemplateList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling applyTemplate");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling applyTemplate");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("preserve_template_recipient", options.preserveTemplateRecipient));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentTemplateList> localVarReturnType = new GenericType<DocumentTemplateList>(){};
        DocumentTemplateList localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentTemplateList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentTemplateList applyTemplateToDocument(String accountId, String envelopeId, String documentId, DocumentTemplateList documentTemplateList) throws ApiException {
        return this.applyTemplateToDocument(accountId, envelopeId, documentId, documentTemplateList, null);
    }

    public DocumentTemplateList applyTemplateToDocument(String accountId, String envelopeId, String documentId, DocumentTemplateList documentTemplateList, ApplyTemplateToDocumentOptions options) throws ApiException {
        ApiResponse<DocumentTemplateList> localVarResponse = this.applyTemplateToDocumentWithHttpInfo(accountId, envelopeId, documentId, documentTemplateList, options);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentTemplateList> applyTemplateToDocumentWithHttpInfo(String accountId, String envelopeId, String documentId, DocumentTemplateList documentTemplateList, ApplyTemplateToDocumentOptions options) throws ApiException {
        DocumentTemplateList localVarPostBody = documentTemplateList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling applyTemplateToDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling applyTemplateToDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling applyTemplateToDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("preserve_template_recipient", options.preserveTemplateRecipient));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentTemplateList> localVarReturnType = new GenericType<DocumentTemplateList>(){};
        DocumentTemplateList localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentTemplateList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ChunkedUploadResponse createChunkedUpload(String accountId, ChunkedUploadRequest chunkedUploadRequest) throws ApiException {
        ApiResponse<ChunkedUploadResponse> localVarResponse = this.createChunkedUploadWithHttpInfo(accountId, chunkedUploadRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ChunkedUploadResponse> createChunkedUploadWithHttpInfo(String accountId, ChunkedUploadRequest chunkedUploadRequest) throws ApiException {
        ChunkedUploadRequest localVarPostBody = chunkedUploadRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createChunkedUpload");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        ChunkedUploadResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ChunkedUploadResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createConsoleView(String accountId, ConsoleViewRequest consoleViewRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createConsoleViewWithHttpInfo(accountId, consoleViewRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createConsoleViewWithHttpInfo(String accountId, ConsoleViewRequest consoleViewRequest) throws ApiException {
        ConsoleViewRequest localVarPostBody = consoleViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createConsoleView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/views/console".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createCorrectView(String accountId, String envelopeId, CorrectViewRequest correctViewRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createCorrectViewWithHttpInfo(accountId, envelopeId, correctViewRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createCorrectViewWithHttpInfo(String accountId, String envelopeId, CorrectViewRequest correctViewRequest) throws ApiException {
        CorrectViewRequest localVarPostBody = correctViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCorrectView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createCorrectView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomFields createCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        ApiResponse<CustomFields> localVarResponse = this.createCustomFieldsWithHttpInfo(accountId, envelopeId, customFields);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomFields> createCustomFieldsWithHttpInfo(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        CustomFields localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomFields>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentFieldsInformation createDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        ApiResponse<DocumentFieldsInformation> localVarResponse = this.createDocumentFieldsWithHttpInfo(accountId, envelopeId, documentId, documentFieldsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentFieldsInformation> createDocumentFieldsWithHttpInfo(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        DocumentFieldsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentFieldsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentHtmlDefinitions createDocumentResponsiveHtmlPreview(String accountId, String envelopeId, String documentId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        ApiResponse<DocumentHtmlDefinitions> localVarResponse = this.createDocumentResponsiveHtmlPreviewWithHttpInfo(accountId, envelopeId, documentId, documentHtmlDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentHtmlDefinitions> createDocumentResponsiveHtmlPreviewWithHttpInfo(String accountId, String envelopeId, String documentId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        DocumentHtmlDefinition localVarPostBody = documentHtmlDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentResponsiveHtmlPreview");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createDocumentResponsiveHtmlPreview");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentResponsiveHtmlPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/responsive_html_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitions> localVarReturnType = new GenericType<DocumentHtmlDefinitions>(){};
        DocumentHtmlDefinitions localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentHtmlDefinitions>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs createDocumentTabs(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.createDocumentTabsWithHttpInfo(accountId, envelopeId, documentId, tabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> createDocumentTabsWithHttpInfo(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createEditView(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createEditViewWithHttpInfo(accountId, envelopeId, returnUrlRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createEditViewWithHttpInfo(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ReturnUrlRequest localVarPostBody = returnUrlRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEditView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEditView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/edit".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EmailSettings createEmailSettings(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        ApiResponse<EmailSettings> localVarResponse = this.createEmailSettingsWithHttpInfo(accountId, envelopeId, emailSettings);
        return localVarResponse.getData();
    }

    public ApiResponse<EmailSettings> createEmailSettingsWithHttpInfo(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        EmailSettings localVarPostBody = emailSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEmailSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        EmailSettings localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EmailSettings>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeSummary createEnvelope(String accountId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        return this.createEnvelope(accountId, envelopeDefinition, null);
    }

    public EnvelopeSummary createEnvelope(String accountId, EnvelopeDefinition envelopeDefinition, CreateEnvelopeOptions options) throws ApiException {
        ApiResponse<EnvelopeSummary> localVarResponse = this.createEnvelopeWithHttpInfo(accountId, envelopeDefinition, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeSummary> createEnvelopeWithHttpInfo(String accountId, EnvelopeDefinition envelopeDefinition, CreateEnvelopeOptions options) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelope");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cdse_mode", options.cdseMode));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("change_routing_order", options.changeRoutingOrder));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("completed_documents_only", options.completedDocumentsOnly));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("merge_roles_on_draft", options.mergeRolesOnDraft));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tab_label_exact_matches", options.tabLabelExactMatches));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeSummary> localVarReturnType = new GenericType<EnvelopeSummary>(){};
        EnvelopeSummary localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeSummary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CommentHistoryResult createEnvelopeComments(String accountId, String envelopeId, CommentsPublish commentsPublish) throws ApiException {
        ApiResponse<CommentHistoryResult> localVarResponse = this.createEnvelopeCommentsWithHttpInfo(accountId, envelopeId, commentsPublish);
        return localVarResponse.getData();
    }

    public ApiResponse<CommentHistoryResult> createEnvelopeCommentsWithHttpInfo(String accountId, String envelopeId, CommentsPublish commentsPublish) throws ApiException {
        CommentsPublish localVarPostBody = commentsPublish;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeComments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEnvelopeComments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CommentHistoryResult> localVarReturnType = new GenericType<CommentHistoryResult>(){};
        CommentHistoryResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CommentHistoryResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createEnvelopeRecipientPreview(String accountId, String envelopeId, RecipientPreviewRequest recipientPreviewRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createEnvelopeRecipientPreviewWithHttpInfo(accountId, envelopeId, recipientPreviewRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createEnvelopeRecipientPreviewWithHttpInfo(String accountId, String envelopeId, RecipientPreviewRequest recipientPreviewRequest) throws ApiException {
        RecipientPreviewRequest localVarPostBody = recipientPreviewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeRecipientPreview");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEnvelopeRecipientPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createEnvelopeRecipientSharedView(String accountId, String envelopeId, RecipientViewRequest recipientViewRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createEnvelopeRecipientSharedViewWithHttpInfo(accountId, envelopeId, recipientViewRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createEnvelopeRecipientSharedViewWithHttpInfo(String accountId, String envelopeId, RecipientViewRequest recipientViewRequest) throws ApiException {
        RecipientViewRequest localVarPostBody = recipientViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeRecipientSharedView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEnvelopeRecipientSharedView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/shared".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeTransferRuleInformation createEnvelopeTransferRules(String accountId, EnvelopeTransferRuleRequest envelopeTransferRuleRequest) throws ApiException {
        ApiResponse<EnvelopeTransferRuleInformation> localVarResponse = this.createEnvelopeTransferRulesWithHttpInfo(accountId, envelopeTransferRuleRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeTransferRuleInformation> createEnvelopeTransferRulesWithHttpInfo(String accountId, EnvelopeTransferRuleRequest envelopeTransferRuleRequest) throws ApiException {
        EnvelopeTransferRuleRequest localVarPostBody = envelopeTransferRuleRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeTransferRules");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTransferRuleInformation> localVarReturnType = new GenericType<EnvelopeTransferRuleInformation>(){};
        EnvelopeTransferRuleInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeTransferRuleInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowStep createEnvelopeWorkflowStepDefinition(String accountId, String envelopeId, WorkflowStep workflowStep) throws ApiException {
        ApiResponse<WorkflowStep> localVarResponse = this.createEnvelopeWorkflowStepDefinitionWithHttpInfo(accountId, envelopeId, workflowStep);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowStep> createEnvelopeWorkflowStepDefinitionWithHttpInfo(String accountId, String envelopeId, WorkflowStep workflowStep) throws ApiException {
        WorkflowStep localVarPostBody = workflowStep;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEnvelopeWorkflowStepDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createEnvelopeWorkflowStepDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowStep> localVarReturnType = new GenericType<WorkflowStep>(){};
        WorkflowStep localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowStep>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopePublishTransaction createHistoricalEnvelopePublishTransaction(String accountId, ConnectHistoricalEnvelopeRepublish connectHistoricalEnvelopeRepublish) throws ApiException {
        ApiResponse<EnvelopePublishTransaction> localVarResponse = this.createHistoricalEnvelopePublishTransactionWithHttpInfo(accountId, connectHistoricalEnvelopeRepublish);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopePublishTransaction> createHistoricalEnvelopePublishTransactionWithHttpInfo(String accountId, ConnectHistoricalEnvelopeRepublish connectHistoricalEnvelopeRepublish) throws ApiException {
        ConnectHistoricalEnvelopeRepublish localVarPostBody = connectHistoricalEnvelopeRepublish;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createHistoricalEnvelopePublishTransaction");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/connect/envelopes/publish/historical".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopePublishTransaction> localVarReturnType = new GenericType<EnvelopePublishTransaction>(){};
        EnvelopePublishTransaction localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopePublishTransaction>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public LockInformation createLock(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        ApiResponse<LockInformation> localVarResponse = this.createLockWithHttpInfo(accountId, envelopeId, lockRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInformation> createLockWithHttpInfo(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        LockInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<LockInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Recipients createRecipient(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        return this.createRecipient(accountId, envelopeId, recipients, null);
    }

    public Recipients createRecipient(String accountId, String envelopeId, Recipients recipients, CreateRecipientOptions options) throws ApiException {
        ApiResponse<Recipients> localVarResponse = this.createRecipientWithHttpInfo(accountId, envelopeId, recipients, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Recipients> createRecipientWithHttpInfo(String accountId, String envelopeId, Recipients recipients, CreateRecipientOptions options) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipient");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipient");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        Recipients localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Recipients>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createRecipientManualReviewView(String accountId, String envelopeId, String recipientId) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createRecipientManualReviewViewWithHttpInfo(accountId, envelopeId, recipientId);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createRecipientManualReviewViewWithHttpInfo(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientManualReviewView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientManualReviewView");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createRecipientManualReviewView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/views/identity_manual_review".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public IdEvidenceViewLink createRecipientProofFileLink(String accountId, String envelopeId, String recipientId) throws ApiException {
        ApiResponse<IdEvidenceViewLink> localVarResponse = this.createRecipientProofFileLinkWithHttpInfo(accountId, envelopeId, recipientId);
        return localVarResponse.getData();
    }

    public ApiResponse<IdEvidenceViewLink> createRecipientProofFileLinkWithHttpInfo(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientProofFileLink");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientProofFileLink");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createRecipientProofFileLink");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<IdEvidenceViewLink> localVarReturnType = new GenericType<IdEvidenceViewLink>(){};
        IdEvidenceViewLink localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<IdEvidenceViewLink>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public IdEvidenceResourceToken createRecipientProofFileResourceToken(String tokenScopes, String accountId, String envelopeId, String recipientId) throws ApiException {
        ApiResponse<IdEvidenceResourceToken> localVarResponse = this.createRecipientProofFileResourceTokenWithHttpInfo(tokenScopes, accountId, envelopeId, recipientId);
        return localVarResponse.getData();
    }

    public ApiResponse<IdEvidenceResourceToken> createRecipientProofFileResourceTokenWithHttpInfo(String tokenScopes, String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (tokenScopes == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenScopes' when calling createRecipientProofFileResourceToken");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientProofFileResourceToken");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientProofFileResourceToken");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createRecipientProofFileResourceToken");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof_token".replaceAll("\\{token_scopes\\}", this.apiClient.escapeString(tokenScopes.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<IdEvidenceResourceToken> localVarReturnType = new GenericType<IdEvidenceResourceToken>(){};
        IdEvidenceResourceToken localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<IdEvidenceResourceToken>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createRecipientView(String accountId, String envelopeId, RecipientViewRequest recipientViewRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createRecipientViewWithHttpInfo(accountId, envelopeId, recipientViewRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createRecipientViewWithHttpInfo(String accountId, String envelopeId, RecipientViewRequest recipientViewRequest) throws ApiException {
        RecipientViewRequest localVarPostBody = recipientViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipientView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createRecipientView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentHtmlDefinitions createResponsiveHtmlPreview(String accountId, String envelopeId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        ApiResponse<DocumentHtmlDefinitions> localVarResponse = this.createResponsiveHtmlPreviewWithHttpInfo(accountId, envelopeId, documentHtmlDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentHtmlDefinitions> createResponsiveHtmlPreviewWithHttpInfo(String accountId, String envelopeId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        DocumentHtmlDefinition localVarPostBody = documentHtmlDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createResponsiveHtmlPreview");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createResponsiveHtmlPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/responsive_html_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitions> localVarReturnType = new GenericType<DocumentHtmlDefinitions>(){};
        DocumentHtmlDefinitions localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentHtmlDefinitions>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createSenderView(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createSenderViewWithHttpInfo(accountId, envelopeId, returnUrlRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createSenderViewWithHttpInfo(String accountId, String envelopeId, ReturnUrlRequest returnUrlRequest) throws ApiException {
        ReturnUrlRequest localVarPostBody = returnUrlRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createSenderView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createSenderView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/sender".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs createTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.createTabsWithHttpInfo(accountId, envelopeId, recipientId, tabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> createTabsWithHttpInfo(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling createTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowStep createTemplateWorkflowStepDefinition(String accountId, String templateId, WorkflowStep workflowStep) throws ApiException {
        ApiResponse<WorkflowStep> localVarResponse = this.createTemplateWorkflowStepDefinitionWithHttpInfo(accountId, templateId, workflowStep);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowStep> createTemplateWorkflowStepDefinitionWithHttpInfo(String accountId, String templateId, WorkflowStep workflowStep) throws ApiException {
        WorkflowStep localVarPostBody = workflowStep;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTemplateWorkflowStepDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createTemplateWorkflowStepDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowStep> localVarReturnType = new GenericType<WorkflowStep>(){};
        WorkflowStep localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowStep>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeAttachmentsResult deleteAttachments(String accountId, String envelopeId, EnvelopeAttachmentsRequest envelopeAttachmentsRequest) throws ApiException {
        ApiResponse<EnvelopeAttachmentsResult> localVarResponse = this.deleteAttachmentsWithHttpInfo(accountId, envelopeId, envelopeAttachmentsRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeAttachmentsResult> deleteAttachmentsWithHttpInfo(String accountId, String envelopeId, EnvelopeAttachmentsRequest envelopeAttachmentsRequest) throws ApiException {
        EnvelopeAttachmentsRequest localVarPostBody = envelopeAttachmentsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteAttachments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAttachmentsResult> localVarReturnType = new GenericType<EnvelopeAttachmentsResult>(){};
        EnvelopeAttachmentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeAttachmentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ChunkedUploadResponse deleteChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        ApiResponse<ChunkedUploadResponse> localVarResponse = this.deleteChunkedUploadWithHttpInfo(accountId, chunkedUploadId);
        return localVarResponse.getData();
    }

    public ApiResponse<ChunkedUploadResponse> deleteChunkedUploadWithHttpInfo(String accountId, String chunkedUploadId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling deleteChunkedUpload");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        ChunkedUploadResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ChunkedUploadResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomFields deleteCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        ApiResponse<CustomFields> localVarResponse = this.deleteCustomFieldsWithHttpInfo(accountId, envelopeId, customFields);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomFields> deleteCustomFieldsWithHttpInfo(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        CustomFields localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomFields>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentFieldsInformation deleteDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        ApiResponse<DocumentFieldsInformation> localVarResponse = this.deleteDocumentFieldsWithHttpInfo(accountId, envelopeId, documentId, documentFieldsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentFieldsInformation> deleteDocumentFieldsWithHttpInfo(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        DocumentFieldsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentFieldsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteDocumentPage(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        this.deleteDocumentPageWithHttpInfo(accountId, envelopeId, documentId, pageNumber);
    }

    public ApiResponse<Object> deleteDocumentPageWithHttpInfo(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentPage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling deleteDocumentPage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public Tabs deleteDocumentTabs(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.deleteDocumentTabsWithHttpInfo(accountId, envelopeId, documentId, tabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> deleteDocumentTabsWithHttpInfo(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeDocumentsResult deleteDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        ApiResponse<EnvelopeDocumentsResult> localVarResponse = this.deleteDocumentsWithHttpInfo(accountId, envelopeId, envelopeDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeDocumentsResult> deleteDocumentsWithHttpInfo(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        EnvelopeDocumentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeDocumentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EmailSettings deleteEmailSettings(String accountId, String envelopeId) throws ApiException {
        ApiResponse<EmailSettings> localVarResponse = this.deleteEmailSettingsWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<EmailSettings> deleteEmailSettingsWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEmailSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        EmailSettings localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EmailSettings>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteEnvelopeCorrectView(String accountId, String envelopeId, CorrectViewRequest correctViewRequest) throws ApiException {
        this.deleteEnvelopeCorrectViewWithHttpInfo(accountId, envelopeId, correctViewRequest);
    }

    public ApiResponse<Object> deleteEnvelopeCorrectViewWithHttpInfo(String accountId, String envelopeId, CorrectViewRequest correctViewRequest) throws ApiException {
        CorrectViewRequest localVarPostBody = correctViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeCorrectView");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEnvelopeCorrectView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteEnvelopeDelayedRoutingDefinition(String accountId, String envelopeId, String workflowStepId) throws ApiException {
        this.deleteEnvelopeDelayedRoutingDefinitionWithHttpInfo(accountId, envelopeId, workflowStepId);
    }

    public ApiResponse<Object> deleteEnvelopeDelayedRoutingDefinitionWithHttpInfo(String accountId, String envelopeId, String workflowStepId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeDelayedRoutingDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEnvelopeDelayedRoutingDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling deleteEnvelopeDelayedRoutingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteEnvelopeScheduledSendingDefinition(String accountId, String envelopeId) throws ApiException {
        this.deleteEnvelopeScheduledSendingDefinitionWithHttpInfo(accountId, envelopeId);
    }

    public ApiResponse<Object> deleteEnvelopeScheduledSendingDefinitionWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeScheduledSendingDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEnvelopeScheduledSendingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteEnvelopeTransferRules(String accountId, String envelopeTransferRuleId) throws ApiException {
        this.deleteEnvelopeTransferRulesWithHttpInfo(accountId, envelopeTransferRuleId);
    }

    public ApiResponse<Object> deleteEnvelopeTransferRulesWithHttpInfo(String accountId, String envelopeTransferRuleId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeTransferRules");
        }
        if (envelopeTransferRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeTransferRuleId' when calling deleteEnvelopeTransferRules");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeTransferRuleId\\}", this.apiClient.escapeString(envelopeTransferRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteEnvelopeWorkflowDefinition(String accountId, String envelopeId) throws ApiException {
        this.deleteEnvelopeWorkflowDefinitionWithHttpInfo(accountId, envelopeId);
    }

    public ApiResponse<Object> deleteEnvelopeWorkflowDefinitionWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeWorkflowDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEnvelopeWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteEnvelopeWorkflowStepDefinition(String accountId, String envelopeId, String workflowStepId) throws ApiException {
        this.deleteEnvelopeWorkflowStepDefinitionWithHttpInfo(accountId, envelopeId, workflowStepId);
    }

    public ApiResponse<Object> deleteEnvelopeWorkflowStepDefinitionWithHttpInfo(String accountId, String envelopeId, String workflowStepId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteEnvelopeWorkflowStepDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteEnvelopeWorkflowStepDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling deleteEnvelopeWorkflowStepDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public LockInformation deleteLock(String accountId, String envelopeId) throws ApiException {
        ApiResponse<LockInformation> localVarResponse = this.deleteLockWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInformation> deleteLockWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        LockInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<LockInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Recipients deleteRecipient(String accountId, String envelopeId, String recipientId) throws ApiException {
        ApiResponse<Recipients> localVarResponse = this.deleteRecipientWithHttpInfo(accountId, envelopeId, recipientId);
        return localVarResponse.getData();
    }

    public ApiResponse<Recipients> deleteRecipientWithHttpInfo(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipient");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipient");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteRecipient");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        Recipients localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Recipients>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Recipients deleteRecipients(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        ApiResponse<Recipients> localVarResponse = this.deleteRecipientsWithHttpInfo(accountId, envelopeId, recipients);
        return localVarResponse.getData();
    }

    public ApiResponse<Recipients> deleteRecipientsWithHttpInfo(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        Recipients localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Recipients>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs deleteTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.deleteTabsWithHttpInfo(accountId, envelopeId, recipientId, tabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> deleteTabsWithHttpInfo(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteTemplateDelayedRoutingDefinition(String accountId, String templateId, String workflowStepId) throws ApiException {
        this.deleteTemplateDelayedRoutingDefinitionWithHttpInfo(accountId, templateId, workflowStepId);
    }

    public ApiResponse<Object> deleteTemplateDelayedRoutingDefinitionWithHttpInfo(String accountId, String templateId, String workflowStepId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplateDelayedRoutingDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplateDelayedRoutingDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling deleteTemplateDelayedRoutingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteTemplateScheduledSendingDefinition(String accountId, String templateId) throws ApiException {
        this.deleteTemplateScheduledSendingDefinitionWithHttpInfo(accountId, templateId);
    }

    public ApiResponse<Object> deleteTemplateScheduledSendingDefinitionWithHttpInfo(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplateScheduledSendingDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplateScheduledSendingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteTemplateWorkflowDefinition(String accountId, String templateId) throws ApiException {
        this.deleteTemplateWorkflowDefinitionWithHttpInfo(accountId, templateId);
    }

    public ApiResponse<Object> deleteTemplateWorkflowDefinitionWithHttpInfo(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplateWorkflowDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplateWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteTemplateWorkflowStepDefinition(String accountId, String templateId, String workflowStepId) throws ApiException {
        this.deleteTemplateWorkflowStepDefinitionWithHttpInfo(accountId, templateId, workflowStepId);
    }

    public ApiResponse<Object> deleteTemplateWorkflowStepDefinitionWithHttpInfo(String accountId, String templateId, String workflowStepId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplateWorkflowStepDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplateWorkflowStepDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling deleteTemplateWorkflowStepDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void deleteTemplatesFromDocument(String accountId, String envelopeId, String documentId, String templateId) throws ApiException {
        this.deleteTemplatesFromDocumentWithHttpInfo(accountId, envelopeId, documentId, templateId);
    }

    public ApiResponse<Object> deleteTemplatesFromDocumentWithHttpInfo(String accountId, String envelopeId, String documentId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplatesFromDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling deleteTemplatesFromDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteTemplatesFromDocument");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplatesFromDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void getAttachment(String accountId, String envelopeId, String attachmentId) throws ApiException {
        this.getAttachmentWithHttpInfo(accountId, envelopeId, attachmentId);
    }

    public ApiResponse<Object> getAttachmentWithHttpInfo(String accountId, String envelopeId, String attachmentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAttachment");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getAttachment");
        }
        if (attachmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentId' when calling getAttachment");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{attachmentId\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public EnvelopeAttachmentsResult getAttachments(String accountId, String envelopeId) throws ApiException {
        ApiResponse<EnvelopeAttachmentsResult> localVarResponse = this.getAttachmentsWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeAttachmentsResult> getAttachmentsWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getAttachments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAttachmentsResult> localVarReturnType = new GenericType<EnvelopeAttachmentsResult>(){};
        EnvelopeAttachmentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeAttachmentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ChunkedUploadResponse getChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        return this.getChunkedUpload(accountId, chunkedUploadId, null);
    }

    public ChunkedUploadResponse getChunkedUpload(String accountId, String chunkedUploadId, GetChunkedUploadOptions options) throws ApiException {
        ApiResponse<ChunkedUploadResponse> localVarResponse = this.getChunkedUploadWithHttpInfo(accountId, chunkedUploadId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ChunkedUploadResponse> getChunkedUploadWithHttpInfo(String accountId, String chunkedUploadId, GetChunkedUploadOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling getChunkedUpload");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        ChunkedUploadResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ChunkedUploadResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getCommentsTranscript(String accountId, String envelopeId) throws ApiException {
        return this.getCommentsTranscript(accountId, envelopeId, null);
    }

    public byte[] getCommentsTranscript(String accountId, String envelopeId, GetCommentsTranscriptOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getCommentsTranscriptWithHttpInfo(accountId, envelopeId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getCommentsTranscriptWithHttpInfo(String accountId, String envelopeId, GetCommentsTranscriptOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getCommentsTranscript");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getCommentsTranscript");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments/transcript".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encoding", options.encoding));
        }
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConsumerDisclosure getConsumerDisclosure(String accountId, String envelopeId, String recipientId, String langCode) throws ApiException {
        return this.getConsumerDisclosure(accountId, envelopeId, recipientId, langCode, null);
    }

    public ConsumerDisclosure getConsumerDisclosure(String accountId, String envelopeId, String recipientId, String langCode, GetConsumerDisclosureOptions options) throws ApiException {
        ApiResponse<ConsumerDisclosure> localVarResponse = this.getConsumerDisclosureWithHttpInfo(accountId, envelopeId, recipientId, langCode, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ConsumerDisclosure> getConsumerDisclosureWithHttpInfo(String accountId, String envelopeId, String recipientId, String langCode, GetConsumerDisclosureOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConsumerDisclosure");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getConsumerDisclosure");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getConsumerDisclosure");
        }
        if (langCode == null) {
            throw new ApiException(400, "Missing the required parameter 'langCode' when calling getConsumerDisclosure");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString())).replaceAll("\\{langCode\\}", this.apiClient.escapeString(langCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("langCode", options.langCode2));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConsumerDisclosure> localVarReturnType = new GenericType<ConsumerDisclosure>(){};
        ConsumerDisclosure localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConsumerDisclosure>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ConsumerDisclosure getConsumerDisclosureDefault(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getConsumerDisclosureDefault(accountId, envelopeId, recipientId, null);
    }

    public ConsumerDisclosure getConsumerDisclosureDefault(String accountId, String envelopeId, String recipientId, GetConsumerDisclosureDefaultOptions options) throws ApiException {
        ApiResponse<ConsumerDisclosure> localVarResponse = this.getConsumerDisclosureDefaultWithHttpInfo(accountId, envelopeId, recipientId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ConsumerDisclosure> getConsumerDisclosureDefaultWithHttpInfo(String accountId, String envelopeId, String recipientId, GetConsumerDisclosureDefaultOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConsumerDisclosureDefault");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getConsumerDisclosureDefault");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getConsumerDisclosureDefault");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("langCode", options.langCode));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ConsumerDisclosure> localVarReturnType = new GenericType<ConsumerDisclosure>(){};
        ConsumerDisclosure localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ConsumerDisclosure>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.getDocument(accountId, envelopeId, documentId, null);
    }

    public byte[] getDocument(String accountId, String envelopeId, String documentId, GetDocumentOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getDocumentWithHttpInfo(accountId, envelopeId, documentId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getDocumentWithHttpInfo(String accountId, String envelopeId, String documentId, GetDocumentOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("certificate", options.certificate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("documents_by_userid", options.documentsByUserid));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encoding", options.encoding));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encrypt", options.encrypt));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("language", options.language));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("recipient_id", options.recipientId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shared_user_id", options.sharedUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watermark", options.watermark));
        }
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getDocumentPageImage(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        return this.getDocumentPageImage(accountId, envelopeId, documentId, pageNumber, null);
    }

    public byte[] getDocumentPageImage(String accountId, String envelopeId, String documentId, String pageNumber, GetDocumentPageImageOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getDocumentPageImageWithHttpInfo(accountId, envelopeId, documentId, pageNumber, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getDocumentPageImageWithHttpInfo(String accountId, String envelopeId, String documentId, String pageNumber, GetDocumentPageImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocumentPageImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocumentPageImage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocumentPageImage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling getDocumentPageImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dpi", options.dpi));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_height", options.maxHeight));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_width", options.maxWidth));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        String[] localVarAccepts = new String[]{"image/png"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs getDocumentTabs(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.getDocumentTabs(accountId, envelopeId, documentId, null);
    }

    public Tabs getDocumentTabs(String accountId, String envelopeId, String documentId, GetDocumentTabsOptions options) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.getDocumentTabsWithHttpInfo(accountId, envelopeId, documentId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> getDocumentTabsWithHttpInfo(String accountId, String envelopeId, String documentId, GetDocumentTabsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocumentTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_numbers", options.pageNumbers));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EmailSettings getEmailSettings(String accountId, String envelopeId) throws ApiException {
        ApiResponse<EmailSettings> localVarResponse = this.getEmailSettingsWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<EmailSettings> getEmailSettingsWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEmailSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        EmailSettings localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EmailSettings>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Envelope getEnvelope(String accountId, String envelopeId) throws ApiException {
        return this.getEnvelope(accountId, envelopeId, null);
    }

    public Envelope getEnvelope(String accountId, String envelopeId, GetEnvelopeOptions options) throws ApiException {
        ApiResponse<Envelope> localVarResponse = this.getEnvelopeWithHttpInfo(accountId, envelopeId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Envelope> getEnvelopeWithHttpInfo(String accountId, String envelopeId, GetEnvelopeOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelope");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelope");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("advanced_update", options.advancedUpdate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Envelope> localVarReturnType = new GenericType<Envelope>(){};
        Envelope localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Envelope>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DelayedRouting getEnvelopeDelayedRoutingDefinition(String accountId, String envelopeId, String workflowStepId) throws ApiException {
        ApiResponse<DelayedRouting> localVarResponse = this.getEnvelopeDelayedRoutingDefinitionWithHttpInfo(accountId, envelopeId, workflowStepId);
        return localVarResponse.getData();
    }

    public ApiResponse<DelayedRouting> getEnvelopeDelayedRoutingDefinitionWithHttpInfo(String accountId, String envelopeId, String workflowStepId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeDelayedRoutingDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeDelayedRoutingDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling getEnvelopeDelayedRoutingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DelayedRouting> localVarReturnType = new GenericType<DelayedRouting>(){};
        DelayedRouting localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DelayedRouting>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentHtmlDefinitionOriginals getEnvelopeDocumentHtmlDefinitions(String accountId, String envelopeId, String documentId) throws ApiException {
        ApiResponse<DocumentHtmlDefinitionOriginals> localVarResponse = this.getEnvelopeDocumentHtmlDefinitionsWithHttpInfo(accountId, envelopeId, documentId);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentHtmlDefinitionOriginals> getEnvelopeDocumentHtmlDefinitionsWithHttpInfo(String accountId, String envelopeId, String documentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeDocumentHtmlDefinitions");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeDocumentHtmlDefinitions");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getEnvelopeDocumentHtmlDefinitions");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/html_definitions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitionOriginals> localVarReturnType = new GenericType<DocumentHtmlDefinitionOriginals>(){};
        DocumentHtmlDefinitionOriginals localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentHtmlDefinitionOriginals>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentHtmlDefinitionOriginals getEnvelopeHtmlDefinitions(String accountId, String envelopeId) throws ApiException {
        ApiResponse<DocumentHtmlDefinitionOriginals> localVarResponse = this.getEnvelopeHtmlDefinitionsWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentHtmlDefinitionOriginals> getEnvelopeHtmlDefinitionsWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeHtmlDefinitions");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeHtmlDefinitions");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/html_definitions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitionOriginals> localVarReturnType = new GenericType<DocumentHtmlDefinitionOriginals>(){};
        DocumentHtmlDefinitionOriginals localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentHtmlDefinitionOriginals>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ScheduledSending getEnvelopeScheduledSendingDefinition(String accountId, String envelopeId) throws ApiException {
        ApiResponse<ScheduledSending> localVarResponse = this.getEnvelopeScheduledSendingDefinitionWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<ScheduledSending> getEnvelopeScheduledSendingDefinitionWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeScheduledSendingDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeScheduledSendingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ScheduledSending> localVarReturnType = new GenericType<ScheduledSending>(){};
        ScheduledSending localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ScheduledSending>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeTransferRuleInformation getEnvelopeTransferRules(String accountId) throws ApiException {
        return this.getEnvelopeTransferRules(accountId, null);
    }

    public EnvelopeTransferRuleInformation getEnvelopeTransferRules(String accountId, GetEnvelopeTransferRulesOptions options) throws ApiException {
        ApiResponse<EnvelopeTransferRuleInformation> localVarResponse = this.getEnvelopeTransferRulesWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeTransferRuleInformation> getEnvelopeTransferRulesWithHttpInfo(String accountId, GetEnvelopeTransferRulesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeTransferRules");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTransferRuleInformation> localVarReturnType = new GenericType<EnvelopeTransferRuleInformation>(){};
        EnvelopeTransferRuleInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeTransferRuleInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Workflow getEnvelopeWorkflowDefinition(String accountId, String envelopeId) throws ApiException {
        ApiResponse<Workflow> localVarResponse = this.getEnvelopeWorkflowDefinitionWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<Workflow> getEnvelopeWorkflowDefinitionWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeWorkflowDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        Workflow localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Workflow>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowStep getEnvelopeWorkflowStepDefinition(String accountId, String envelopeId, String workflowStepId) throws ApiException {
        ApiResponse<WorkflowStep> localVarResponse = this.getEnvelopeWorkflowStepDefinitionWithHttpInfo(accountId, envelopeId, workflowStepId);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowStep> getEnvelopeWorkflowStepDefinitionWithHttpInfo(String accountId, String envelopeId, String workflowStepId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getEnvelopeWorkflowStepDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getEnvelopeWorkflowStepDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling getEnvelopeWorkflowStepDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowStep> localVarReturnType = new GenericType<WorkflowStep>(){};
        WorkflowStep localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowStep>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeFormData getFormData(String accountId, String envelopeId) throws ApiException {
        ApiResponse<EnvelopeFormData> localVarResponse = this.getFormDataWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeFormData> getFormDataWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFormData");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getFormData");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/form_data".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeFormData> localVarReturnType = new GenericType<EnvelopeFormData>(){};
        EnvelopeFormData localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeFormData>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public LockInformation getLock(String accountId, String envelopeId) throws ApiException {
        ApiResponse<LockInformation> localVarResponse = this.getLockWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInformation> getLockWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        LockInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<LockInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Notification getNotificationSettings(String accountId, String envelopeId) throws ApiException {
        ApiResponse<Notification> localVarResponse = this.getNotificationSettingsWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<Notification> getNotificationSettingsWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getNotificationSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getNotificationSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Notification> localVarReturnType = new GenericType<Notification>(){};
        Notification localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Notification>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs getPageTabs(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.getPageTabsWithHttpInfo(accountId, envelopeId, documentId, pageNumber);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> getPageTabsWithHttpInfo(String accountId, String envelopeId, String documentId, String pageNumber) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPageTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getPageTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getPageTabs");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling getPageTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public PageImages getPages(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.getPages(accountId, envelopeId, documentId, null);
    }

    public PageImages getPages(String accountId, String envelopeId, String documentId, GetPagesOptions options) throws ApiException {
        ApiResponse<PageImages> localVarResponse = this.getPagesWithHttpInfo(accountId, envelopeId, documentId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<PageImages> getPagesWithHttpInfo(String accountId, String envelopeId, String documentId, GetPagesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPages");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getPages");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getPages");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dpi", options.dpi));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_height", options.maxHeight));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_width", options.maxWidth));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nocache", options.nocache));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<PageImages> localVarReturnType = new GenericType<PageImages>(){};
        PageImages localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<PageImages>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentVisibilityList getRecipientDocumentVisibility(String accountId, String envelopeId, String recipientId) throws ApiException {
        ApiResponse<DocumentVisibilityList> localVarResponse = this.getRecipientDocumentVisibilityWithHttpInfo(accountId, envelopeId, recipientId);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentVisibilityList> getRecipientDocumentVisibilityWithHttpInfo(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentVisibilityList> localVarReturnType = new GenericType<DocumentVisibilityList>(){};
        DocumentVisibilityList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentVisibilityList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getRecipientInitialsImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getRecipientInitialsImage(accountId, envelopeId, recipientId, null);
    }

    public byte[] getRecipientInitialsImage(String accountId, String envelopeId, String recipientId, GetRecipientInitialsImageOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getRecipientInitialsImageWithHttpInfo(accountId, envelopeId, recipientId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getRecipientInitialsImageWithHttpInfo(String accountId, String envelopeId, String recipientId, GetRecipientInitialsImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientInitialsImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientInitialsImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientInitialsImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_chrome", options.includeChrome));
        }
        String[] localVarAccepts = new String[]{"image/gif"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UserSignature getRecipientSignature(String accountId, String envelopeId, String recipientId) throws ApiException {
        ApiResponse<UserSignature> localVarResponse = this.getRecipientSignatureWithHttpInfo(accountId, envelopeId, recipientId);
        return localVarResponse.getData();
    }

    public ApiResponse<UserSignature> getRecipientSignatureWithHttpInfo(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientSignature");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientSignature");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientSignature");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        UserSignature localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UserSignature>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getRecipientSignatureImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.getRecipientSignatureImage(accountId, envelopeId, recipientId, null);
    }

    public byte[] getRecipientSignatureImage(String accountId, String envelopeId, String recipientId, GetRecipientSignatureImageOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getRecipientSignatureImageWithHttpInfo(accountId, envelopeId, recipientId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getRecipientSignatureImageWithHttpInfo(String accountId, String envelopeId, String recipientId, GetRecipientSignatureImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRecipientSignatureImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getRecipientSignatureImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getRecipientSignatureImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_chrome", options.includeChrome));
        }
        String[] localVarAccepts = new String[]{"image/gif"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void getTabsBlob(String accountId, String envelopeId) throws ApiException {
        this.getTabsBlobWithHttpInfo(accountId, envelopeId);
    }

    public ApiResponse<Object> getTabsBlobWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTabsBlob");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling getTabsBlob");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public DelayedRouting getTemplateDelayedRoutingDefinition(String accountId, String templateId, String workflowStepId) throws ApiException {
        ApiResponse<DelayedRouting> localVarResponse = this.getTemplateDelayedRoutingDefinitionWithHttpInfo(accountId, templateId, workflowStepId);
        return localVarResponse.getData();
    }

    public ApiResponse<DelayedRouting> getTemplateDelayedRoutingDefinitionWithHttpInfo(String accountId, String templateId, String workflowStepId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateDelayedRoutingDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateDelayedRoutingDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling getTemplateDelayedRoutingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DelayedRouting> localVarReturnType = new GenericType<DelayedRouting>(){};
        DelayedRouting localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DelayedRouting>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentVisibilityList getTemplateRecipientDocumentVisibility(String accountId, String templateId, String recipientId) throws ApiException {
        ApiResponse<DocumentVisibilityList> localVarResponse = this.getTemplateRecipientDocumentVisibilityWithHttpInfo(accountId, templateId, recipientId);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentVisibilityList> getTemplateRecipientDocumentVisibilityWithHttpInfo(String accountId, String templateId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateRecipientDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling getTemplateRecipientDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentVisibilityList> localVarReturnType = new GenericType<DocumentVisibilityList>(){};
        DocumentVisibilityList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentVisibilityList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ScheduledSending getTemplateScheduledSendingDefinition(String accountId, String templateId) throws ApiException {
        ApiResponse<ScheduledSending> localVarResponse = this.getTemplateScheduledSendingDefinitionWithHttpInfo(accountId, templateId);
        return localVarResponse.getData();
    }

    public ApiResponse<ScheduledSending> getTemplateScheduledSendingDefinitionWithHttpInfo(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateScheduledSendingDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateScheduledSendingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ScheduledSending> localVarReturnType = new GenericType<ScheduledSending>(){};
        ScheduledSending localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ScheduledSending>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Workflow getTemplateWorkflowDefinition(String accountId, String templateId) throws ApiException {
        ApiResponse<Workflow> localVarResponse = this.getTemplateWorkflowDefinitionWithHttpInfo(accountId, templateId);
        return localVarResponse.getData();
    }

    public ApiResponse<Workflow> getTemplateWorkflowDefinitionWithHttpInfo(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateWorkflowDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        Workflow localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Workflow>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowStep getTemplateWorkflowStepDefinition(String accountId, String templateId, String workflowStepId) throws ApiException {
        ApiResponse<WorkflowStep> localVarResponse = this.getTemplateWorkflowStepDefinitionWithHttpInfo(accountId, templateId, workflowStepId);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowStep> getTemplateWorkflowStepDefinitionWithHttpInfo(String accountId, String templateId, String workflowStepId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateWorkflowStepDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateWorkflowStepDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling getTemplateWorkflowStepDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowStep> localVarReturnType = new GenericType<WorkflowStep>(){};
        WorkflowStep localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowStep>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeAuditEventResponse listAuditEvents(String accountId, String envelopeId) throws ApiException {
        ApiResponse<EnvelopeAuditEventResponse> localVarResponse = this.listAuditEventsWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeAuditEventResponse> listAuditEventsWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listAuditEvents");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listAuditEvents");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/audit_events".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAuditEventResponse> localVarReturnType = new GenericType<EnvelopeAuditEventResponse>(){};
        EnvelopeAuditEventResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeAuditEventResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomFieldsEnvelope listCustomFields(String accountId, String envelopeId) throws ApiException {
        ApiResponse<CustomFieldsEnvelope> localVarResponse = this.listCustomFieldsWithHttpInfo(accountId, envelopeId);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomFieldsEnvelope> listCustomFieldsWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFieldsEnvelope> localVarReturnType = new GenericType<CustomFieldsEnvelope>(){};
        CustomFieldsEnvelope localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomFieldsEnvelope>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentFieldsInformation listDocumentFields(String accountId, String envelopeId, String documentId) throws ApiException {
        ApiResponse<DocumentFieldsInformation> localVarResponse = this.listDocumentFieldsWithHttpInfo(accountId, envelopeId, documentId);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentFieldsInformation> listDocumentFieldsWithHttpInfo(String accountId, String envelopeId, String documentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        DocumentFieldsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentFieldsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeDocumentsResult listDocuments(String accountId, String envelopeId) throws ApiException {
        return this.listDocuments(accountId, envelopeId, null);
    }

    public EnvelopeDocumentsResult listDocuments(String accountId, String envelopeId, ListDocumentsOptions options) throws ApiException {
        ApiResponse<EnvelopeDocumentsResult> localVarResponse = this.listDocumentsWithHttpInfo(accountId, envelopeId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeDocumentsResult> listDocumentsWithHttpInfo(String accountId, String envelopeId, ListDocumentsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("documents_by_userid", options.documentsByUserid));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_document_size", options.includeDocumentSize));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_tabs", options.includeTabs));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("recipient_id", options.recipientId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shared_user_id", options.sharedUserId));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        EnvelopeDocumentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeDocumentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Recipients listRecipients(String accountId, String envelopeId) throws ApiException {
        return this.listRecipients(accountId, envelopeId, null);
    }

    public Recipients listRecipients(String accountId, String envelopeId, ListRecipientsOptions options) throws ApiException {
        ApiResponse<Recipients> localVarResponse = this.listRecipientsWithHttpInfo(accountId, envelopeId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Recipients> listRecipientsWithHttpInfo(String accountId, String envelopeId, ListRecipientsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_anchor_tab_locations", options.includeAnchorTabLocations));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_extended", options.includeExtended));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_tabs", options.includeTabs));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        Recipients localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Recipients>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopesInformation listStatus(String accountId, EnvelopeIdsRequest envelopeIdsRequest) throws ApiException {
        return this.listStatus(accountId, envelopeIdsRequest, null);
    }

    public EnvelopesInformation listStatus(String accountId, EnvelopeIdsRequest envelopeIdsRequest, ListStatusOptions options) throws ApiException {
        ApiResponse<EnvelopesInformation> localVarResponse = this.listStatusWithHttpInfo(accountId, envelopeIdsRequest, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopesInformation> listStatusWithHttpInfo(String accountId, EnvelopeIdsRequest envelopeIdsRequest, ListStatusOptions options) throws ApiException {
        EnvelopeIdsRequest localVarPostBody = envelopeIdsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listStatus");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/status".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ac_status", options.acStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("block", options.block));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("envelope_ids", options.envelopeIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_to_status", options.fromToStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transaction_ids", options.transactionIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_name", options.userName));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopesInformation> localVarReturnType = new GenericType<EnvelopesInformation>(){};
        EnvelopesInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopesInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopesInformation listStatusChanges(String accountId) throws ApiException {
        return this.listStatusChanges(accountId, null);
    }

    public EnvelopesInformation listStatusChanges(String accountId, ListStatusChangesOptions options) throws ApiException {
        ApiResponse<EnvelopesInformation> localVarResponse = this.listStatusChangesWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopesInformation> listStatusChangesWithHttpInfo(String accountId, ListStatusChangesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listStatusChanges");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ac_status", options.acStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("block", options.block));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cdse_mode", options.cdseMode));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("continuation_token", options.continuationToken));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("custom_field", options.customField));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("envelope_ids", options.envelopeIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("exclude", options.exclude));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder_ids", options.folderIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder_types", options.folderTypes));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_to_status", options.fromToStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_purge_information", options.includePurgeInformation));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("intersecting_folder_ids", options.intersectingFolderIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_queried_date", options.lastQueriedDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order", options.order));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order_by", options.orderBy));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("powerformids", options.powerformids));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query_budget", options.queryBudget));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("requester_date_format", options.requesterDateFormat));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_text", options.searchText));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transaction_ids", options.transactionIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_filter", options.userFilter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_id", options.userId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_name", options.userName));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopesInformation> localVarReturnType = new GenericType<EnvelopesInformation>(){};
        EnvelopesInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopesInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs listTabs(String accountId, String envelopeId, String recipientId) throws ApiException {
        return this.listTabs(accountId, envelopeId, recipientId, null);
    }

    public Tabs listTabs(String accountId, String envelopeId, String recipientId, ListTabsOptions options) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.listTabsWithHttpInfo(accountId, envelopeId, recipientId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> listTabsWithHttpInfo(String accountId, String envelopeId, String recipientId, ListTabsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling listTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_anchor_tab_locations", options.includeAnchorTabLocations));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateInformation listTemplates(String accountId, String envelopeId) throws ApiException {
        return this.listTemplates(accountId, envelopeId, null);
    }

    public TemplateInformation listTemplates(String accountId, String envelopeId, ListTemplatesOptions options) throws ApiException {
        ApiResponse<TemplateInformation> localVarResponse = this.listTemplatesWithHttpInfo(accountId, envelopeId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateInformation> listTemplatesWithHttpInfo(String accountId, String envelopeId, ListTemplatesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplates");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTemplates");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateInformation> localVarReturnType = new GenericType<TemplateInformation>(){};
        TemplateInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateInformation listTemplatesForDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        return this.listTemplatesForDocument(accountId, envelopeId, documentId, null);
    }

    public TemplateInformation listTemplatesForDocument(String accountId, String envelopeId, String documentId, ListTemplatesForDocumentOptions options) throws ApiException {
        ApiResponse<TemplateInformation> localVarResponse = this.listTemplatesForDocumentWithHttpInfo(accountId, envelopeId, documentId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateInformation> listTemplatesForDocumentWithHttpInfo(String accountId, String envelopeId, String documentId, ListTemplatesForDocumentOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplatesForDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling listTemplatesForDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listTemplatesForDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateInformation> localVarReturnType = new GenericType<TemplateInformation>(){};
        TemplateInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeAttachmentsResult putAttachment(String accountId, String envelopeId, String attachmentId, Attachment attachment) throws ApiException {
        ApiResponse<EnvelopeAttachmentsResult> localVarResponse = this.putAttachmentWithHttpInfo(accountId, envelopeId, attachmentId, attachment);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeAttachmentsResult> putAttachmentWithHttpInfo(String accountId, String envelopeId, String attachmentId, Attachment attachment) throws ApiException {
        Attachment localVarPostBody = attachment;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putAttachment");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling putAttachment");
        }
        if (attachmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentId' when calling putAttachment");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{attachmentId\\}", this.apiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAttachmentsResult> localVarReturnType = new GenericType<EnvelopeAttachmentsResult>(){};
        EnvelopeAttachmentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeAttachmentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeAttachmentsResult putAttachments(String accountId, String envelopeId, EnvelopeAttachmentsRequest envelopeAttachmentsRequest) throws ApiException {
        ApiResponse<EnvelopeAttachmentsResult> localVarResponse = this.putAttachmentsWithHttpInfo(accountId, envelopeId, envelopeAttachmentsRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeAttachmentsResult> putAttachmentsWithHttpInfo(String accountId, String envelopeId, EnvelopeAttachmentsRequest envelopeAttachmentsRequest) throws ApiException {
        EnvelopeAttachmentsRequest localVarPostBody = envelopeAttachmentsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putAttachments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling putAttachments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeAttachmentsResult> localVarReturnType = new GenericType<EnvelopeAttachmentsResult>(){};
        EnvelopeAttachmentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeAttachmentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void rotateDocumentPage(String accountId, String envelopeId, String documentId, String pageNumber, PageRequest pageRequest) throws ApiException {
        this.rotateDocumentPageWithHttpInfo(accountId, envelopeId, documentId, pageNumber, pageRequest);
    }

    public ApiResponse<Object> rotateDocumentPageWithHttpInfo(String accountId, String envelopeId, String documentId, String pageNumber, PageRequest pageRequest) throws ApiException {
        PageRequest localVarPostBody = pageRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling rotateDocumentPage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling rotateDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling rotateDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling rotateDocumentPage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public EnvelopeUpdateSummary update(String accountId, String envelopeId, Envelope envelope) throws ApiException {
        return this.update(accountId, envelopeId, envelope, null);
    }

    public EnvelopeUpdateSummary update(String accountId, String envelopeId, Envelope envelope, UpdateOptions options) throws ApiException {
        ApiResponse<EnvelopeUpdateSummary> localVarResponse = this.updateWithHttpInfo(accountId, envelopeId, envelope, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeUpdateSummary> updateWithHttpInfo(String accountId, String envelopeId, Envelope envelope, UpdateOptions options) throws ApiException {
        Envelope localVarPostBody = envelope;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling update");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling update");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("advanced_update", options.advancedUpdate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeUpdateSummary> localVarReturnType = new GenericType<EnvelopeUpdateSummary>(){};
        EnvelopeUpdateSummary localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeUpdateSummary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ChunkedUploadResponse updateChunkedUpload(String accountId, String chunkedUploadId) throws ApiException {
        return this.updateChunkedUpload(accountId, chunkedUploadId, null);
    }

    public ChunkedUploadResponse updateChunkedUpload(String accountId, String chunkedUploadId, UpdateChunkedUploadOptions options) throws ApiException {
        ApiResponse<ChunkedUploadResponse> localVarResponse = this.updateChunkedUploadWithHttpInfo(accountId, chunkedUploadId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<ChunkedUploadResponse> updateChunkedUploadWithHttpInfo(String accountId, String chunkedUploadId, UpdateChunkedUploadOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateChunkedUpload");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling updateChunkedUpload");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("action", options.action));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        ChunkedUploadResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ChunkedUploadResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ChunkedUploadResponse updateChunkedUploadPart(String accountId, String chunkedUploadId, String chunkedUploadPartSeq, ChunkedUploadRequest chunkedUploadRequest) throws ApiException {
        ApiResponse<ChunkedUploadResponse> localVarResponse = this.updateChunkedUploadPartWithHttpInfo(accountId, chunkedUploadId, chunkedUploadPartSeq, chunkedUploadRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ChunkedUploadResponse> updateChunkedUploadPartWithHttpInfo(String accountId, String chunkedUploadId, String chunkedUploadPartSeq, ChunkedUploadRequest chunkedUploadRequest) throws ApiException {
        ChunkedUploadRequest localVarPostBody = chunkedUploadRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateChunkedUploadPart");
        }
        if (chunkedUploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadId' when calling updateChunkedUploadPart");
        }
        if (chunkedUploadPartSeq == null) {
            throw new ApiException(400, "Missing the required parameter 'chunkedUploadPartSeq' when calling updateChunkedUploadPart");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{chunkedUploadId\\}", this.apiClient.escapeString(chunkedUploadId.toString())).replaceAll("\\{chunkedUploadPartSeq\\}", this.apiClient.escapeString(chunkedUploadPartSeq.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ChunkedUploadResponse> localVarReturnType = new GenericType<ChunkedUploadResponse>(){};
        ChunkedUploadResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ChunkedUploadResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomFields updateCustomFields(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        ApiResponse<CustomFields> localVarResponse = this.updateCustomFieldsWithHttpInfo(accountId, envelopeId, customFields);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomFields> updateCustomFieldsWithHttpInfo(String accountId, String envelopeId, CustomFields customFields) throws ApiException {
        CustomFields localVarPostBody = customFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateCustomFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        CustomFields localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomFields>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeDocument updateDocument(String accountId, String envelopeId, String documentId) throws ApiException {
        ApiResponse<EnvelopeDocument> localVarResponse = this.updateDocumentWithHttpInfo(accountId, envelopeId, documentId);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeDocument> updateDocumentWithHttpInfo(String accountId, String envelopeId, String documentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocument> localVarReturnType = new GenericType<EnvelopeDocument>(){};
        EnvelopeDocument localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeDocument>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentFieldsInformation updateDocumentFields(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        ApiResponse<DocumentFieldsInformation> localVarResponse = this.updateDocumentFieldsWithHttpInfo(accountId, envelopeId, documentId, documentFieldsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentFieldsInformation> updateDocumentFieldsWithHttpInfo(String accountId, String envelopeId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocumentFields");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        DocumentFieldsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentFieldsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs updateDocumentTabs(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.updateDocumentTabsWithHttpInfo(accountId, envelopeId, documentId, tabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> updateDocumentTabsWithHttpInfo(String accountId, String envelopeId, String documentId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocumentTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeDocumentsResult updateDocuments(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        ApiResponse<EnvelopeDocumentsResult> localVarResponse = this.updateDocumentsWithHttpInfo(accountId, envelopeId, envelopeDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeDocumentsResult> updateDocumentsWithHttpInfo(String accountId, String envelopeId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocuments");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocumentsResult> localVarReturnType = new GenericType<EnvelopeDocumentsResult>(){};
        EnvelopeDocumentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeDocumentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EmailSettings updateEmailSettings(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        ApiResponse<EmailSettings> localVarResponse = this.updateEmailSettingsWithHttpInfo(accountId, envelopeId, emailSettings);
        return localVarResponse.getData();
    }

    public ApiResponse<EmailSettings> updateEmailSettingsWithHttpInfo(String accountId, String envelopeId, EmailSettings emailSettings) throws ApiException {
        EmailSettings localVarPostBody = emailSettings;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEmailSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEmailSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EmailSettings> localVarReturnType = new GenericType<EmailSettings>(){};
        EmailSettings localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EmailSettings>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DelayedRouting updateEnvelopeDelayedRoutingDefinition(String accountId, String envelopeId, String workflowStepId, DelayedRouting delayedRouting) throws ApiException {
        ApiResponse<DelayedRouting> localVarResponse = this.updateEnvelopeDelayedRoutingDefinitionWithHttpInfo(accountId, envelopeId, workflowStepId, delayedRouting);
        return localVarResponse.getData();
    }

    public ApiResponse<DelayedRouting> updateEnvelopeDelayedRoutingDefinitionWithHttpInfo(String accountId, String envelopeId, String workflowStepId, DelayedRouting delayedRouting) throws ApiException {
        DelayedRouting localVarPostBody = delayedRouting;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeDelayedRoutingDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEnvelopeDelayedRoutingDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling updateEnvelopeDelayedRoutingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DelayedRouting> localVarReturnType = new GenericType<DelayedRouting>(){};
        DelayedRouting localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DelayedRouting>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ScheduledSending updateEnvelopeScheduledSendingDefinition(String accountId, String envelopeId, ScheduledSending scheduledSending) throws ApiException {
        ApiResponse<ScheduledSending> localVarResponse = this.updateEnvelopeScheduledSendingDefinitionWithHttpInfo(accountId, envelopeId, scheduledSending);
        return localVarResponse.getData();
    }

    public ApiResponse<ScheduledSending> updateEnvelopeScheduledSendingDefinitionWithHttpInfo(String accountId, String envelopeId, ScheduledSending scheduledSending) throws ApiException {
        ScheduledSending localVarPostBody = scheduledSending;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeScheduledSendingDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEnvelopeScheduledSendingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ScheduledSending> localVarReturnType = new GenericType<ScheduledSending>(){};
        ScheduledSending localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ScheduledSending>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeTransferRule updateEnvelopeTransferRule(String accountId, String envelopeTransferRuleId, EnvelopeTransferRule envelopeTransferRule) throws ApiException {
        ApiResponse<EnvelopeTransferRule> localVarResponse = this.updateEnvelopeTransferRuleWithHttpInfo(accountId, envelopeTransferRuleId, envelopeTransferRule);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeTransferRule> updateEnvelopeTransferRuleWithHttpInfo(String accountId, String envelopeTransferRuleId, EnvelopeTransferRule envelopeTransferRule) throws ApiException {
        EnvelopeTransferRule localVarPostBody = envelopeTransferRule;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeTransferRule");
        }
        if (envelopeTransferRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeTransferRuleId' when calling updateEnvelopeTransferRule");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeTransferRuleId\\}", this.apiClient.escapeString(envelopeTransferRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTransferRule> localVarReturnType = new GenericType<EnvelopeTransferRule>(){};
        EnvelopeTransferRule localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeTransferRule>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeTransferRuleInformation updateEnvelopeTransferRules(String accountId, EnvelopeTransferRuleInformation envelopeTransferRuleInformation) throws ApiException {
        ApiResponse<EnvelopeTransferRuleInformation> localVarResponse = this.updateEnvelopeTransferRulesWithHttpInfo(accountId, envelopeTransferRuleInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeTransferRuleInformation> updateEnvelopeTransferRulesWithHttpInfo(String accountId, EnvelopeTransferRuleInformation envelopeTransferRuleInformation) throws ApiException {
        EnvelopeTransferRuleInformation localVarPostBody = envelopeTransferRuleInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeTransferRules");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTransferRuleInformation> localVarReturnType = new GenericType<EnvelopeTransferRuleInformation>(){};
        EnvelopeTransferRuleInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeTransferRuleInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Workflow updateEnvelopeWorkflowDefinition(String accountId, String envelopeId, Workflow workflow) throws ApiException {
        ApiResponse<Workflow> localVarResponse = this.updateEnvelopeWorkflowDefinitionWithHttpInfo(accountId, envelopeId, workflow);
        return localVarResponse.getData();
    }

    public ApiResponse<Workflow> updateEnvelopeWorkflowDefinitionWithHttpInfo(String accountId, String envelopeId, Workflow workflow) throws ApiException {
        Workflow localVarPostBody = workflow;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeWorkflowDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEnvelopeWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        Workflow localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Workflow>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowStep updateEnvelopeWorkflowStepDefinition(String accountId, String envelopeId, String workflowStepId, WorkflowStep workflowStep) throws ApiException {
        ApiResponse<WorkflowStep> localVarResponse = this.updateEnvelopeWorkflowStepDefinitionWithHttpInfo(accountId, envelopeId, workflowStepId, workflowStep);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowStep> updateEnvelopeWorkflowStepDefinitionWithHttpInfo(String accountId, String envelopeId, String workflowStepId, WorkflowStep workflowStep) throws ApiException {
        WorkflowStep localVarPostBody = workflowStep;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateEnvelopeWorkflowStepDefinition");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateEnvelopeWorkflowStepDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling updateEnvelopeWorkflowStepDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowStep> localVarReturnType = new GenericType<WorkflowStep>(){};
        WorkflowStep localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowStep>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public LockInformation updateLock(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        ApiResponse<LockInformation> localVarResponse = this.updateLockWithHttpInfo(accountId, envelopeId, lockRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInformation> updateLockWithHttpInfo(String accountId, String envelopeId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateLock");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        LockInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<LockInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Notification updateNotificationSettings(String accountId, String envelopeId, EnvelopeNotificationRequest envelopeNotificationRequest) throws ApiException {
        ApiResponse<Notification> localVarResponse = this.updateNotificationSettingsWithHttpInfo(accountId, envelopeId, envelopeNotificationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<Notification> updateNotificationSettingsWithHttpInfo(String accountId, String envelopeId, EnvelopeNotificationRequest envelopeNotificationRequest) throws ApiException {
        EnvelopeNotificationRequest localVarPostBody = envelopeNotificationRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateNotificationSettings");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateNotificationSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Notification> localVarReturnType = new GenericType<Notification>(){};
        Notification localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Notification>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentVisibilityList updateRecipientDocumentVisibility(String accountId, String envelopeId, String recipientId, DocumentVisibilityList documentVisibilityList) throws ApiException {
        ApiResponse<DocumentVisibilityList> localVarResponse = this.updateRecipientDocumentVisibilityWithHttpInfo(accountId, envelopeId, recipientId, documentVisibilityList);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentVisibilityList> updateRecipientDocumentVisibilityWithHttpInfo(String accountId, String envelopeId, String recipientId, DocumentVisibilityList documentVisibilityList) throws ApiException {
        DocumentVisibilityList localVarPostBody = documentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentVisibilityList> localVarReturnType = new GenericType<DocumentVisibilityList>(){};
        DocumentVisibilityList localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentVisibilityList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void updateRecipientInitialsImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        this.updateRecipientInitialsImageWithHttpInfo(accountId, envelopeId, recipientId);
    }

    public ApiResponse<Object> updateRecipientInitialsImageWithHttpInfo(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientInitialsImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientInitialsImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientInitialsImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"image/gif"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void updateRecipientSignatureImage(String accountId, String envelopeId, String recipientId) throws ApiException {
        this.updateRecipientSignatureImageWithHttpInfo(accountId, envelopeId, recipientId);
    }

    public ApiResponse<Object> updateRecipientSignatureImageWithHttpInfo(String accountId, String envelopeId, String recipientId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientSignatureImage");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientSignatureImage");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateRecipientSignatureImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"image/gif"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String envelopeId, Recipients recipients) throws ApiException {
        return this.updateRecipients(accountId, envelopeId, recipients, null);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String envelopeId, Recipients recipients, UpdateRecipientsOptions options) throws ApiException {
        ApiResponse<RecipientsUpdateSummary> localVarResponse = this.updateRecipientsWithHttpInfo(accountId, envelopeId, recipients, options);
        return localVarResponse.getData();
    }

    public ApiResponse<RecipientsUpdateSummary> updateRecipientsWithHttpInfo(String accountId, String envelopeId, Recipients recipients, UpdateRecipientsOptions options) throws ApiException {
        Recipients localVarPostBody = recipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipients");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("combine_same_order_recipients", options.combineSameOrderRecipients));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offline_signing", options.offlineSigning));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RecipientsUpdateSummary> localVarReturnType = new GenericType<RecipientsUpdateSummary>(){};
        RecipientsUpdateSummary localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<RecipientsUpdateSummary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentVisibilityList updateRecipientsDocumentVisibility(String accountId, String envelopeId, DocumentVisibilityList documentVisibilityList) throws ApiException {
        ApiResponse<DocumentVisibilityList> localVarResponse = this.updateRecipientsDocumentVisibilityWithHttpInfo(accountId, envelopeId, documentVisibilityList);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentVisibilityList> updateRecipientsDocumentVisibilityWithHttpInfo(String accountId, String envelopeId, DocumentVisibilityList documentVisibilityList) throws ApiException {
        DocumentVisibilityList localVarPostBody = documentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipientsDocumentVisibility");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRecipientsDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentVisibilityList> localVarReturnType = new GenericType<DocumentVisibilityList>(){};
        DocumentVisibilityList localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentVisibilityList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] updateRegenDocument(String accountId, String envelopeId, String regenDocumentId, Document document) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.updateRegenDocumentWithHttpInfo(accountId, envelopeId, regenDocumentId, document);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> updateRegenDocumentWithHttpInfo(String accountId, String envelopeId, String regenDocumentId, Document document) throws ApiException {
        Document localVarPostBody = document;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRegenDocument");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateRegenDocument");
        }
        if (regenDocumentId == null) {
            throw new ApiException(400, "Missing the required parameter 'regenDocumentId' when calling updateRegenDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{regenDocumentId}/regen".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{regenDocumentId\\}", this.apiClient.escapeString(regenDocumentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs updateTabs(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.updateTabsWithHttpInfo(accountId, envelopeId, recipientId, tabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> updateTabsWithHttpInfo(String accountId, String envelopeId, String recipientId, Tabs tabs) throws ApiException {
        Tabs localVarPostBody = tabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTabs");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void updateTabsBlob(String accountId, String envelopeId) throws ApiException {
        this.updateTabsBlobWithHttpInfo(accountId, envelopeId);
    }

    public ApiResponse<Object> updateTabsBlobWithHttpInfo(String accountId, String envelopeId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTabsBlob");
        }
        if (envelopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'envelopeId' when calling updateTabsBlob");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{envelopeId\\}", this.apiClient.escapeString(envelopeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public DelayedRouting updateTemplateDelayedRoutingDefinition(String accountId, String templateId, String workflowStepId, DelayedRouting delayedRouting) throws ApiException {
        ApiResponse<DelayedRouting> localVarResponse = this.updateTemplateDelayedRoutingDefinitionWithHttpInfo(accountId, templateId, workflowStepId, delayedRouting);
        return localVarResponse.getData();
    }

    public ApiResponse<DelayedRouting> updateTemplateDelayedRoutingDefinitionWithHttpInfo(String accountId, String templateId, String workflowStepId, DelayedRouting delayedRouting) throws ApiException {
        DelayedRouting localVarPostBody = delayedRouting;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateDelayedRoutingDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateDelayedRoutingDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling updateTemplateDelayedRoutingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DelayedRouting> localVarReturnType = new GenericType<DelayedRouting>(){};
        DelayedRouting localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DelayedRouting>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateDocumentVisibilityList updateTemplateRecipientDocumentVisibility(String accountId, String templateId, String recipientId, TemplateDocumentVisibilityList templateDocumentVisibilityList) throws ApiException {
        ApiResponse<TemplateDocumentVisibilityList> localVarResponse = this.updateTemplateRecipientDocumentVisibilityWithHttpInfo(accountId, templateId, recipientId, templateDocumentVisibilityList);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateDocumentVisibilityList> updateTemplateRecipientDocumentVisibilityWithHttpInfo(String accountId, String templateId, String recipientId, TemplateDocumentVisibilityList templateDocumentVisibilityList) throws ApiException {
        TemplateDocumentVisibilityList localVarPostBody = templateDocumentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateRecipientDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateRecipientDocumentVisibility");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateTemplateRecipientDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateDocumentVisibilityList> localVarReturnType = new GenericType<TemplateDocumentVisibilityList>(){};
        TemplateDocumentVisibilityList localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateDocumentVisibilityList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateDocumentVisibilityList updateTemplateRecipientsDocumentVisibility(String accountId, String templateId, TemplateDocumentVisibilityList templateDocumentVisibilityList) throws ApiException {
        ApiResponse<TemplateDocumentVisibilityList> localVarResponse = this.updateTemplateRecipientsDocumentVisibilityWithHttpInfo(accountId, templateId, templateDocumentVisibilityList);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateDocumentVisibilityList> updateTemplateRecipientsDocumentVisibilityWithHttpInfo(String accountId, String templateId, TemplateDocumentVisibilityList templateDocumentVisibilityList) throws ApiException {
        TemplateDocumentVisibilityList localVarPostBody = templateDocumentVisibilityList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateRecipientsDocumentVisibility");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateRecipientsDocumentVisibility");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/document_visibility".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateDocumentVisibilityList> localVarReturnType = new GenericType<TemplateDocumentVisibilityList>(){};
        TemplateDocumentVisibilityList localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateDocumentVisibilityList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ScheduledSending updateTemplateScheduledSendingDefinition(String accountId, String templateId, ScheduledSending scheduledSending) throws ApiException {
        ApiResponse<ScheduledSending> localVarResponse = this.updateTemplateScheduledSendingDefinitionWithHttpInfo(accountId, templateId, scheduledSending);
        return localVarResponse.getData();
    }

    public ApiResponse<ScheduledSending> updateTemplateScheduledSendingDefinitionWithHttpInfo(String accountId, String templateId, ScheduledSending scheduledSending) throws ApiException {
        ScheduledSending localVarPostBody = scheduledSending;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateScheduledSendingDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateScheduledSendingDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ScheduledSending> localVarReturnType = new GenericType<ScheduledSending>(){};
        ScheduledSending localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ScheduledSending>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Workflow updateTemplateWorkflowDefinition(String accountId, String templateId, Workflow workflow) throws ApiException {
        ApiResponse<Workflow> localVarResponse = this.updateTemplateWorkflowDefinitionWithHttpInfo(accountId, templateId, workflow);
        return localVarResponse.getData();
    }

    public ApiResponse<Workflow> updateTemplateWorkflowDefinitionWithHttpInfo(String accountId, String templateId, Workflow workflow) throws ApiException {
        Workflow localVarPostBody = workflow;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateWorkflowDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateWorkflowDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workflow> localVarReturnType = new GenericType<Workflow>(){};
        Workflow localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Workflow>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkflowStep updateTemplateWorkflowStepDefinition(String accountId, String templateId, String workflowStepId, WorkflowStep workflowStep) throws ApiException {
        ApiResponse<WorkflowStep> localVarResponse = this.updateTemplateWorkflowStepDefinitionWithHttpInfo(accountId, templateId, workflowStepId, workflowStep);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkflowStep> updateTemplateWorkflowStepDefinitionWithHttpInfo(String accountId, String templateId, String workflowStepId, WorkflowStep workflowStep) throws ApiException {
        WorkflowStep localVarPostBody = workflowStep;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateWorkflowStepDefinition");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateWorkflowStepDefinition");
        }
        if (workflowStepId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepId' when calling updateTemplateWorkflowStepDefinition");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{workflowStepId\\}", this.apiClient.escapeString(workflowStepId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkflowStep> localVarReturnType = new GenericType<WorkflowStep>(){};
        WorkflowStep localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkflowStep>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class UpdateRecipientsOptions {
        private String combineSameOrderRecipients = null;
        private String offlineSigning = null;
        private String resendEnvelope = null;

        public void setCombineSameOrderRecipients(String combineSameOrderRecipients) {
            this.combineSameOrderRecipients = combineSameOrderRecipients;
        }

        public String getCombineSameOrderRecipients() {
            return this.combineSameOrderRecipients;
        }

        public void setOfflineSigning(String offlineSigning) {
            this.offlineSigning = offlineSigning;
        }

        public String getOfflineSigning() {
            return this.offlineSigning;
        }

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class UpdateChunkedUploadOptions {
        private String action = null;

        public void setAction(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }

    public class UpdateOptions {
        private String advancedUpdate = null;
        private String resendEnvelope = null;

        public void setAdvancedUpdate(String advancedUpdate) {
            this.advancedUpdate = advancedUpdate;
        }

        public String getAdvancedUpdate() {
            return this.advancedUpdate;
        }

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class ListTemplatesForDocumentOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class ListTemplatesOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class ListTabsOptions {
        private String includeAnchorTabLocations = null;
        private String includeMetadata = null;

        public void setIncludeAnchorTabLocations(String includeAnchorTabLocations) {
            this.includeAnchorTabLocations = includeAnchorTabLocations;
        }

        public String getIncludeAnchorTabLocations() {
            return this.includeAnchorTabLocations;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }
    }

    public class ListStatusChangesOptions {
        private String acStatus = null;
        private String block = null;
        private String cdseMode = null;
        private String continuationToken = null;
        private String count = null;
        private String customField = null;
        private String email = null;
        private String envelopeIds = null;
        private String exclude = null;
        private String folderIds = null;
        private String folderTypes = null;
        private String fromDate = null;
        private String fromToStatus = null;
        private String include = null;
        private String includePurgeInformation = null;
        private String intersectingFolderIds = null;
        private String lastQueriedDate = null;
        private String order = null;
        private String orderBy = null;
        private String powerformids = null;
        private String queryBudget = null;
        private String requesterDateFormat = null;
        private String searchText = null;
        private String startPosition = null;
        private String status = null;
        private String toDate = null;
        private String transactionIds = null;
        private String userFilter = null;
        private String userId = null;
        private String userName = null;

        public void setAcStatus(String acStatus) {
            this.acStatus = acStatus;
        }

        public String getAcStatus() {
            return this.acStatus;
        }

        public void setBlock(String block) {
            this.block = block;
        }

        public String getBlock() {
            return this.block;
        }

        public void setCdseMode(String cdseMode) {
            this.cdseMode = cdseMode;
        }

        public String getCdseMode() {
            return this.cdseMode;
        }

        public void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setCustomField(String customField) {
            this.customField = customField;
        }

        public String getCustomField() {
            return this.customField;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEnvelopeIds(String envelopeIds) {
            this.envelopeIds = envelopeIds;
        }

        public String getEnvelopeIds() {
            return this.envelopeIds;
        }

        public void setExclude(String exclude) {
            this.exclude = exclude;
        }

        public String getExclude() {
            return this.exclude;
        }

        public void setFolderIds(String folderIds) {
            this.folderIds = folderIds;
        }

        public String getFolderIds() {
            return this.folderIds;
        }

        public void setFolderTypes(String folderTypes) {
            this.folderTypes = folderTypes;
        }

        public String getFolderTypes() {
            return this.folderTypes;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setFromToStatus(String fromToStatus) {
            this.fromToStatus = fromToStatus;
        }

        public String getFromToStatus() {
            return this.fromToStatus;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setIncludePurgeInformation(String includePurgeInformation) {
            this.includePurgeInformation = includePurgeInformation;
        }

        public String getIncludePurgeInformation() {
            return this.includePurgeInformation;
        }

        public void setIntersectingFolderIds(String intersectingFolderIds) {
            this.intersectingFolderIds = intersectingFolderIds;
        }

        public String getIntersectingFolderIds() {
            return this.intersectingFolderIds;
        }

        public void setLastQueriedDate(String lastQueriedDate) {
            this.lastQueriedDate = lastQueriedDate;
        }

        public String getLastQueriedDate() {
            return this.lastQueriedDate;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setPowerformids(String powerformids) {
            this.powerformids = powerformids;
        }

        public String getPowerformids() {
            return this.powerformids;
        }

        public void setQueryBudget(String queryBudget) {
            this.queryBudget = queryBudget;
        }

        public String getQueryBudget() {
            return this.queryBudget;
        }

        public void setRequesterDateFormat(String requesterDateFormat) {
            this.requesterDateFormat = requesterDateFormat;
        }

        public String getRequesterDateFormat() {
            return this.requesterDateFormat;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setTransactionIds(String transactionIds) {
            this.transactionIds = transactionIds;
        }

        public String getTransactionIds() {
            return this.transactionIds;
        }

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }

        public String getUserFilter() {
            return this.userFilter;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    public class ListStatusOptions {
        private String acStatus = null;
        private String block = null;
        private String count = null;
        private String email = null;
        private String envelopeIds = null;
        private String fromDate = null;
        private String fromToStatus = null;
        private String startPosition = null;
        private String status = null;
        private String toDate = null;
        private String transactionIds = null;
        private String userName = null;

        public void setAcStatus(String acStatus) {
            this.acStatus = acStatus;
        }

        public String getAcStatus() {
            return this.acStatus;
        }

        public void setBlock(String block) {
            this.block = block;
        }

        public String getBlock() {
            return this.block;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEnvelopeIds(String envelopeIds) {
            this.envelopeIds = envelopeIds;
        }

        public String getEnvelopeIds() {
            return this.envelopeIds;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setFromToStatus(String fromToStatus) {
            this.fromToStatus = fromToStatus;
        }

        public String getFromToStatus() {
            return this.fromToStatus;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setTransactionIds(String transactionIds) {
            this.transactionIds = transactionIds;
        }

        public String getTransactionIds() {
            return this.transactionIds;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    public class ListRecipientsOptions {
        private String includeAnchorTabLocations = null;
        private String includeExtended = null;
        private String includeMetadata = null;
        private String includeTabs = null;

        public void setIncludeAnchorTabLocations(String includeAnchorTabLocations) {
            this.includeAnchorTabLocations = includeAnchorTabLocations;
        }

        public String getIncludeAnchorTabLocations() {
            return this.includeAnchorTabLocations;
        }

        public void setIncludeExtended(String includeExtended) {
            this.includeExtended = includeExtended;
        }

        public String getIncludeExtended() {
            return this.includeExtended;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }
    }

    public class ListDocumentsOptions {
        private String documentsByUserid = null;
        private String includeDocumentSize = null;
        private String includeMetadata = null;
        private String includeTabs = null;
        private String recipientId = null;
        private String sharedUserId = null;

        public void setDocumentsByUserid(String documentsByUserid) {
            this.documentsByUserid = documentsByUserid;
        }

        public String getDocumentsByUserid() {
            return this.documentsByUserid;
        }

        public void setIncludeDocumentSize(String includeDocumentSize) {
            this.includeDocumentSize = includeDocumentSize;
        }

        public String getIncludeDocumentSize() {
            return this.includeDocumentSize;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }

        public void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public String getRecipientId() {
            return this.recipientId;
        }

        public void setSharedUserId(String sharedUserId) {
            this.sharedUserId = sharedUserId;
        }

        public String getSharedUserId() {
            return this.sharedUserId;
        }
    }

    public class GetRecipientSignatureImageOptions {
        private String includeChrome = null;

        public void setIncludeChrome(String includeChrome) {
            this.includeChrome = includeChrome;
        }

        public String getIncludeChrome() {
            return this.includeChrome;
        }
    }

    public class GetRecipientInitialsImageOptions {
        private String includeChrome = null;

        public void setIncludeChrome(String includeChrome) {
            this.includeChrome = includeChrome;
        }

        public String getIncludeChrome() {
            return this.includeChrome;
        }
    }

    public class GetPagesOptions {
        private String count = null;
        private String dpi = null;
        private String maxHeight = null;
        private String maxWidth = null;
        private String nocache = null;
        private String showChanges = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setDpi(String dpi) {
            this.dpi = dpi;
        }

        public String getDpi() {
            return this.dpi;
        }

        public void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public String getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public String getMaxWidth() {
            return this.maxWidth;
        }

        public void setNocache(String nocache) {
            this.nocache = nocache;
        }

        public String getNocache() {
            return this.nocache;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetEnvelopeTransferRulesOptions {
        private String count = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetEnvelopeOptions {
        private String advancedUpdate = null;
        private String include = null;

        public void setAdvancedUpdate(String advancedUpdate) {
            this.advancedUpdate = advancedUpdate;
        }

        public String getAdvancedUpdate() {
            return this.advancedUpdate;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class GetDocumentTabsOptions {
        private String includeMetadata = null;
        private String pageNumbers = null;

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }

        public void setPageNumbers(String pageNumbers) {
            this.pageNumbers = pageNumbers;
        }

        public String getPageNumbers() {
            return this.pageNumbers;
        }
    }

    public class GetDocumentPageImageOptions {
        private String dpi = null;
        private String maxHeight = null;
        private String maxWidth = null;
        private String showChanges = null;

        public void setDpi(String dpi) {
            this.dpi = dpi;
        }

        public String getDpi() {
            return this.dpi;
        }

        public void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public String getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public String getMaxWidth() {
            return this.maxWidth;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }
    }

    public class GetDocumentOptions {
        private String certificate = null;
        private String documentsByUserid = null;
        private String encoding = null;
        private String encrypt = null;
        private String language = null;
        private String recipientId = null;
        private String sharedUserId = null;
        private String showChanges = null;
        private String watermark = null;

        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public void setDocumentsByUserid(String documentsByUserid) {
            this.documentsByUserid = documentsByUserid;
        }

        public String getDocumentsByUserid() {
            return this.documentsByUserid;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncrypt(String encrypt) {
            this.encrypt = encrypt;
        }

        public String getEncrypt() {
            return this.encrypt;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public String getRecipientId() {
            return this.recipientId;
        }

        public void setSharedUserId(String sharedUserId) {
            this.sharedUserId = sharedUserId;
        }

        public String getSharedUserId() {
            return this.sharedUserId;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }

        public void setWatermark(String watermark) {
            this.watermark = watermark;
        }

        public String getWatermark() {
            return this.watermark;
        }
    }

    public class GetConsumerDisclosureDefaultOptions {
        private String langCode = null;

        public void setLangCode(String langCode) {
            this.langCode = langCode;
        }

        public String getLangCode() {
            return this.langCode;
        }
    }

    public class GetConsumerDisclosureOptions {
        private String langCode2 = null;

        public void setLangCode2(String langCode2) {
            this.langCode2 = langCode2;
        }

        public String getLangCode2() {
            return this.langCode2;
        }
    }

    public class GetCommentsTranscriptOptions {
        private String encoding = null;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public class GetChunkedUploadOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class CreateRecipientOptions {
        private String resendEnvelope = null;

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class CreateEnvelopeOptions {
        private String cdseMode = null;
        private String changeRoutingOrder = null;
        private String completedDocumentsOnly = null;
        private String mergeRolesOnDraft = null;
        private String tabLabelExactMatches = null;

        public void setCdseMode(String cdseMode) {
            this.cdseMode = cdseMode;
        }

        public String getCdseMode() {
            return this.cdseMode;
        }

        public void setChangeRoutingOrder(String changeRoutingOrder) {
            this.changeRoutingOrder = changeRoutingOrder;
        }

        public String getChangeRoutingOrder() {
            return this.changeRoutingOrder;
        }

        public void setCompletedDocumentsOnly(String completedDocumentsOnly) {
            this.completedDocumentsOnly = completedDocumentsOnly;
        }

        public String getCompletedDocumentsOnly() {
            return this.completedDocumentsOnly;
        }

        public void setMergeRolesOnDraft(String mergeRolesOnDraft) {
            this.mergeRolesOnDraft = mergeRolesOnDraft;
        }

        public String getMergeRolesOnDraft() {
            return this.mergeRolesOnDraft;
        }

        public void setTabLabelExactMatches(String tabLabelExactMatches) {
            this.tabLabelExactMatches = tabLabelExactMatches;
        }

        public String getTabLabelExactMatches() {
            return this.tabLabelExactMatches;
        }
    }

    public class ApplyTemplateToDocumentOptions {
        private String preserveTemplateRecipient = null;

        public void setPreserveTemplateRecipient(String preserveTemplateRecipient) {
            this.preserveTemplateRecipient = preserveTemplateRecipient;
        }

        public String getPreserveTemplateRecipient() {
            return this.preserveTemplateRecipient;
        }
    }

    public class ApplyTemplateOptions {
        private String preserveTemplateRecipient = null;

        public void setPreserveTemplateRecipient(String preserveTemplateRecipient) {
            this.preserveTemplateRecipient = preserveTemplateRecipient;
        }

        public String getPreserveTemplateRecipient() {
            return this.preserveTemplateRecipient;
        }
    }
}

