/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.LazyArgLogger;
import com.diffplug.spotless.ThrowingEx;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

final class TimedLogger {
    public static final String MESSAGE_PREFIX_BEGIN = "[BEGIN] ";
    public static final String MESSAGE_PREFIX_END = "[END] ";
    public static final String MESSAGE_SUFFIX_TOOK = " (took {})";
    private final Logger logger;
    private final Ticker ticker;

    private TimedLogger(@Nonnull Logger logger, Ticker ticker) {
        this.logger = Objects.requireNonNull(logger);
        this.ticker = ticker;
    }

    public static TimedLogger forLogger(@Nonnull Logger logger) {
        return TimedLogger.forLogger(logger, Ticker.systemTicker());
    }

    public static TimedLogger forLogger(@Nonnull Logger logger, Ticker ticker) {
        return new TimedLogger(logger, ticker);
    }

    public TimedExec withInfo(@Nonnull String message, Object ... args) {
        return new TimedExec(() -> ((Logger)this.logger).isInfoEnabled(), (arg_0, arg_1) -> ((Logger)this.logger).info(arg_0, arg_1), this.ticker, message, args);
    }

    public TimedExec withDebug(@Nonnull String message, Object ... args) {
        return new TimedExec(() -> ((Logger)this.logger).isDebugEnabled(), (arg_0, arg_1) -> ((Logger)this.logger).debug(arg_0, arg_1), this.ticker, message, args);
    }

    public TimedExec withTrace(@Nonnull String message, Object ... args) {
        return new TimedExec(() -> ((Logger)this.logger).isTraceEnabled(), (arg_0, arg_1) -> ((Logger)this.logger).trace(arg_0, arg_1), this.ticker, message, args);
    }

    public TimedExec withWarn(@Nonnull String message, Object ... args) {
        return new TimedExec(() -> ((Logger)this.logger).isWarnEnabled(), (arg_0, arg_1) -> ((Logger)this.logger).warn(arg_0, arg_1), this.ticker, message, args);
    }

    public TimedExec withError(@Nonnull String message, Object ... args) {
        return new TimedExec(() -> ((Logger)this.logger).isErrorEnabled(), (arg_0, arg_1) -> ((Logger)this.logger).error(arg_0, arg_1), this.ticker, message, args);
    }

    static interface Ticker {
        public long read();

        public static Ticker systemTicker() {
            return System::currentTimeMillis;
        }
    }

    public static class TimedExec {
        @Nonnull
        private final LogActiveMethod logActiveMethod;
        @Nonnull
        private final LogToLevelMethod logMethod;
        @Nonnull
        private final Ticker ticker;
        @Nonnull
        private final String message;
        @Nonnull
        private final Object[] args;

        public TimedExec(LogActiveMethod logActiveMethod, LogToLevelMethod logMethod, Ticker ticker, String message, Object ... args) {
            this.logActiveMethod = Objects.requireNonNull(logActiveMethod);
            this.logMethod = Objects.requireNonNull(logMethod);
            this.ticker = Objects.requireNonNull(ticker);
            this.message = Objects.requireNonNull(message);
            this.args = Objects.requireNonNull(args);
        }

        public void run(ThrowingEx.Runnable r) {
            try (Timed ignore = this.timed();){
                ThrowingEx.run(r);
            }
        }

        public <T> T call(ThrowingEx.Supplier<T> s) {
            try (Timed ignore = this.timed();){
                T t = ThrowingEx.get(s);
                return t;
            }
        }

        public void runChecked(ThrowingEx.Runnable r) throws Exception {
            try (Timed ignore = this.timed();){
                r.run();
            }
        }

        private Timed timed() {
            if (this.logActiveMethod.isLogLevelActive()) {
                return new Timed(this.ticker, this.message, List.of(this.args), this.logMethod);
            }
            return NullStopWatchLogger.INSTANCE;
        }
    }

    @FunctionalInterface
    private static interface LogActiveMethod {
        public boolean isLogLevelActive();
    }

    @FunctionalInterface
    private static interface LogToLevelMethod {
        public void log(String var1, Object ... var2);
    }

    static class TestTicker
    implements Ticker {
        private long time;

        TestTicker() {
        }

        @Override
        public long read() {
            return this.time;
        }

        public void tickMillis(long millis) {
            this.time += millis;
        }
    }

    public static final class NullStopWatchLogger
    extends Timed {
        private static final NullStopWatchLogger INSTANCE = new NullStopWatchLogger();

        private NullStopWatchLogger() {
            super(Ticker.systemTicker(), "", List.of(), (m, a) -> {});
        }
    }

    public static class Timed
    implements AutoCloseable {
        @Nonnull
        private final String msg;
        @Nonnull
        private final List<Object> params;
        @Nonnull
        private final LogToLevelMethod delegatedLogger;
        @Nonnull
        private final Ticker ticker;
        private final long startedAt;

        public Timed(@Nonnull Ticker ticker, @Nonnull String msg, @Nonnull List<Object> params, @Nonnull LogToLevelMethod delegatedLogger) {
            this.ticker = Objects.requireNonNull(ticker);
            this.msg = Objects.requireNonNull(msg);
            this.params = List.copyOf((Collection)Objects.requireNonNull(params));
            this.delegatedLogger = Objects.requireNonNull(delegatedLogger);
            this.startedAt = ticker.read();
            this.logStart();
        }

        private void logStart() {
            this.delegatedLogger.log(TimedLogger.MESSAGE_PREFIX_BEGIN + this.msg, this.params.toArray());
        }

        private void logEnd() {
            this.delegatedLogger.log(TimedLogger.MESSAGE_PREFIX_END + this.msg + TimedLogger.MESSAGE_SUFFIX_TOOK, this.paramsForEnd());
        }

        @Override
        public final void close() {
            this.logEnd();
        }

        private Object[] paramsForEnd() {
            if (this.params.isEmpty() || !(this.params.get(this.params.size() - 1) instanceof Throwable)) {
                return Stream.concat(this.params.stream(), Stream.of(LazyArgLogger.lazy(this::durationString))).toArray();
            }
            return Stream.concat(this.params.stream().limit(this.params.size() - 1), Stream.of(LazyArgLogger.lazy(this::durationString), this.params.get(this.params.size() - 1))).toArray();
        }

        private String durationString() {
            long minutes;
            long duration = this.ticker.read() - this.startedAt;
            if (duration < 1000L) {
                return duration + "ms";
            }
            if (duration < 60000L) {
                long seconds = duration / 1000L;
                long millis = duration - seconds * 1000L;
                return seconds + "." + millis + "s";
            }
            long seconds = (duration - (minutes = duration / 60000L) * 1000L * 60L) / 1000L;
            long millis = duration - minutes * 1000L * 60L - seconds * 1000L;
            return minutes + "m" + (String)(seconds + millis > 0L ? " " + seconds + "." + millis + "s" : "");
        }
    }
}

