/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

interface ExclusiveFolderAccess {
    public static ExclusiveFolderAccess forFolder(@Nonnull File folder) {
        return ExclusiveFolderAccess.forFolder(folder.getAbsolutePath());
    }

    public static ExclusiveFolderAccess forFolder(@Nonnull String path) {
        return new ExclusiveFolderAccessSharedMutex(Objects.requireNonNull(path));
    }

    public void runExclusively(ThrowingEx.Runnable var1);

    public static final class ExclusiveFolderAccessSharedMutex
    implements ExclusiveFolderAccess {
        private static final ConcurrentHashMap<String, Lock> MUTEXES = new ConcurrentHashMap();
        private final String path;

        private ExclusiveFolderAccessSharedMutex(@Nonnull String path) {
            this.path = Objects.requireNonNull(path);
        }

        private Lock getMutex() {
            return MUTEXES.computeIfAbsent(this.path, k -> new ReentrantLock());
        }

        @Override
        public void runExclusively(ThrowingEx.Runnable runnable) {
            Lock lock = this.getMutex();
            try {
                lock.lock();
                runnable.run();
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
            finally {
                lock.unlock();
            }
        }
    }
}

