/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.groovy;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterProperties;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Properties;

public class GrEclipseFormatterStep {
    private static final String NAME = "groovy-eclipse formatter";
    private static final String FORMATTER_CLASS = "com.diffplug.gradle.spotless.groovy.eclipse.GrEclipseFormatterStepImpl";
    private static final String DEFAULT_VERSION = "2.3.0";
    private static final String MAVEN_COORDINATE = "com.diffplug.spotless:spotless-ext-greclipse:";
    private static final String FORMATTER_METHOD = "format";

    public static FormatterStep create(Iterable<File> settingsFiles, Provisioner provisioner) {
        return GrEclipseFormatterStep.create(GrEclipseFormatterStep.defaultVersion(), settingsFiles, provisioner);
    }

    public static FormatterStep create(String version, Iterable<File> settingsFiles, Provisioner provisioner) {
        return FormatterStep.createLazy((String)NAME, () -> new State(JarState.from((String)(MAVEN_COORDINATE + version), (Provisioner)provisioner), settingsFiles), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final FileSignature settings;

        State(JarState jar, Iterable<File> settingsFiles) throws Exception {
            this.jarState = Objects.requireNonNull(jar);
            this.settings = FileSignature.signAsList(settingsFiles);
        }

        FormatterFunc createFormat() throws Exception {
            FormatterProperties preferences = FormatterProperties.from((Iterable)this.settings.files());
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterClazz = classLoader.loadClass(GrEclipseFormatterStep.FORMATTER_CLASS);
            Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(preferences.getProperties());
            Method method = formatterClazz.getMethod(GrEclipseFormatterStep.FORMATTER_METHOD, String.class);
            return input -> {
                try {
                    return (String)method.invoke(formatter, input);
                }
                catch (InvocationTargetException exceptionWrapper) {
                    Throwable throwable = exceptionWrapper.getTargetException();
                    Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                    throw null == exception ? exceptionWrapper : exception;
                }
            };
        }
    }
}

