-- 建表
create table diboot_column_ext
(
  id           serial        not null,
  table_name  VARCHAR(100)   not null,
  col_name    VARCHAR(100)   not null,
  ref_type    VARCHAR(10)    null,
  ref_relationship    VARCHAR(10)    null,
  ref_table   VARCHAR(100)   null,
  ref_column  VARCHAR(100)   null,
  as_column   VARCHAR(100)   null,
  object_bind   VARCHAR(255)   null,
  on_target_bind  BOOLEAN    null default FALSE,
  form_type   VARCHAR(50)    null default 'INPUT',
  extensions  VARCHAR(500)   null,
  is_deleted  BOOLEAN       not null default FALSE,
  create_time timestamp      not null default CURRENT_TIMESTAMP,
  update_time timestamp      null default CURRENT_TIMESTAMP,
  constraint PK_diboot_column_ext primary key (id)
);
-- 创建索引
CREATE INDEX idx_diboot_column_ext ON diboot_column_ext(table_name, col_name);

-- 创建面板记录表
CREATE TABLE diboot_custom_panel (
  id serial not null,
  panel_name VARCHAR(100) NOT NULL,
  panel_code VARCHAR(100) NOT NULL,
  project_type VARCHAR(100) NOT NULL,
  file_name VARCHAR(100) NOT NULL,
  dir_path VARCHAR(100)  NOT NULL DEFAULT '',
  param_data VARCHAR(4000),
  event_data VARCHAR(4000),
  methods_data VARCHAR(4000),
  config_data VARCHAR(4000),
  is_deleted  BOOLEAN       not null default FALSE,
  create_time timestamp      not null default CURRENT_TIMESTAMP,
  update_time timestamp      null default CURRENT_TIMESTAMP,
  constraint PK_diboot_custom_panel primary key (id)
);

-- 建表
CREATE TABLE diboot_table_ext
(
  id serial not null,
  table_name  VARCHAR(100)   not null,
  obj_name    VARCHAR(100)                          not null,
  id_type    VARCHAR(10)                           null,
  module    VARCHAR(100)                      null,
  class_name   VARCHAR(100)                          not null,
  extensions  VARCHAR(500)                          null,
  is_deleted  BOOLEAN       not null default FALSE,
  create_time timestamp      not null default CURRENT_TIMESTAMP,
  update_time timestamp      null default CURRENT_TIMESTAMP,
  constraint PK_diboot_table_ext primary key (id)
);
-- 创建索引
CREATE INDEX idx_diboot_table_ext ON diboot_table_ext(table_name);