-- 建表
create table ${SCHEMA}.diboot_column_ext
(
  id           number(20) generated as identity ( start with 10000 nocycle noorder),
  table_name  VARCHAR2(100)                          not null,
  col_name    VARCHAR2(100)                          not null,
  ref_type    VARCHAR2(10)                           null,
  ref_relationship  VARCHAR2(20)                     null,
  ref_table   VARCHAR2(100)                          null,
  ref_column  VARCHAR2(100)                          null,
  as_column   VARCHAR2(100)                          null,
  object_bind   VARCHAR2(255)                          null,
  on_target_bind     NUMBER(1)    default 0     null,
  form_type   VARCHAR2(50) default 'INPUT'          null,
  extensions  VARCHAR2(500)                          null,
  is_deleted     NUMBER(1)    default 0  not null,
  create_time TIMESTAMP            default CURRENT_TIMESTAMP  not null,
  update_time TIMESTAMP            default CURRENT_TIMESTAMP  null,
  constraint PK_diboot_column_ext primary key (id)
);

-- 创建索引
CREATE INDEX idx_diboot_column_ext ON ${SCHEMA}.diboot_column_ext(table_name, col_name);

-- 创建面板记录表
CREATE TABLE ${SCHEMA}.diboot_custom_panel (
   id number(20) generated as identity ( start with 10000 nocycle noorder),
   panel_name VARCHAR2(100) NOT NULL,
   panel_code VARCHAR2(100) NOT NULL,
   project_type VARCHAR2(100) NOT NULL,
   file_name VARCHAR2(100) NOT NULL,
   dir_path VARCHAR2(100)  DEFAULT '' NOT NULL,
   param_data VARCHAR2(4000),
   event_data VARCHAR2(4000),
   methods_data VARCHAR2(4000),
   config_data VARCHAR2(4000),
   is_deleted NUMBER(1)    default 0  not null,
   create_time TIMESTAMP            default CURRENT_TIMESTAMP  not null,
   update_time TIMESTAMP            default CURRENT_TIMESTAMP  null,
   constraint PK_diboot_custom_panel primary key (id)
);

-- 建表
create table diboot_table_ext
(
  id           number(20) generated as identity ( start with 10000 nocycle noorder),
  table_name  VARCHAR2(100)                          not null,
  obj_name    VARCHAR2(100)                          not null,
  id_type    VARCHAR2(10)                           null,
  module    VARCHAR2(100)                      null,
  class_name   VARCHAR2(100)                          not null,
  extensions  VARCHAR2(500)                          null,
  is_deleted     NUMBER(1)    default 0  not null,
  create_time timestamp   default CURRENT_TIMESTAMP not null,
  update_time timestamp   default CURRENT_TIMESTAMP null,
  constraint PK_diboot_table_ext primary key (id)
);
-- 创建索引
CREATE INDEX idx_diboot_table_ext ON diboot_table_ext(table_name);