-- 建表
create table diboot_column_ext
(
    `id` bigint(11) NOT NULL AUTO_INCREMENT,
    `table_name`  varchar(100)                          not null,
    `col_name`    varchar(100)                          not null,
    `ref_type`    varchar(10)                           null,
    `ref_relationship` varchar(20)                      null,
    `ref_table`   varchar(100)                          null,
    `ref_column`  varchar(100)                          null,
    `as_column`   varchar(100)                          null,
    `object_bind`   varchar(255)                        null,
    `on_target_bind`    tinyint(1)                      null,
    `form_type`   varchar(50) default 'INPUT'          null,
    `extensions`  varchar(500)                          null,
    `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
    `create_time` timestamp   default CURRENT_TIMESTAMP null,
    `update_time` timestamp   default CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
);
-- 创建索引
CREATE INDEX idx_diboot_column_ext ON diboot_column_ext(table_name, col_name);

-- 创建面板记录表
CREATE TABLE diboot_custom_panel (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `panel_name` varchar(255) NOT NULL,
  `panel_code` varchar(50) NOT NULL,
  `project_type` varchar(30) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `dir_path` varchar(255)  NOT NULL DEFAULT '',
  `param_data` LONGTEXT,
  `event_data` LONGTEXT,
  `methods_data` LONGTEXT,
  `config_data` LONGTEXT,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
);

-- 建表
create table diboot_table_ext
(
    `id` bigint(11) NOT NULL AUTO_INCREMENT,
    `table_name`  varchar(100)                          not null,
    `obj_name`    varchar(100)                          not null,
    `id_type`    varchar(10)                           null,
    `module`    varchar(100)                      null,
    `class_name`   varchar(100)                          null,
    `extensions`  varchar(500)                          null,
    `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
    `create_time` timestamp   default CURRENT_TIMESTAMP null,
    `update_time` timestamp   default CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
  );
  -- 创建索引
  CREATE INDEX idx_diboot_table_ext ON diboot_table_ext(table_name);
