-- 建表
create table diboot_column_ext
(
  id          BIGINT identity ( 10000,1) primary key,
  table_name  VARCHAR(200)                          not null,
  col_name    VARCHAR(200)                          not null,
  ref_type    VARCHAR(30)                           null,
  ref_relationship  VARCHAR(30)                     null,
  ref_table   VARCHAR(200)                          null,
  ref_column  VARCHAR(200)                          null,
  as_column   VARCHAR(200)                          null,
  object_bind   VARCHAR(300)                          null,
  on_target_bind     BIT    default 0     null,
  form_type   VARCHAR(100) default 'INPUT'          null,
  extensions  VARCHAR(600)                          null,
  is_deleted     BIT    default 0  not null,
  create_time TIMESTAMP            default CURRENT_TIMESTAMP  not null,
  update_time TIMESTAMP            default CURRENT_TIMESTAMP  null
);
-- 创建索引
CREATE INDEX idx_diboot_column_ext ON diboot_column_ext(table_name, col_name);

-- 创建面板记录表
CREATE TABLE diboot_custom_panel (
   id BIGINT identity ( 10000,1) primary key,
   panel_name VARCHAR(200) NOT NULL,
   panel_code VARCHAR(200) NOT NULL,
   project_type VARCHAR(200) NOT NULL,
   file_name VARCHAR(200) NOT NULL,
   dir_path VARCHAR(200)  DEFAULT '' NOT NULL,
   param_data TEXT,
   event_data TEXT,
   methods_data TEXT,
   config_data TEXT,
   is_deleted BIT    default 0  not null,
   create_time TIMESTAMP            default CURRENT_TIMESTAMP  not null,
   update_time TIMESTAMP            default CURRENT_TIMESTAMP  null
);

-- 建表
create table diboot_table_ext
(
  id          BIGINT identity ( 10000,1) primary key,
  table_name  VARCHAR(200)                          not null,
  obj_name    VARCHAR(200)                          not null,
  id_type    VARCHAR(20)                           null,
  module    VARCHAR(200)                      null,
  class_name   VARCHAR(200)                          not null,
  extensions  VARCHAR(900)                          null,
  is_deleted     BIT    default 0  not null,
  create_time timestamp   default CURRENT_TIMESTAMP not null,
  update_time timestamp   default CURRENT_TIMESTAMP null
);
-- 创建索引
CREATE INDEX idx_diboot_table_ext ON diboot_table_ext(table_name);
