/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.utils.StrUtils;
import java.util.Calendar;
import java.util.Date;

public class TimeUtils {
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final String ONE_SECOND_AGO = "\u79d2\u524d";
    private static final String ONE_MINUTE_AGO = "\u5206\u949f\u524d";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String ONE_DAY_AGO = "\u5929\u524d";
    private static final String ONE_MONTH_AGO = "\u6708\u524d";
    private static final String ONE_YEAR_AGO = "\u5e74\u524d";

    public static Date getTodayBegin() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(11, 0);
        currentDate.set(12, 0);
        currentDate.set(13, 0);
        return currentDate.getTime();
    }

    public static Date getTodayEnd() {
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(11, 23);
        currentDate.set(12, 59);
        currentDate.set(13, 59);
        return currentDate.getTime();
    }

    public static String formatOne(Date date) {
        return TimeUtils.format(date, "one");
    }

    public static String formatTwo(Date date) {
        return TimeUtils.format(date, "two");
    }

    public static String format(Date date, String line) {
        if (date == null) {
            return "\u672a\u77e5";
        }
        long curTime = System.currentTimeMillis() - date.getTime();
        if (curTime < 60000L) {
            long seconds = TimeUtils.toSeconds(curTime);
            return (seconds <= 0L ? 1L : seconds) + TimeUtils.getAgo(ONE_SECOND_AGO, line);
        }
        if (curTime < 2700000L) {
            long minutes = TimeUtils.toMinutes(curTime);
            return (minutes <= 0L ? 1L : minutes) + TimeUtils.getAgo(ONE_MINUTE_AGO, line);
        }
        if (curTime < 86400000L) {
            long hours = TimeUtils.toHours(curTime);
            return (hours <= 0L ? 1L : hours) + TimeUtils.getAgo(ONE_HOUR_AGO, line);
        }
        if (curTime < 172800000L) {
            return "\u6628\u5929";
        }
        if (curTime < 2592000000L) {
            long days = TimeUtils.toDays(curTime);
            return (days <= 0L ? 1L : days) + TimeUtils.getAgo(ONE_DAY_AGO, line);
        }
        if (curTime < 29030400000L) {
            long months = TimeUtils.toMonths(curTime);
            return (months <= 0L ? 1L : months) + TimeUtils.getAgo(ONE_MONTH_AGO, line);
        }
        long years = TimeUtils.toYears(curTime);
        return (years <= 0L ? 1L : years) + TimeUtils.getAgo(ONE_YEAR_AGO, line);
    }

    public static String getAgo(String ago, String line) {
        if (StrUtils.equals("one", line)) {
            return ago;
        }
        if (StrUtils.equals("two", line)) {
            return "<br>" + ago;
        }
        return null;
    }

    private static long toSeconds(long date) {
        return date / 1000L;
    }

    private static long toMinutes(long date) {
        return TimeUtils.toSeconds(date) / 60L;
    }

    private static long toHours(long date) {
        return TimeUtils.toMinutes(date) / 60L;
    }

    private static long toDays(long date) {
        return TimeUtils.toHours(date) / 24L;
    }

    private static long toMonths(long date) {
        return TimeUtils.toDays(date) / 30L;
    }

    private static long toYears(long date) {
        return TimeUtils.toMonths(date) / 365L;
    }
}

