/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.enums.IEnum;
import com.dexcoder.commons.exceptions.CommonsAssistantException;
import com.dexcoder.commons.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumUtils {
    public static IEnum[] getEnums(Class<?> clazz) {
        if (IEnum.class.isAssignableFrom(clazz)) {
            ?[] enumConstants = clazz.getEnumConstants();
            return (IEnum[])enumConstants;
        }
        return null;
    }

    public static IEnum[] getEnums(String enumClass) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(enumClass);
            return EnumUtils.getEnums(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new CommonsAssistantException("\u52a0\u8f7d\u679a\u4e3e\u7c7b\u5931\u8d25", (Throwable)e);
        }
    }

    public static <T> T getEnum(Class<T> clazz, String code) {
        IEnum[] enumConstants;
        if (!IEnum.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (IEnum enumConstant : enumConstants = (IEnum[])clazz.getEnumConstants()) {
            if (!enumConstant.getCode().equalsIgnoreCase(code)) continue;
            return (T)enumConstant;
        }
        return null;
    }

    public static <T> T getEnum(String clazzName, String code) {
        IEnum[] enumConstants;
        Class<?> clazz = ClassUtils.loadClass(clazzName);
        if (!IEnum.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (IEnum enumConstant : enumConstants = (IEnum[])clazz.getEnumConstants()) {
            if (!enumConstant.getCode().equalsIgnoreCase(code)) continue;
            return (T)enumConstant;
        }
        return null;
    }
}

