/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.utils;

import com.dexcoder.commons.exceptions.CommonsAssistantException;
import com.dexcoder.commons.utils.StrUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    private static final Map<Class<?>, BeanInfo> CLASS_CACHE = Collections.synchronizedMap(new WeakHashMap());

    public static BeanInfo getBeanInfo(Class<?> clazz, Class<?> stopClazz) {
        try {
            BeanInfo beanInfo;
            if (CLASS_CACHE.get(clazz) == null) {
                beanInfo = Introspector.getBeanInfo(clazz, stopClazz);
                CLASS_CACHE.put(clazz, beanInfo);
                Class<?> classToFlush = clazz;
                do {
                    Introspector.flushFromCaches(classToFlush);
                } while ((classToFlush = classToFlush.getSuperclass()) != null);
            } else {
                beanInfo = CLASS_CACHE.get(clazz);
            }
            return beanInfo;
        }
        catch (IntrospectionException e) {
            throw new CommonsAssistantException("\u83b7\u53d6BeanInfo\u5931\u8d25", (Throwable)e);
        }
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) {
        return ClassUtils.getBeanInfo(clazz, Object.class);
    }

    public static BeanInfo getSelfBeanInfo(Class<?> clazz) {
        return ClassUtils.getBeanInfo(clazz, clazz.getSuperclass());
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String name) {
        BeanInfo beanInfo = ClassUtils.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors == null) {
            return null;
        }
        for (PropertyDescriptor pd : propertyDescriptors) {
            if (!StrUtils.equals(pd.getName(), name)) continue;
            return pd;
        }
        return null;
    }

    public static Object getFieldValue(Class<?> clazz, Object obj, String fieldName) {
        PropertyDescriptor propertyDescriptor = ClassUtils.getPropertyDescriptor(clazz, fieldName);
        Method readMethod = propertyDescriptor.getReadMethod();
        return ClassUtils.invokeMethod(readMethod, obj);
    }

    public static Map<String, Object> getBeanPropMap(Object object) {
        BeanInfo beanInfo = ClassUtils.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors == null) {
            return null;
        }
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        for (PropertyDescriptor pd : propertyDescriptors) {
            Method readMethod = pd.getReadMethod();
            if (readMethod == null) continue;
            Object value = ClassUtils.invokeMethod(readMethod, object);
            propMap.put(pd.getName(), value);
        }
        return propMap;
    }

    public static void invokeMethod(Method method, Object bean, Object value) {
        try {
            ClassUtils.methodAccessible(method);
            method.invoke(bean, value);
        }
        catch (Exception e) {
            throw new CommonsAssistantException("\u6267\u884cinvokeMethod\u5931\u8d25:" + (method == null ? "null" : method.getName()), (Throwable)e);
        }
    }

    public static Object invokeMethod(Method method, Object bean) {
        try {
            ClassUtils.methodAccessible(method);
            return method.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new CommonsAssistantException("\u6267\u884cinvokeMethod\u5931\u8d25:" + (method == null ? "null" : method.getName()), (Throwable)e);
        }
    }

    public static void methodAccessible(Method method) {
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new CommonsAssistantException("\u6839\u636eclass\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25:" + (clazz == null ? "null" : clazz.getName()), (Throwable)e);
        }
    }

    public static Object newInstance(String clazz) {
        try {
            Class<?> loadClass = ClassUtils.getDefaultClassLoader().loadClass(clazz);
            return loadClass.newInstance();
        }
        catch (Exception e) {
            throw new CommonsAssistantException("\u6839\u636eclass\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25:" + clazz, (Throwable)e);
        }
    }

    public static Class<?> loadClass(String clazz) {
        try {
            Class<?> loadClass = ClassUtils.getDefaultClassLoader().loadClass(clazz);
            return loadClass;
        }
        catch (Exception e) {
            throw new CommonsAssistantException("\u6839\u636eclass\u540d\u79f0\u52a0\u8f7dclass\u5931\u8d25:" + clazz, (Throwable)e);
        }
    }

    public static Object toTargetTypeValue(Object value, Class<?> targetType) {
        String typeName = targetType.getName();
        if (StrUtils.equals(typeName, Boolean.TYPE.getName()) || StrUtils.equals(typeName, Boolean.class.getName())) {
            return Boolean.valueOf(value.toString());
        }
        if (StrUtils.equals(typeName, Integer.TYPE.getName()) || StrUtils.equals(typeName, Integer.class.getName())) {
            return Integer.valueOf(value.toString());
        }
        if (StrUtils.equals(typeName, Long.TYPE.getName()) || StrUtils.equals(typeName, Long.class.getName())) {
            return Long.valueOf(value.toString());
        }
        if (StrUtils.equals(typeName, Short.TYPE.getName()) || StrUtils.equals(typeName, Short.class.getName())) {
            return Short.valueOf(value.toString());
        }
        if (StrUtils.equals(typeName, Float.TYPE.getName()) || StrUtils.equals(typeName, Float.class.getName())) {
            return Float.valueOf(value.toString());
        }
        if (StrUtils.equals(typeName, Double.TYPE.getName()) || StrUtils.equals(typeName, Double.class.getName())) {
            return Double.valueOf(value.toString());
        }
        if (StrUtils.equals(typeName, Byte.TYPE.getName()) || StrUtils.equals(typeName, Byte.class.getName())) {
            return Byte.valueOf(value.toString());
        }
        return value;
    }

    public static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

