/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.office;

import com.dexcoder.commons.office.ExcelCell;
import com.dexcoder.commons.office.ExcelRow;
import com.dexcoder.commons.office.ExcelSheet;
import com.dexcoder.commons.office.ExcelStyleCreator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddressList;

public class DefaultExcelStyleCreator
implements ExcelStyleCreator {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String REGEX_NUMBER = "^\\d+(\\.\\d+)?$";

    public HSSFSheet createSheet(HSSFWorkbook workbook, ExcelSheet excelSheet) {
        HSSFSheet sheet = workbook.createSheet(excelSheet.getSheetName());
        sheet.setDefaultColumnWidth(15);
        return sheet;
    }

    public void createTitle(HSSFWorkbook workbook, HSSFSheet sheet, ExcelSheet excelSheet) {
        HSSFRow row = sheet.createRow(0);
        List<String> rowTitles = excelSheet.getRowTitles();
        for (int i = 0; i < rowTitles.size(); ++i) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(rowTitles.get(i));
            HSSFFont font = workbook.createFont();
            font.setBoldweight((short)700);
            text.applyFont((Font)font);
            cell.setCellValue((RichTextString)text);
        }
    }

    public void createRow(HSSFWorkbook workbook, HSSFSheet sheet, ExcelRow excelRow, int rowIndex) {
        HSSFRow row = sheet.createRow(rowIndex);
        if (excelRow == null || excelRow.getCells() == null) {
            return;
        }
        List<ExcelCell> cells = excelRow.getCells();
        for (int i = 0; i < cells.size(); ++i) {
            ExcelCell excelCell = cells.get(i);
            Object value = excelCell == null || excelCell.getValue() == null ? null : excelCell.getValue();
            this.createCell(workbook, sheet, row, value, rowIndex, i);
        }
    }

    public void createCell(HSSFWorkbook workbook, HSSFSheet sheet, HSSFRow row, Object value, int rowIndex, int cellIndex) {
        HSSFCell cell = row.createCell(cellIndex);
        if (value == null) {
            cell.setCellValue("");
        } else if (value instanceof Date) {
            this.createDateCellStyle(cell, value);
        } else if (value instanceof byte[]) {
            this.createPictureCellStyle(workbook, sheet, row, rowIndex, cellIndex, (byte[])value);
        } else if (value instanceof String[]) {
            this.createSelectCellStyle(sheet, cell, rowIndex, rowIndex, cellIndex, cellIndex, (String[])value);
        } else {
            this.createDefaultCellStyle(cell, value);
        }
    }

    public void createDateCellStyle(HSSFCell cell, Object value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String dateValue = dateFormat.format((Date)value);
        cell.setCellValue(dateValue);
    }

    public void createPictureCellStyle(HSSFWorkbook workbook, HSSFSheet sheet, HSSFRow row, int rowIndex, int cellIndex, byte[] value) {
        row.setHeightInPoints(60.0f);
        sheet.setColumnWidth(cellIndex, 2856);
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, (short)cellIndex, rowIndex, (short)cellIndex, rowIndex);
        anchor.setAnchorType(2);
        HSSFPatriarch patriarch = sheet.getDrawingPatriarch();
        patriarch.createPicture(anchor, workbook.addPicture(value, 5));
    }

    public void createSelectCellStyle(HSSFSheet sheet, HSSFCell cell, int firstRowIndex, int lastRowIndex, int firstCellIndex, int lastCellIndex, String[] cellValue) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRowIndex, lastRowIndex, firstCellIndex, lastCellIndex);
        DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])cellValue);
        HSSFDataValidation dataValidate = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        sheet.addValidationData((DataValidation)dataValidate);
        cell.setCellValue(cellValue[0]);
    }

    public void createDefaultCellStyle(HSSFCell cell, Object value) {
        String textValue = value.toString();
        boolean matcher = textValue.matches(REGEX_NUMBER);
        if (matcher && textValue.length() < 12) {
            cell.setCellValue(Double.parseDouble(textValue));
        } else {
            HSSFRichTextString richString = new HSSFRichTextString(textValue);
            cell.setCellValue((RichTextString)richString);
        }
    }
}

