/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.commons.bean;

import com.dexcoder.commons.bean.ContextClassLoaderLocal;
import com.dexcoder.commons.bean.TypeConverter;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanConverterConfig {
    private static final ContextClassLoaderLocal BEANS_BY_CLASSLOADER = new ContextClassLoaderLocal(){

        protected Object initialValue() {
            return new BeanConverterConfig();
        }
    };
    private SoftReference<Map<String, TypeConverter>> converters = new SoftReference(new HashMap());

    public static BeanConverterConfig getInstance() {
        BeanConverterConfig beanConverterConfig = (BeanConverterConfig)BEANS_BY_CLASSLOADER.get();
        return beanConverterConfig;
    }

    public static void setInstance(BeanConverterConfig newInstance) {
        BEANS_BY_CLASSLOADER.set(newInstance);
    }

    public static String getCovertKey(Class<?> sourceClass, Class<?> targetClass) {
        return sourceClass.getName() + "_" + targetClass.getName();
    }

    public void registerConverter(TypeConverter converter) {
        Map<String, TypeConverter> map = this.converters.get();
        if (map == null) {
            map = new HashMap<String, TypeConverter>();
            this.converters = new SoftReference<HashMap<String, TypeConverter>>((HashMap<String, TypeConverter>)map);
        }
        map.put(BeanConverterConfig.getCovertKey(converter.getSourceTypeClass(), converter.getTargetTypeClass()), converter);
    }

    public void unregisterConverter(Class<?> sourceClass, Class<?> targetClass) {
        Map<String, TypeConverter> map = this.converters.get();
        if (map == null) {
            return;
        }
        map.remove(BeanConverterConfig.getCovertKey(sourceClass, targetClass));
    }

    public Map<String, TypeConverter> getConverters() {
        return this.converters.get();
    }

    public void clearConverter() {
        this.converters.clear();
    }
}

