/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.Objects;

public class DaoCacheKey {
    private final CqlIdentifier keyspaceId;
    private final CqlIdentifier tableId;

    public DaoCacheKey(CqlIdentifier keyspaceId, CqlIdentifier tableId) {
        this.keyspaceId = keyspaceId;
        this.tableId = tableId;
    }

    public DaoCacheKey(CqlIdentifier keyspaceId, String tableName) {
        this(keyspaceId, DaoCacheKey.toId(tableName));
    }

    public DaoCacheKey(String keyspaceName, CqlIdentifier tableId) {
        this(DaoCacheKey.toId(keyspaceName), tableId);
    }

    public DaoCacheKey(String keyspaceName, String tableName) {
        this(DaoCacheKey.toId(keyspaceName), DaoCacheKey.toId(tableName));
    }

    private static CqlIdentifier toId(String name) {
        return name == null ? null : CqlIdentifier.fromCql((String)name);
    }

    public CqlIdentifier getKeyspaceId() {
        return this.keyspaceId;
    }

    public CqlIdentifier getTableId() {
        return this.tableId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DaoCacheKey) {
            DaoCacheKey that = (DaoCacheKey)other;
            return Objects.equals(this.keyspaceId, that.keyspaceId) && Objects.equals(this.tableId, that.tableId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspaceId, this.tableId);
    }
}

