/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.internal.core.util.concurrent.ReplayingEventFilter;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ReplayingEventFilterTest {
    private ReplayingEventFilter<Integer> filter;
    private List<Integer> filteredEvents;

    @Before
    public void setup() {
        this.filteredEvents = new ArrayList<Integer>();
        this.filter = new ReplayingEventFilter(this.filteredEvents::add);
    }

    @Test
    public void should_discard_events_until_started() {
        this.filter.accept((Object)1);
        this.filter.accept((Object)2);
        Assertions.assertThat(this.filteredEvents).isEmpty();
    }

    @Test
    public void should_accumulate_events_when_started() {
        this.filter.accept((Object)1);
        this.filter.accept((Object)2);
        this.filter.start();
        this.filter.accept((Object)3);
        this.filter.accept((Object)4);
        Assertions.assertThat((List)this.filter.recordedEvents()).containsExactly((Object[])new Integer[]{3, 4});
    }

    @Test
    public void should_flush_accumulated_events_when_ready() {
        this.filter.accept((Object)1);
        this.filter.accept((Object)2);
        this.filter.start();
        this.filter.accept((Object)3);
        this.filter.accept((Object)4);
        this.filter.markReady();
        Assertions.assertThat(this.filteredEvents).containsExactly((Object[])new Integer[]{3, 4});
        this.filter.accept((Object)5);
        this.filter.accept((Object)6);
        Assertions.assertThat(this.filteredEvents).containsExactly((Object[])new Integer[]{3, 4, 5, 6});
    }
}

