/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.util.concurrent.Debouncer;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class DebouncerTest {
    private static final Duration DEFAULT_WINDOW = Duration.ofSeconds(1L);
    private static final int DEFAULT_MAX_EVENTS = 10;
    @Mock
    private EventExecutor adminExecutor;
    @Mock
    private ScheduledFuture<?> scheduledFuture;
    private List<String> results;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.adminExecutor.inEventLoop()).thenReturn((Object)true);
        Mockito.when((Object)this.adminExecutor.schedule((Runnable)Mockito.any(Runnable.class), Mockito.eq((long)DEFAULT_WINDOW.toNanos()), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))))).thenAnswer(i -> this.scheduledFuture);
        this.results = new ArrayList<String>();
    }

    private String coalesce(List<Integer> events) {
        return Joiner.on((String)",").join(events);
    }

    private void flush(String result) {
        this.results.add(result);
    }

    @Test
    public void should_flush_synchronously_if_window_is_zero() {
        Debouncer debouncer = new Debouncer(this.adminExecutor, this::coalesce, this::flush, Duration.ZERO, 10L);
        debouncer.receive((Object)1);
        debouncer.receive((Object)2);
        ((EventExecutor)Mockito.verify((Object)this.adminExecutor, (VerificationMode)Mockito.never())).schedule((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)));
        Assertions.assertThat(this.results).containsExactly((Object[])new String[]{"1", "2"});
    }

    @Test
    public void should_flush_synchronously_if_max_events_is_one() {
        Debouncer debouncer = new Debouncer(this.adminExecutor, this::coalesce, this::flush, DEFAULT_WINDOW, 1L);
        debouncer.receive((Object)1);
        debouncer.receive((Object)2);
        ((EventExecutor)Mockito.verify((Object)this.adminExecutor, (VerificationMode)Mockito.never())).schedule((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)));
        Assertions.assertThat(this.results).containsExactly((Object[])new String[]{"1", "2"});
    }

    @Test
    public void should_debounce_after_time_window_if_no_other_event() {
        Debouncer debouncer = new Debouncer(this.adminExecutor, this::coalesce, this::flush, DEFAULT_WINDOW, 10L);
        debouncer.receive((Object)1);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Runnable.class);
        ((EventExecutor)Mockito.verify((Object)this.adminExecutor)).schedule((Runnable)captor.capture(), Mockito.eq((long)DEFAULT_WINDOW.toNanos()), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        ((Runnable)captor.getValue()).run();
        Assertions.assertThat(this.results).containsExactly((Object[])new String[]{"1"});
    }

    @Test
    public void should_reset_time_window_when_new_event() {
        Debouncer debouncer = new Debouncer(this.adminExecutor, this::coalesce, this::flush, DEFAULT_WINDOW, 10L);
        debouncer.receive((Object)1);
        debouncer.receive((Object)2);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.adminExecutor, this.scheduledFuture});
        ((EventExecutor)inOrder.verify((Object)this.adminExecutor)).schedule((Runnable)Mockito.any(Runnable.class), Mockito.eq((long)DEFAULT_WINDOW.toNanos()), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        ((ScheduledFuture)inOrder.verify(this.scheduledFuture)).cancel(true);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Runnable.class);
        ((EventExecutor)inOrder.verify((Object)this.adminExecutor)).schedule((Runnable)captor.capture(), Mockito.eq((long)DEFAULT_WINDOW.toNanos()), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        ((Runnable)captor.getValue()).run();
        Assertions.assertThat(this.results).containsExactly((Object[])new String[]{"1,2"});
    }

    @Test
    public void should_force_flush_after_max_events() {
        Debouncer debouncer = new Debouncer(this.adminExecutor, this::coalesce, this::flush, DEFAULT_WINDOW, 10L);
        for (int i = 0; i < 10; ++i) {
            debouncer.receive((Object)i);
        }
        ((EventExecutor)Mockito.verify((Object)this.adminExecutor, (VerificationMode)Mockito.times((int)9))).schedule((Runnable)Mockito.any(Runnable.class), Mockito.eq((long)DEFAULT_WINDOW.toNanos()), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        ((ScheduledFuture)Mockito.verify(this.scheduledFuture, (VerificationMode)Mockito.times((int)9))).cancel(true);
        Assertions.assertThat(this.results).containsExactly((Object[])new String[]{"0,1,2,3,4,5,6,7,8,9"});
    }

    @Test
    public void should_cancel_next_flush_when_stopped() {
        Debouncer debouncer = new Debouncer(this.adminExecutor, this::coalesce, this::flush, DEFAULT_WINDOW, 10L);
        debouncer.receive((Object)1);
        ((EventExecutor)Mockito.verify((Object)this.adminExecutor)).schedule((Runnable)Mockito.any(Runnable.class), Mockito.eq((long)DEFAULT_WINDOW.toNanos()), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        debouncer.stop();
        ((ScheduledFuture)Mockito.verify(this.scheduledFuture)).cancel(true);
    }

    @Test
    public void should_ignore_new_events_when_flushed() {
        Debouncer debouncer = new Debouncer(this.adminExecutor, this::coalesce, this::flush, DEFAULT_WINDOW, 10L);
        debouncer.stop();
        debouncer.receive((Object)1);
        ((EventExecutor)Mockito.verify((Object)this.adminExecutor, (VerificationMode)Mockito.never())).schedule((Runnable)Mockito.any(Runnable.class), Mockito.eq((long)DEFAULT_WINDOW.toNanos()), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
    }
}

