/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.json;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class JsonCodecTest
extends CodecTestBase<Set<InetAddress>> {
    private static final InetAddress V4_ADDRESS;
    private static final InetAddress V6_ADDRESS;
    private static final Set<InetAddress> SET_OF_ADDRESSES;

    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.json((GenericType)GenericType.setOf((GenericType)GenericType.INET_ADDRESS));
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(SET_OF_ADDRESSES)).isEqualTo(this.encodeJson("[\"127.0.0.1\",\"0:0:0:0:0:0:0:1\"]"));
        Assertions.assertThat((String)this.encode(Collections.emptySet())).isEqualTo(this.encodeJson("[]"));
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Iterable)((Iterable)this.decode(this.encodeJson("[\"127.0.0.1\",\"0:0:0:0:0:0:0:1\"]")))).isEqualTo(SET_OF_ADDRESSES);
        Assertions.assertThat((Iterable)((Iterable)this.decode(this.encodeJson("[]")))).isEqualTo(Collections.emptySet());
        Assertions.assertThat((Iterable)((Iterable)this.decode(null))).isNull();
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(SET_OF_ADDRESSES)).isEqualTo("'[\"127.0.0.1\",\"0:0:0:0:0:0:0:1\"]'");
        Assertions.assertThat((String)this.format(Collections.emptySet())).isEqualTo("'[]'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Iterable)((Iterable)this.parse("'[\"127.0.0.1\",\"0:0:0:0:0:0:0:1\"]'"))).isEqualTo(SET_OF_ADDRESSES);
        Assertions.assertThat((Iterable)((Iterable)this.parse("'[]'"))).isEqualTo(Collections.emptySet());
        Assertions.assertThat((Iterable)((Iterable)this.parse("NULL"))).isNull();
        Assertions.assertThat((Iterable)((Iterable)this.parse("null"))).isNull();
        Assertions.assertThat((Iterable)((Iterable)this.parse(""))).isNull();
        Assertions.assertThat((Iterable)((Iterable)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a JSON string");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.setOf((GenericType)GenericType.INET_ADDRESS))).isTrue();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Set.class)).isTrue();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts(SET_OF_ADDRESSES)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Collections.emptySet())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Collections.singletonList(V4_ADDRESS))).isFalse();
    }

    private String encodeJson(String json) {
        return Bytes.toHexString((ByteBuffer)TypeCodecs.TEXT.encode((Object)json, ProtocolVersion.DEFAULT));
    }

    static {
        try {
            V4_ADDRESS = InetAddress.getByName("127.0.0.1");
            V6_ADDRESS = InetAddress.getByName("::1");
            SET_OF_ADDRESSES = ImmutableSet.of((Object)V4_ADDRESS, (Object)V6_ADDRESS);
        }
        catch (UnknownHostException e) {
            Assertions.fail((String)"unexpected error", (Throwable)e);
            throw new AssertionError();
        }
    }
}

