/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ShortArrayCodecTest
extends CodecTestBase<short[]> {
    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.SHORT_LIST_TO_ARRAY;
    }

    @Test
    public void should_encode_null() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_empty_array() {
        Assertions.assertThat((String)this.encode(new short[0])).isEqualTo("0x00000000");
    }

    @Test
    public void should_encode_non_empty_array() {
        Assertions.assertThat((String)this.encode(new short[]{1, 2, 3})).isEqualTo("0x00000003000000020001000000020002000000020003");
    }

    @Test
    public void should_decode_null_as_empty_array() {
        Assertions.assertThat((short[])((short[])this.decode(null))).isEmpty();
    }

    @Test
    public void should_decode_empty_array() {
        Assertions.assertThat((short[])((short[])this.decode("0x00000000"))).isEmpty();
    }

    @Test
    public void should_decode_non_empty_array() {
        Assertions.assertThat((short[])((short[])this.decode("0x00000003000000020001000000020002000000020003"))).containsExactly(new short[]{1, 2, 3});
    }

    @Test(expected=NullPointerException.class)
    public void should_not_decode_array_with_null_elements() {
        this.decode("0x00000001FFFFFFFF");
    }

    @Test
    public void should_format_null_array() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_empty_array() {
        Assertions.assertThat((String)this.format(new short[0])).isEqualTo("[]");
    }

    @Test
    public void should_format_non_empty_array() {
        Assertions.assertThat((String)this.format(new short[]{1, 2, 3})).isEqualTo("[1,2,3]");
    }

    @Test
    public void should_parse_null_or_empty_string() {
        Assertions.assertThat((short[])((short[])this.parse(null))).isNull();
        Assertions.assertThat((short[])((short[])this.parse(""))).isNull();
    }

    @Test
    public void should_parse_empty_array() {
        Assertions.assertThat((short[])((short[])this.parse("[]"))).isEmpty();
    }

    @Test
    public void should_parse_non_empty_array() {
        Assertions.assertThat((short[])((short[])this.parse("[1,2,3]"))).containsExactly(new short[]{1, 2, 3});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_malformed_array() {
        this.parse("not an array");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Short.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Short.class))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Short.TYPE).getRawType())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Short.class).getRawType())).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class).getRawType())).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)new short[]{1, 2, 3})).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new Short[]{(short)1, (short)2, (short)3})).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new String[]{"hello", "world"})).isFalse();
    }
}

