/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.protocol.internal.util.Bytes;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ObjectArrayCodecTest
extends CodecTestBase<String[]> {
    @Mock
    private TypeCodec<String> elementCodec;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.elementCodec.getCqlType()).thenReturn((Object)DataTypes.TEXT);
        Mockito.when((Object)this.elementCodec.getJavaType()).thenReturn((Object)GenericType.STRING);
        this.codec = ExtraTypeCodecs.listToArrayOf(this.elementCodec);
    }

    @Test
    public void should_encode_null() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_empty_array() {
        Assertions.assertThat((String)this.encode(new String[0])).isEqualTo("0x00000000");
    }

    @Test
    public void should_encode_non_empty_array() {
        Mockito.when((Object)this.elementCodec.encode((Object)"hello", ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x68656c6c6f"));
        Mockito.when((Object)this.elementCodec.encode((Object)"world", ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x776f726c64"));
        Assertions.assertThat((String)this.encode(new String[]{"hello", "world"})).isEqualTo("0x000000020000000568656c6c6f00000005776f726c64");
    }

    @Test
    public void should_decode_null_as_empty_array() {
        Assertions.assertThat((Object[])((String[])this.decode(null))).isEmpty();
    }

    @Test
    public void should_decode_empty_array() {
        Assertions.assertThat((Object[])((String[])this.decode("0x00000000"))).isEmpty();
    }

    @Test
    public void should_decode_non_empty_array() {
        Mockito.when((Object)((String)this.elementCodec.decode(Bytes.fromHexString((String)"0x68656c6c6f"), ProtocolVersion.DEFAULT))).thenReturn((Object)"hello");
        Mockito.when((Object)((String)this.elementCodec.decode(Bytes.fromHexString((String)"0x776f726c64"), ProtocolVersion.DEFAULT))).thenReturn((Object)"world");
        Assertions.assertThat((Object[])((String[])this.decode("0x000000020000000568656c6c6f00000005776f726c64"))).containsExactly((Object[])new String[]{"hello", "world"});
    }

    @Test
    public void should_decode_array_with_null_elements() {
        Mockito.when((Object)((String)this.elementCodec.decode(Bytes.fromHexString((String)"0x68656c6c6f"), ProtocolVersion.DEFAULT))).thenReturn((Object)"hello");
        Assertions.assertThat((Object[])((String[])this.decode("0x00000002FFFFFFFF0000000568656c6c6f"))).containsExactly((Object[])new String[]{null, "hello"});
    }

    @Test
    public void should_format_null_array() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_empty_array() {
        Assertions.assertThat((String)this.format(new String[0])).isEqualTo("[]");
    }

    @Test
    public void should_format_non_empty_array() {
        Mockito.when((Object)this.elementCodec.format((Object)"hello")).thenReturn((Object)"'hello'");
        Mockito.when((Object)this.elementCodec.format((Object)"world")).thenReturn((Object)"'world'");
        Assertions.assertThat((String)this.format(new String[]{"hello", "world"})).isEqualTo("['hello','world']");
    }

    @Test
    public void should_parse_null_or_empty_string() {
        Assertions.assertThat((Object[])((String[])this.parse(null))).isNull();
        Assertions.assertThat((Object[])((String[])this.parse(""))).isNull();
    }

    @Test
    public void should_parse_empty_array() {
        Assertions.assertThat((Object[])((String[])this.parse("[]"))).isEmpty();
    }

    @Test
    public void should_parse_non_empty_array() {
        Mockito.when((Object)((String)this.elementCodec.parse("'hello'"))).thenReturn((Object)"hello");
        Mockito.when((Object)((String)this.elementCodec.parse("'world'"))).thenReturn((Object)"world");
        Assertions.assertThat((Object[])((String[])this.parse("['hello','world']"))).containsExactly((Object[])new String[]{"hello", "world"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_malformed_array() {
        this.parse("not an array");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class).getRawType())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Integer.class).getRawType())).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)new String[]{"hello", "world"})).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new Integer[]{1, 2, 3})).isFalse();
    }
}

