/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ByteArrayCodecTest
extends CodecTestBase<byte[]> {
    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.BYTE_LIST_TO_ARRAY;
    }

    @Test
    public void should_encode_null() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_empty_array() {
        Assertions.assertThat((String)this.encode(new byte[0])).isEqualTo("0x00000000");
    }

    @Test
    public void should_encode_non_empty_array() {
        Assertions.assertThat((String)this.encode(new byte[]{1, 2, 3})).isEqualTo("0x00000003000000010100000001020000000103");
    }

    @Test
    public void should_decode_null_as_empty_array() {
        Assertions.assertThat((byte[])((byte[])this.decode(null))).isEmpty();
    }

    @Test
    public void should_decode_empty_array() {
        Assertions.assertThat((byte[])((byte[])this.decode("0x00000000"))).isEmpty();
    }

    @Test
    public void should_decode_non_empty_array() {
        Assertions.assertThat((byte[])((byte[])this.decode("0x00000003000000010100000001020000000103"))).containsExactly(new byte[]{1, 2, 3});
    }

    @Test(expected=NullPointerException.class)
    public void should_not_decode_array_with_null_elements() {
        this.decode("0x00000001FFFFFFFF");
    }

    @Test
    public void should_format_null_array() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_empty_array() {
        Assertions.assertThat((String)this.format(new byte[0])).isEqualTo("[]");
    }

    @Test
    public void should_format_non_empty_array() {
        Assertions.assertThat((String)this.format(new byte[]{1, 2, 3})).isEqualTo("[1,2,3]");
    }

    @Test
    public void should_parse_null_or_empty_string() {
        Assertions.assertThat((byte[])((byte[])this.parse(null))).isNull();
        Assertions.assertThat((byte[])((byte[])this.parse(""))).isNull();
    }

    @Test
    public void should_parse_empty_array() {
        Assertions.assertThat((byte[])((byte[])this.parse("[]"))).isEmpty();
    }

    @Test
    public void should_parse_non_empty_array() {
        Assertions.assertThat((byte[])((byte[])this.parse("[1,2,3]"))).containsExactly(new byte[]{1, 2, 3});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_malformed_array() {
        this.parse("not an array");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Byte.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Byte.class))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Byte.TYPE).getRawType())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Byte.class).getRawType())).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class).getRawType())).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)new byte[]{1, 2, 3})).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new Byte[]{(byte)1, (byte)2, (byte)3})).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new String[]{"hello", "world"})).isFalse();
    }
}

