/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.Before;
import org.junit.Test;

public class OptionalCodecTest
extends CodecTestBase<Optional<Integer>> {
    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.optionalOf((TypeCodec)TypeCodecs.INT);
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(Optional.of(1))).isEqualTo("0x00000001");
        Assertions.assertThat((String)this.encode(Optional.empty())).isNull();
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        ((OptionalAssert)Assertions.assertThat((Optional)((Optional)this.decode("0x00000001"))).isPresent()).contains((Object)1);
        Assertions.assertThat((Optional)((Optional)this.decode("0x"))).isEmpty();
        Assertions.assertThat((Optional)((Optional)this.decode(null))).isEmpty();
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(Optional.of(1))).isEqualTo("1");
        Assertions.assertThat((String)this.format(Optional.empty())).isEqualTo("NULL");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        ((OptionalAssert)Assertions.assertThat((Optional)((Optional)this.parse("1"))).isPresent()).contains((Object)1);
        Assertions.assertThat((Optional)((Optional)this.parse("NULL"))).isEmpty();
        Assertions.assertThat((Optional)((Optional)this.parse("null"))).isEmpty();
        Assertions.assertThat((Optional)((Optional)this.parse(""))).isEmpty();
        Assertions.assertThat((Optional)((Optional)this.parse(null))).isEmpty();
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.optionalOf(Integer.class))).isTrue();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Optional.class)).isTrue();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts(Optional.of(1))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Optional.empty())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Optional.of("foo"))).isFalse();
    }
}

