/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TinyIntCodecTest
extends CodecTestBase<Byte> {
    public TinyIntCodecTest() {
        this.codec = TypeCodecs.TINYINT;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode((byte)0)).isEqualTo("0x00");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Byte)((Byte)this.decode("0x00"))).isEqualTo((byte)0);
        Assertions.assertThat((Byte)((Byte)this.decode("0x"))).isNull();
        Assertions.assertThat((Byte)((Byte)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x0000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format((byte)0)).isEqualTo("0");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Byte)((Byte)this.parse("0"))).isEqualTo((byte)0);
        Assertions.assertThat((Byte)((Byte)this.parse("NULL"))).isNull();
        Assertions.assertThat((Byte)((Byte)this.parse("null"))).isNull();
        Assertions.assertThat((Byte)((Byte)this.parse(""))).isNull();
        Assertions.assertThat((Byte)((Byte)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a tinyint");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Byte.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Byte.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Byte.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Byte.TYPE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)123)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)-128)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

