/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodec;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class TimestampCodecTest
extends CodecTestBase<Instant> {
    public TimestampCodecTest() {
        this.codec = new TimestampCodec((ZoneId)ZoneOffset.UTC);
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(Instant.EPOCH)).isEqualTo("0x0000000000000000");
        Assertions.assertThat((String)this.encode(Instant.ofEpochMilli(128L))).isEqualTo("0x0000000000000080");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((long)((Instant)this.decode("0x0000000000000000")).toEpochMilli()).isEqualTo(0L);
        Assertions.assertThat((long)((Instant)this.decode("0x0000000000000080")).toEpochMilli()).isEqualTo(128L);
        Assertions.assertThat((Instant)((Instant)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x00000000000000000000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(Instant.EPOCH)).isEqualTo("'1970-01-01T00:00:00.000Z'");
        Assertions.assertThat((String)this.format(Instant.parse("2018-08-16T15:59:34.123Z"))).isEqualTo("'2018-08-16T15:59:34.123Z'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @DataProvider
    public static Iterable<ZoneId> timeZones() {
        return Lists.newArrayList((Object[])new ZoneId[]{ZoneId.systemDefault(), ZoneOffset.UTC, ZoneOffset.ofHoursMinutes(3, 30), ZoneId.of("Europe/Paris"), ZoneId.of("GMT+7")});
    }

    @Test
    @UseDataProvider(value="timeZones")
    public void should_parse(ZoneId defaultTimeZone) {
        TimestampCodec codec = new TimestampCodec(defaultTimeZone);
        Assertions.assertThat((Instant)codec.parse("'0'")).isEqualTo((Object)Instant.EPOCH);
        Assertions.assertThat((Instant)codec.parse("'-1'")).isEqualTo((Object)Instant.EPOCH.minusMillis(1L));
        Assertions.assertThat((Instant)codec.parse("1534463100000")).isEqualTo((Object)Instant.ofEpochMilli(1534463100000L));
        Instant expected = LocalDate.parse("2017-01-01").atStartOfDay().atZone(defaultTimeZone).toInstant();
        Assertions.assertThat((Instant)codec.parse("'2017-01-01'")).isEqualTo((Object)expected);
        expected = LocalDate.parse("2018-08-16").atStartOfDay().atZone(ZoneOffset.ofHours(2)).toInstant();
        Assertions.assertThat((Instant)codec.parse("'2018-08-16+02'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'2018-08-16+0200'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'2018-08-16+02:00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'2018-08-16 CEST'")).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("2018-08-16T23:45").atZone(defaultTimeZone).toInstant();
        Assertions.assertThat((Instant)codec.parse("'2018-08-16T23:45'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'2018-08-16 23:45'")).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("2019-12-31T16:08:38").atZone(defaultTimeZone).toInstant();
        Assertions.assertThat((Instant)codec.parse("'2019-12-31T16:08:38'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'2019-12-31 16:08:38'")).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("1950-02-28T12:00:59.230").atZone(defaultTimeZone).toInstant();
        Assertions.assertThat((Instant)codec.parse("'1950-02-28T12:00:59.230'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1950-02-28 12:00:59.230'")).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1973-06-23T23:59:00.000+01:00").toInstant();
        Assertions.assertThat((Instant)codec.parse("'1973-06-23T23:59+01'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1973-06-23T23:59+0100'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1973-06-23T23:59+01:00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1973-06-23T23:59 CET'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1973-06-23 23:59+01'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1973-06-23 23:59+0100'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1973-06-23 23:59+01:00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1973-06-23 23:59 CET'")).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1980-01-01T23:59:59.000-08:00").toInstant();
        Assertions.assertThat((Instant)codec.parse("'1980-01-01T23:59:59-08'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1980-01-01T23:59:59-0800'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1980-01-01T23:59:59-08:00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1980-01-01T23:59:59 PST'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1980-01-01 23:59:59-08'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1980-01-01 23:59:59-0800'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1980-01-01 23:59:59-08:00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1980-01-01 23:59:59 PST'")).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1999-12-31T23:59:59.999+00:00").toInstant();
        Assertions.assertThat((Instant)codec.parse("'1999-12-31T23:59:59.999+00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1999-12-31T23:59:59.999+0000'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1999-12-31T23:59:59.999+00:00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1999-12-31T23:59:59.999 UTC'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1999-12-31 23:59:59.999+00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1999-12-31 23:59:59.999+0000'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1999-12-31 23:59:59.999+00:00'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("'1999-12-31 23:59:59.999 UTC'")).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)codec.parse("NULL")).isNull();
        Assertions.assertThat((Instant)codec.parse("null")).isNull();
        Assertions.assertThat((Instant)codec.parse("")).isNull();
        Assertions.assertThat((Instant)codec.parse(null)).isNull();
    }

    @Test
    public void should_fail_to_parse_invalid_input() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Instant cfr_ignored_0 = (Instant)this.parse("not a timestamp");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Alphanumeric timestamp literal must be quoted: \"not a timestamp\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Instant cfr_ignored_0 = (Instant)this.parse("'not a timestamp'");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse timestamp value from \"'not a timestamp'\"");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Instant.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Instant.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)Instant.EPOCH)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

