/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TimeCodecTest
extends CodecTestBase<LocalTime> {
    public TimeCodecTest() {
        this.codec = TypeCodecs.TIME;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(LocalTime.MIDNIGHT)).isEqualTo("0x0000000000000000");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((LocalTime)((LocalTime)this.decode("0x0000000000000000"))).isEqualTo((Object)LocalTime.MIDNIGHT);
        Assertions.assertThat((LocalTime)((LocalTime)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x00000000000000000000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(LocalTime.MIDNIGHT)).isEqualTo("'00:00:00.000000000'");
        Assertions.assertThat((String)this.format(LocalTime.NOON.plus(13799999994L, ChronoUnit.NANOS))).isEqualTo("'12:00:13.799999994'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((LocalTime)((LocalTime)this.parse("'0'"))).isEqualTo((Object)LocalTime.MIDNIGHT);
        Assertions.assertThat((LocalTime)((LocalTime)this.parse("'00:00'"))).isEqualTo((Object)LocalTime.MIDNIGHT);
        Assertions.assertThat((LocalTime)((LocalTime)this.parse("NULL"))).isNull();
        Assertions.assertThat((LocalTime)((LocalTime)this.parse("null"))).isNull();
        Assertions.assertThat((LocalTime)((LocalTime)this.parse(""))).isNull();
        Assertions.assertThat((LocalTime)((LocalTime)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a time");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(LocalTime.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(LocalTime.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)LocalTime.MIDNIGHT)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

