/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TextCodecTest
extends CodecTestBase<String> {
    public TextCodecTest() {
        this.codec = TypeCodecs.TEXT;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode("hello")).isEqualTo("0x68656c6c6f");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((String)((String)this.decode("0x68656c6c6f"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)this.decode("0x"))).isEmpty();
        Assertions.assertThat((String)((String)this.decode(null))).isNull();
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format("hello")).isEqualTo("'hello'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((String)((String)this.parse("'hello'"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)this.parse("NULL"))).isNull();
        Assertions.assertThat((String)((String)this.parse("null"))).isNull();
        Assertions.assertThat((String)((String)this.parse(""))).isNull();
        Assertions.assertThat((String)((String)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a string");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(String.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(String.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)"hello")).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

