/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SimpleBlobCodecTest
extends CodecTestBase<byte[]> {
    private static final ByteBuffer BUFFER = Bytes.fromHexString((String)"0xcafebabe");
    private static final byte[] ARRAY = Bytes.getArray((ByteBuffer)Bytes.fromHexString((String)"0xcafebabe"));

    public SimpleBlobCodecTest() {
        this.codec = ExtraTypeCodecs.BLOB_TO_ARRAY;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(ARRAY)).isEqualTo("0xcafebabe");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_not_share_position_between_input_and_encoded() {
        ByteBuffer encoded = this.codec.encode((Object)ARRAY, ProtocolVersion.DEFAULT);
        Assertions.assertThat((Comparable)encoded).isNotNull();
        Assertions.assertThat((byte[])ARRAY).isEqualTo((Object)Bytes.getArray((ByteBuffer)encoded));
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((byte[])((byte[])this.decode("0xcafebabe"))).isEqualTo((Object)ARRAY);
        Assertions.assertThat((byte[])((byte[])this.decode("0x"))).hasSize(0);
        Assertions.assertThat((byte[])((byte[])this.decode(null))).isNull();
    }

    @Test
    public void should_not_share_position_between_decoded_and_input() {
        byte[] decoded = (byte[])this.codec.decode(BUFFER, ProtocolVersion.DEFAULT);
        Assertions.assertThat((byte[])decoded).isEqualTo((Object)ARRAY);
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(ARRAY)).isEqualTo("0xcafebabe");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((byte[])((byte[])this.parse("0xcafebabe"))).isEqualTo((Object)ARRAY);
        Assertions.assertThat((byte[])((byte[])this.parse("NULL"))).isNull();
        Assertions.assertThat((byte[])((byte[])this.parse("null"))).isNull();
        Assertions.assertThat((byte[])((byte[])this.parse(""))).isNull();
        Assertions.assertThat((byte[])((byte[])this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a blob");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(byte[].class))).isTrue();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(byte[].class)).isTrue();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)ARRAY)).isTrue();
    }
}

