/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.internal.core.type.codec.CqlIntToStringCodec;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class MappingCodecTest
extends CodecTestBase<String> {
    public MappingCodecTest() {
        this.codec = new CqlIntToStringCodec();
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode("0")).isEqualTo("0x00000000");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((String)((String)this.decode("0x00000000"))).isEqualTo("0");
        Assertions.assertThat((String)((String)this.decode("0x"))).isNull();
        Assertions.assertThat((String)((String)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x0000000000000000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format("0")).isEqualTo("0");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((String)((String)this.parse("0"))).isEqualTo("0");
        Assertions.assertThat((String)((String)this.parse("NULL"))).isNull();
        Assertions.assertThat((String)((String)this.parse("null"))).isNull();
        Assertions.assertThat((String)((String)this.parse(""))).isNull();
        Assertions.assertThat((String)((String)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not an int");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(String.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.TYPE))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(String.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.TYPE)).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)"123")).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)"not an int")).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }

    @Test
    public void should_expose_inner_and_outer_java_types() {
        Assertions.assertThat((Object)((MappingCodec)this.codec).getInnerJavaType()).isEqualTo((Object)GenericType.INTEGER);
        Assertions.assertThat((Object)this.codec.getJavaType()).isEqualTo((Object)GenericType.STRING);
    }
}

