/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ListCodecTest
extends CodecTestBase<List<Integer>> {
    @Mock
    private TypeCodec<Integer> elementCodec;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.elementCodec.getCqlType()).thenReturn((Object)DataTypes.INT);
        Mockito.when((Object)this.elementCodec.getJavaType()).thenReturn((Object)GenericType.INTEGER);
        this.codec = TypeCodecs.listOf(this.elementCodec);
    }

    @Test
    public void should_encode_null() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_empty_list() {
        Assertions.assertThat((String)this.encode(new ArrayList())).isEqualTo("0x00000000");
    }

    @Test
    public void should_encode_non_empty_list() {
        Mockito.when((Object)this.elementCodec.encode((Object)1, ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x01"));
        Mockito.when((Object)this.elementCodec.encode((Object)2, ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x0002"));
        Mockito.when((Object)this.elementCodec.encode((Object)3, ProtocolVersion.DEFAULT)).thenReturn((Object)Bytes.fromHexString((String)"0x000003"));
        Assertions.assertThat((String)this.encode(ImmutableList.of((Object)1, (Object)2, (Object)3))).isEqualTo("0x00000003000000010100000002000200000003000003");
    }

    @Test
    public void should_decode_null_as_empty_list() {
        Assertions.assertThat((List)((List)this.decode(null))).isEmpty();
    }

    @Test
    public void should_decode_empty_list() {
        Assertions.assertThat((List)((List)this.decode("0x00000000"))).isEmpty();
    }

    @Test
    public void should_decode_non_empty_list() {
        Mockito.when((Object)((Integer)this.elementCodec.decode(Bytes.fromHexString((String)"0x01"), ProtocolVersion.DEFAULT))).thenReturn((Object)1);
        Mockito.when((Object)((Integer)this.elementCodec.decode(Bytes.fromHexString((String)"0x0002"), ProtocolVersion.DEFAULT))).thenReturn((Object)2);
        Mockito.when((Object)((Integer)this.elementCodec.decode(Bytes.fromHexString((String)"0x000003"), ProtocolVersion.DEFAULT))).thenReturn((Object)3);
        Assertions.assertThat((List)((List)this.decode("0x00000003000000010100000002000200000003000003"))).containsExactly((Object[])new Integer[]{1, 2, 3});
    }

    @Test
    public void should_decode_list_with_null_elements() {
        Mockito.when((Object)((Integer)this.elementCodec.decode(Bytes.fromHexString((String)"0x0002"), ProtocolVersion.DEFAULT))).thenReturn((Object)2);
        Assertions.assertThat((List)((List)this.decode("0x00000002FFFFFFFF000000020002"))).containsExactly((Object[])new Integer[]{null, 2});
    }

    @Test
    public void should_format_null_list() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_empty_list() {
        Assertions.assertThat((String)this.format(new ArrayList())).isEqualTo("[]");
    }

    @Test
    public void should_format_non_empty_list() {
        Mockito.when((Object)this.elementCodec.format((Object)1)).thenReturn((Object)"a");
        Mockito.when((Object)this.elementCodec.format((Object)2)).thenReturn((Object)"b");
        Mockito.when((Object)this.elementCodec.format((Object)3)).thenReturn((Object)"c");
        Assertions.assertThat((String)this.format(ImmutableList.of((Object)1, (Object)2, (Object)3))).isEqualTo("[a,b,c]");
    }

    @Test
    public void should_parse_null_or_empty_string() {
        Assertions.assertThat((List)((List)this.parse(null))).isNull();
        Assertions.assertThat((List)((List)this.parse(""))).isNull();
    }

    @Test
    public void should_parse_empty_list() {
        Assertions.assertThat((List)((List)this.parse("[]"))).isEmpty();
    }

    @Test
    public void should_parse_non_empty_list() {
        Mockito.when((Object)((Integer)this.elementCodec.parse("a"))).thenReturn((Object)1);
        Mockito.when((Object)((Integer)this.elementCodec.parse("b"))).thenReturn((Object)2);
        Mockito.when((Object)((Integer)this.elementCodec.parse("c"))).thenReturn((Object)3);
        Assertions.assertThat((List)((List)this.parse("[a,b,c]"))).containsExactly((Object[])new Integer[]{1, 2, 3});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_malformed_list() {
        this.parse("not a list");
    }
}

