/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DoubleCodecTest
extends CodecTestBase<Double> {
    public DoubleCodecTest() {
        this.codec = TypeCodecs.DOUBLE;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(0.0)).isEqualTo("0x0000000000000000");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Double)((Double)this.decode("0x0000000000000000"))).isEqualTo(0.0);
        Assertions.assertThat((Double)((Double)this.decode("0x"))).isNull();
        Assertions.assertThat((Double)((Double)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x0000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(0.0)).isEqualTo("0.0");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Double)((Double)this.parse("0.0"))).isEqualTo(0.0);
        Assertions.assertThat((Double)((Double)this.parse("NULL"))).isNull();
        Assertions.assertThat((Double)((Double)this.parse("null"))).isNull();
        Assertions.assertThat((Double)((Double)this.parse(""))).isNull();
        Assertions.assertThat((Double)((Double)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a double");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Double.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Double.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(Double.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Double.TYPE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)123.45)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Double.MIN_VALUE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

