/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.SerializationHelper;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DataTypeSerializationTest {
    @Test
    public void should_serialize_and_deserialize() {
        TupleType tuple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT});
        UserDefinedType udt = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), DataTypes.TEXT).build();
        this.should_serialize_and_deserialize(DataTypes.INT, false);
        this.should_serialize_and_deserialize(DataTypes.custom((String)"some.class.name"), false);
        this.should_serialize_and_deserialize((DataType)tuple, true);
        this.should_serialize_and_deserialize((DataType)udt, true);
        this.should_serialize_and_deserialize((DataType)DataTypes.listOf((DataType)DataTypes.INT), false);
        this.should_serialize_and_deserialize((DataType)DataTypes.listOf((DataType)tuple), true);
        this.should_serialize_and_deserialize((DataType)DataTypes.setOf((DataType)udt), true);
        this.should_serialize_and_deserialize((DataType)DataTypes.mapOf((DataType)tuple, (DataType)udt), true);
    }

    private void should_serialize_and_deserialize(DataType in, boolean expectDetached) {
        DataType out = SerializationHelper.serializeAndDeserialize(in);
        Assertions.assertThat((Object)out).isEqualTo((Object)in);
        Assertions.assertThat((boolean)out.isDetached()).isEqualTo(expectDetached);
    }
}

