/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session.throttling;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.internal.core.session.throttling.ConcurrencyLimitingRequestThrottler;
import com.datastax.oss.driver.internal.core.session.throttling.MockThrottled;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConcurrencyLimitingRequestThrottlerTest {
    @Mock
    private DriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;
    private ConcurrencyLimitingRequestThrottler throttler;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_CONCURRENT_REQUESTS)).thenReturn((Object)5);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_QUEUE_SIZE)).thenReturn((Object)10);
        this.throttler = new ConcurrencyLimitingRequestThrottler(this.context);
    }

    @Test
    public void should_start_immediately_when_under_capacity() {
        MockThrottled request = new MockThrottled();
        this.throttler.register((Throttled)request);
        Assertions.assertThatStage(request.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isFalse());
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(1);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
    }

    @Test
    public void should_allow_new_request_when_active_one_succeeds() {
        this.should_allow_new_request_when_active_one_completes(arg_0 -> ((ConcurrencyLimitingRequestThrottler)this.throttler).signalSuccess(arg_0));
    }

    @Test
    public void should_allow_new_request_when_active_one_fails() {
        this.should_allow_new_request_when_active_one_completes(request -> this.throttler.signalError(request, (Throwable)new RuntimeException("mock error")));
    }

    @Test
    public void should_allow_new_request_when_active_one_times_out() {
        this.should_allow_new_request_when_active_one_completes(arg_0 -> ((ConcurrencyLimitingRequestThrottler)this.throttler).signalTimeout(arg_0));
    }

    private void should_allow_new_request_when_active_one_completes(Consumer<Throttled> completeCallback) {
        MockThrottled first = new MockThrottled();
        this.throttler.register((Throttled)first);
        Assertions.assertThatStage(first.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isFalse());
        for (int i = 0; i < 4; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(5);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
        completeCallback.accept(first);
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(4);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
        MockThrottled incoming = new MockThrottled();
        this.throttler.register((Throttled)incoming);
        Assertions.assertThatStage(incoming.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isFalse());
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(5);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
    }

    @Test
    public void should_enqueue_when_over_capacity() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(5);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
        MockThrottled incoming = new MockThrottled();
        this.throttler.register((Throttled)incoming);
        Assertions.assertThatStage(incoming.started).isNotDone();
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(5);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).containsExactly((Object[])new Throttled[]{incoming});
    }

    @Test
    public void should_dequeue_when_active_succeeds() {
        this.should_dequeue_when_active_completes(arg_0 -> ((ConcurrencyLimitingRequestThrottler)this.throttler).signalSuccess(arg_0));
    }

    @Test
    public void should_dequeue_when_active_fails() {
        this.should_dequeue_when_active_completes(request -> this.throttler.signalError(request, (Throwable)new RuntimeException("mock error")));
    }

    @Test
    public void should_dequeue_when_active_times_out() {
        this.should_dequeue_when_active_completes(arg_0 -> ((ConcurrencyLimitingRequestThrottler)this.throttler).signalTimeout(arg_0));
    }

    private void should_dequeue_when_active_completes(Consumer<Throttled> completeCallback) {
        MockThrottled first = new MockThrottled();
        this.throttler.register((Throttled)first);
        Assertions.assertThatStage(first.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isFalse());
        for (int i = 0; i < 4; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        MockThrottled incoming = new MockThrottled();
        this.throttler.register((Throttled)incoming);
        Assertions.assertThatStage(incoming.started).isNotDone();
        completeCallback.accept(first);
        Assertions.assertThatStage(incoming.started).isSuccess(wasDelayed -> Assertions.assertThat((Boolean)wasDelayed).isTrue());
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(5);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).isEmpty();
    }

    @Test
    public void should_reject_when_queue_is_full() {
        for (int i = 0; i < 15; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(5);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).hasSize(10);
        MockThrottled incoming = new MockThrottled();
        this.throttler.register((Throttled)incoming);
        Assertions.assertThatStage(incoming.started).isFailed(error -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(RequestThrottlingException.class);
        });
    }

    @Test
    public void should_remove_timed_out_request_from_queue() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        MockThrottled queued1 = new MockThrottled();
        this.throttler.register((Throttled)queued1);
        MockThrottled queued2 = new MockThrottled();
        this.throttler.register((Throttled)queued2);
        this.throttler.signalTimeout((Throttled)queued1);
        Assertions.assertThatStage(queued2.started).isNotDone();
        Assertions.assertThat((int)this.throttler.getConcurrentRequests()).isEqualTo(5);
        Assertions.assertThat((Iterable)this.throttler.getQueue()).hasSize(1);
    }

    @Test
    public void should_reject_enqueued_when_closing() {
        for (int i = 0; i < 5; ++i) {
            this.throttler.register((Throttled)new MockThrottled());
        }
        ArrayList enqueued = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            MockThrottled request = new MockThrottled();
            this.throttler.register((Throttled)request);
            Assertions.assertThatStage(request.started).isNotDone();
            enqueued.add(request);
        }
        this.throttler.close();
        for (MockThrottled request : enqueued) {
            Assertions.assertThatStage(request.started).isFailed(error -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(RequestThrottlingException.class);
            });
        }
        MockThrottled request = new MockThrottled();
        this.throttler.register((Throttled)request);
        Assertions.assertThatStage(request.started).isFailed(error -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(RequestThrottlingException.class);
        });
    }
}

