/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.internal.core.channel.ChannelHandlerTestBase;
import com.datastax.oss.driver.internal.core.protocol.ByteBufPrimitiveCodec;
import com.datastax.oss.driver.internal.core.protocol.FrameDecoder;
import com.datastax.oss.driver.internal.core.protocol.FrameDecodingException;
import com.datastax.oss.driver.internal.core.util.ByteBufs;
import com.datastax.oss.protocol.internal.Compressor;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.response.AuthSuccess;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class FrameDecoderTest
extends ChannelHandlerTestBase {
    private static final ByteBuf VALID_PAYLOAD = ByteBufs.fromHexString("0x8400002a100000000800000004cafebabe");
    private static final ByteBuf INVALID_PAYLOAD = ByteBufs.fromHexString("0xFF00002a100000000800000004cafebabe");
    private FrameCodec<ByteBuf> frameCodec;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.frameCodec = FrameCodec.defaultClient((PrimitiveCodec)new ByteBufPrimitiveCodec(this.channel.alloc()), (Compressor)Compressor.none());
    }

    @Test
    public void should_decode_valid_payload() {
        FrameDecoder decoder = new FrameDecoder(this.frameCodec, 1024);
        this.channel.pipeline().addLast(new ChannelHandler[]{decoder});
        VALID_PAYLOAD.retain();
        this.channel.writeInbound(new Object[]{VALID_PAYLOAD.duplicate()});
        Frame frame = this.readInboundFrame();
        Assertions.assertThat((Object)frame.message).isInstanceOf(AuthSuccess.class);
    }

    @Test
    public void should_fail_to_decode_if_payload_is_valid_but_too_long() {
        FrameDecoder decoder = new FrameDecoder(this.frameCodec, VALID_PAYLOAD.readableBytes() - 1);
        this.channel.pipeline().addLast(new ChannelHandler[]{decoder});
        VALID_PAYLOAD.retain();
        try {
            this.channel.writeInbound(new Object[]{VALID_PAYLOAD.duplicate()});
            Assertions.fail((String)"expected an exception");
        }
        catch (FrameDecodingException e) {
            Assertions.assertThat((int)e.streamId).isEqualTo(42);
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(FrameTooLongException.class);
        }
    }

    @Test
    public void should_fail_to_decode_if_payload_cannot_be_decoded() {
        FrameDecoder decoder = new FrameDecoder(this.frameCodec, 1024);
        this.channel.pipeline().addLast(new ChannelHandler[]{decoder});
        INVALID_PAYLOAD.retain();
        try {
            this.channel.writeInbound(new Object[]{INVALID_PAYLOAD.duplicate()});
            Assertions.fail((String)"expected an exception");
        }
        catch (FrameDecodingException e) {
            Assertions.assertThat((int)e.streamId).isEqualTo(42);
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalArgumentException.class);
        }
    }
}

