/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.pool;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.InvalidKeyspaceException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.internal.core.channel.ChannelEvent;
import com.datastax.oss.driver.internal.core.channel.ClusterNameMismatchException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.MockChannelFactoryHelper;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.TopologyEvent;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.pool.ChannelPoolTestBase;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.awaitility.Awaitility;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ChannelPoolInitTest
extends ChannelPoolTestBase {
    @Test
    public void should_initialize_when_all_channels_succeed() throws Exception {
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)3);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).success((Node)this.node, channel3).build();
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 3);
        Assertions.assertThatStage(poolFuture).isSuccess(pool -> Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel1, channel2, channel3}));
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT.times(3))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_initialize_when_all_channels_fail() throws Exception {
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)3);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).failure((Node)this.node, "mock channel init failure").failure((Node)this.node, "mock channel init failure").failure((Node)this.node, "mock channel init failure").build();
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 3);
        Assertions.assertThatStage(poolFuture).isSuccess(pool -> Assertions.assertThat((Iterable)pool.channels).isEmpty());
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater, (VerificationMode)VERIFY_TIMEOUT.times(3))).incrementCounter((Object)DefaultNodeMetric.CONNECTION_INIT_ERRORS, null);
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_indicate_when_keyspace_failed_on_all_channels() {
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)3);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).failure((Node)this.node, (Throwable)new InvalidKeyspaceException("invalid keyspace")).failure((Node)this.node, (Throwable)new InvalidKeyspaceException("invalid keyspace")).failure((Node)this.node, (Throwable)new InvalidKeyspaceException("invalid keyspace")).build();
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 3);
        Assertions.assertThatStage(poolFuture).isSuccess(pool -> {
            Assertions.assertThat((boolean)pool.isInvalidKeyspace()).isTrue();
            ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater, (VerificationMode)VERIFY_TIMEOUT.times(3))).incrementCounter((Object)DefaultNodeMetric.CONNECTION_INIT_ERRORS, null);
        });
    }

    @Test
    public void should_fire_force_down_event_when_cluster_name_does_not_match() throws Exception {
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)3);
        ClusterNameMismatchException error = new ClusterNameMismatchException(this.node.getEndPoint(), "actual", "expected");
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).failure((Node)this.node, (Throwable)error).failure((Node)this.node, (Throwable)error).failure((Node)this.node, (Throwable)error).build();
        ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 3);
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)TopologyEvent.forceDown((InetSocketAddress)((InetSocketAddress)this.node.getBroadcastRpcAddress().get())));
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater, (VerificationMode)VERIFY_TIMEOUT.times(3))).incrementCounter((Object)DefaultNodeMetric.CONNECTION_INIT_ERRORS, null);
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_reconnect_when_init_incomplete() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel2Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).failure((Node)this.node, "mock channel init failure").success((Node)this.node, channel1).pending((Node)this.node, channel2Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel1});
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        channel2Future.complete(channel2);
        factoryHelper.waitForCalls((Node)this.node, 1);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel1, channel2}));
        ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater, (VerificationMode)VERIFY_TIMEOUT)).incrementCounter((Object)DefaultNodeMetric.CONNECTION_INIT_ERRORS, null);
        factoryHelper.verifyNoMoreCalls();
    }
}

