/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.NoopMetricsFactory;
import com.datastax.oss.driver.internal.core.util.LoggerTest;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=DataProviderRunner.class)
public class NoopMetricsFactoryTest {
    @Test
    public void should_log_warning_when_metrics_enabled() {
        InternalDriverContext context = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        DriverConfig config = (DriverConfig)Mockito.mock(DriverConfig.class);
        DriverExecutionProfile profile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)context.getSessionName()).thenReturn((Object)"MockSession");
        Mockito.when((Object)context.getConfig()).thenReturn((Object)config);
        Mockito.when((Object)config.getDefaultProfile()).thenReturn((Object)profile);
        Mockito.when((Object)profile.getStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED)).thenReturn(Collections.singletonList(DefaultSessionMetric.CQL_REQUESTS.getPath()));
        LoggerTest.LoggerSetup logger = LoggerTest.setupTestLogger(NoopMetricsFactory.class, Level.WARN);
        new NoopMetricsFactory((DriverContext)context);
        ((Appender)Mockito.verify(logger.appender, (VerificationMode)Mockito.times((int)1))).doAppend((Object)((ILoggingEvent)logger.loggingEventCaptor.capture()));
        Assertions.assertThat((String)((ILoggingEvent)logger.loggingEventCaptor.getValue()).getMessage()).isNotNull();
        Assertions.assertThat((String)((ILoggingEvent)logger.loggingEventCaptor.getValue()).getFormattedMessage()).contains(new CharSequence[]{"[MockSession] Some session-level or node-level metrics were enabled"});
    }
}

