/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetricIdGenerator;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public class DefaultMetricIdGeneratorTest {
    @Mock
    private InternalDriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile profile;
    @Mock
    private Node node;
    @Mock
    private EndPoint endpoint;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        BDDMockito.given((Object)this.context.getConfig()).willReturn((Object)this.config);
        BDDMockito.given((Object)this.context.getSessionName()).willReturn((Object)"s0");
        BDDMockito.given((Object)this.config.getDefaultProfile()).willReturn((Object)this.profile);
        BDDMockito.given((Object)this.node.getEndPoint()).willReturn((Object)this.endpoint);
        BDDMockito.given((Object)this.endpoint.asMetricPrefix()).willReturn((Object)"10_1_2_3:9042");
    }

    @Test
    @UseDataProvider(value="sessionMetrics")
    public void should_generate_session_metric(String prefix, String expectedName) {
        BDDMockito.given((Object)this.profile.getString((DriverOption)DefaultDriverOption.METRICS_ID_GENERATOR_PREFIX, "")).willReturn((Object)prefix);
        DefaultMetricIdGenerator generator = new DefaultMetricIdGenerator((DriverContext)this.context);
        MetricId id = generator.sessionMetricId((SessionMetric)DefaultSessionMetric.CONNECTED_NODES);
        Assertions.assertThat((String)id.getName()).isEqualTo(expectedName);
        Assertions.assertThat((Map)id.getTags()).isEmpty();
    }

    @Test
    @UseDataProvider(value="nodeMetrics")
    public void should_generate_node_metric(String prefix, String expectedName) {
        BDDMockito.given((Object)this.profile.getString((DriverOption)DefaultDriverOption.METRICS_ID_GENERATOR_PREFIX, "")).willReturn((Object)prefix);
        DefaultMetricIdGenerator generator = new DefaultMetricIdGenerator((DriverContext)this.context);
        MetricId id = generator.nodeMetricId(this.node, (NodeMetric)DefaultNodeMetric.CQL_MESSAGES);
        Assertions.assertThat((String)id.getName()).isEqualTo(expectedName);
        Assertions.assertThat((Map)id.getTags()).isEmpty();
    }

    @DataProvider
    public static Object[][] sessionMetrics() {
        String suffix = DefaultSessionMetric.CONNECTED_NODES.getPath();
        return new Object[][]{{"", "s0." + suffix}, {"cassandra", "cassandra.s0." + suffix}, {"app.cassandra", "app.cassandra.s0." + suffix}};
    }

    @DataProvider
    public static Object[][] nodeMetrics() {
        String suffix = DefaultNodeMetric.CQL_MESSAGES.getPath();
        return new Object[][]{{"", "s0.nodes.10_1_2_3:9042." + suffix}, {"cassandra", "cassandra.s0.nodes.10_1_2_3:9042." + suffix}, {"app.cassandra", "app.cassandra.s0.nodes.10_1_2_3:9042." + suffix}};
    }
}

