/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenRange;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TokenRangeTest {
    private Murmur3Token min = Murmur3TokenFactory.MIN_TOKEN;

    @Test
    public void should_check_intersection() {
        Assertions.assertThat(this.range(3L, 9L)).doesNotIntersect(this.range(11L, 1L)).doesNotIntersect(this.range(1L, 2L)).doesNotIntersect(this.range(11L, 3L)).doesNotIntersect(this.range(2L, 3L)).doesNotIntersect(this.range(3L, 3L)).intersects(this.range(2L, 6L)).intersects(this.range(2L, 10L)).intersects(this.range(6L, 10L)).intersects(this.range(4L, 8L)).intersects(this.range(3L, 9L)).doesNotIntersect(this.range(9L, 10L)).doesNotIntersect(this.range(10L, 11L));
        Assertions.assertThat(this.range(9L, 3L)).doesNotIntersect(this.range(5L, 7L)).doesNotIntersect(this.range(7L, 8L)).doesNotIntersect(this.range(5L, 9L)).doesNotIntersect(this.range(8L, 9L)).doesNotIntersect(this.range(9L, 9L)).intersects(this.range(8L, 2L)).intersects(this.range(8L, 4L)).intersects(this.range(2L, 4L)).intersects(this.range(10L, 2L)).intersects(this.range(9L, 3L)).doesNotIntersect(this.range(3L, 4L)).doesNotIntersect(this.range(4L, 5L));
        Assertions.assertThat(this.range(3L, 3L)).doesNotIntersect(this.range(3L, 3L));
        Assertions.assertThat(this.minTo(5L)).doesNotIntersect(this.range(6L, 7L)).doesNotIntersect(this.toMax(6L)).intersects(this.range(6L, 4L)).intersects(this.range(2L, 4L)).intersects(this.minTo(4L)).intersects(this.minTo(5L));
        Assertions.assertThat(this.toMax(5L)).doesNotIntersect(this.range(3L, 4L)).doesNotIntersect(this.minTo(4L)).intersects(this.range(6L, 7L)).intersects(this.range(4L, 1L)).intersects(this.toMax(6L)).intersects(this.toMax(5L));
        Assertions.assertThat(this.fullRing()).intersects(this.range(3L, 4L)).intersects(this.toMax(3L)).intersects(this.minTo(3L)).doesNotIntersect(this.range(3L, 3L));
    }

    @Test
    public void should_compute_intersection() {
        Assertions.assertThat((List)this.range(3L, 9L).intersectWith(this.range(2L, 4L))).isEqualTo((Object)ImmutableList.of((Object)this.range(3L, 4L)));
        Assertions.assertThat((List)this.range(3L, 9L).intersectWith(this.range(3L, 5L))).isEqualTo((Object)ImmutableList.of((Object)this.range(3L, 5L)));
        Assertions.assertThat((List)this.range(3L, 9L).intersectWith(this.range(4L, 6L))).isEqualTo((Object)ImmutableList.of((Object)this.range(4L, 6L)));
        Assertions.assertThat((List)this.range(3L, 9L).intersectWith(this.range(7L, 9L))).isEqualTo((Object)ImmutableList.of((Object)this.range(7L, 9L)));
        Assertions.assertThat((List)this.range(3L, 9L).intersectWith(this.range(8L, 10L))).isEqualTo((Object)ImmutableList.of((Object)this.range(8L, 9L)));
    }

    @Test
    public void should_compute_intersection_with_ranges_around_ring() {
        Assertions.assertThat((List)this.range(10L, -10L).intersectWith(this.range(-20L, 20L))).isEqualTo((Object)ImmutableList.of((Object)this.range(10L, 20L), (Object)this.range(-20L, -10L)));
        Assertions.assertThat((List)this.range(-20L, 20L).intersectWith(this.range(10L, -10L))).isEqualTo((Object)ImmutableList.of((Object)this.range(10L, 20L), (Object)this.range(-20L, -10L)));
        Assertions.assertThat((List)this.range(10L, -30L).intersectWith(this.range(20L, -20L))).isEqualTo((Object)ImmutableList.of((Object)this.range(20L, -30L)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_compute_intersection_when_ranges_dont_intersect() {
        this.range(1L, 2L).intersectWith(this.range(2L, 3L));
    }

    @Test
    public void should_merge_with_other_range() {
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(2L, 3L))).isEqualTo(this.range(2L, 9L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(2L, 4L))).isEqualTo(this.range(2L, 9L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(11L, 3L))).isEqualTo(this.range(11L, 9L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(11L, 4L))).isEqualTo(this.range(11L, 9L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(4L, 8L))).isEqualTo(this.range(3L, 9L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(3L, 9L))).isEqualTo(this.range(3L, 9L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(3L, 3L))).isEqualTo(this.range(3L, 9L));
        Assertions.assertThat(this.range(3L, 3L).mergeWith(this.range(3L, 9L))).isEqualTo(this.range(3L, 9L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(9L, 11L))).isEqualTo(this.range(3L, 11L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(8L, 11L))).isEqualTo(this.range(3L, 11L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(9L, 1L))).isEqualTo(this.range(3L, 1L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(8L, 1L))).isEqualTo(this.range(3L, 1L));
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(9L, 3L))).isEqualTo(this.fullRing());
        Assertions.assertThat(this.range(3L, 9L).mergeWith(this.range(9L, 4L))).isEqualTo(this.fullRing());
        Assertions.assertThat(this.range(3L, 10L).mergeWith(this.range(9L, 4L))).isEqualTo(this.fullRing());
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(8L, 9L))).isEqualTo(this.range(8L, 3L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(8L, 10L))).isEqualTo(this.range(8L, 3L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(4L, 9L))).isEqualTo(this.range(4L, 3L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(4L, 10L))).isEqualTo(this.range(4L, 3L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(10L, 2L))).isEqualTo(this.range(9L, 3L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(9L, 3L))).isEqualTo(this.range(9L, 3L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(9L, 9L))).isEqualTo(this.range(9L, 3L));
        Assertions.assertThat(this.range(9L, 9L).mergeWith(this.range(9L, 3L))).isEqualTo(this.range(9L, 3L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(3L, 5L))).isEqualTo(this.range(9L, 5L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(2L, 5L))).isEqualTo(this.range(9L, 5L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(3L, 7L))).isEqualTo(this.range(9L, 7L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(2L, 7L))).isEqualTo(this.range(9L, 7L));
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(3L, 9L))).isEqualTo(this.fullRing());
        Assertions.assertThat(this.range(9L, 3L).mergeWith(this.range(3L, 10L))).isEqualTo(this.fullRing());
        Assertions.assertThat(this.range(3L, 3L).mergeWith(this.range(3L, 3L))).isEqualTo(this.range(3L, 3L));
        Assertions.assertThat(this.toMax(5L).mergeWith(this.range(6L, 7L))).isEqualTo(this.toMax(5L));
        Assertions.assertThat(this.toMax(5L).mergeWith(this.minTo(3L))).isEqualTo(this.range(5L, 3L));
        Assertions.assertThat(this.toMax(5L).mergeWith(this.range(3L, 5L))).isEqualTo(this.toMax(3L));
        Assertions.assertThat(this.minTo(5L).mergeWith(this.range(2L, 3L))).isEqualTo(this.minTo(5L));
        Assertions.assertThat(this.minTo(5L).mergeWith(this.toMax(7L))).isEqualTo(this.range(7L, 5L));
        Assertions.assertThat(this.minTo(5L).mergeWith(this.range(5L, 7L))).isEqualTo(this.minTo(7L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_not_merge_with_nonadjacent_and_disjoint_ranges() {
        this.range(0L, 5L).mergeWith(this.range(7L, 14L));
    }

    @Test
    public void should_return_non_empty_range_if_other_range_is_empty() {
        Assertions.assertThat(this.range(1L, 5L).mergeWith(this.range(5L, 5L))).isEqualTo(this.range(1L, 5L));
    }

    @Test
    public void should_unwrap_to_non_wrapping_ranges() {
        Assertions.assertThat(this.range(9L, 3L)).unwrapsTo(this.toMax(9L), this.minTo(3L));
        Assertions.assertThat(this.range(3L, 9L)).isNotWrappedAround();
        Assertions.assertThat(this.toMax(3L)).isNotWrappedAround();
        Assertions.assertThat(this.minTo(3L)).isNotWrappedAround();
        Assertions.assertThat(this.range(3L, 3L)).isNotWrappedAround();
        Assertions.assertThat(this.fullRing()).isNotWrappedAround();
    }

    @Test
    public void should_split_evenly() {
        List splits = this.range(3L, 9L).splitEvenly(3);
        Assertions.assertThat((List)splits).hasSize(3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new TokenRange[]{this.range(3L, 5L), this.range(5L, 7L), this.range(7L, 9L)});
    }

    @Test
    public void should_throw_error_with_less_than_1_splits() {
        for (int i = -255; i < 1; ++i) {
            try {
                this.range(0L, 1L).splitEvenly(i);
                Assert.fail((String)("Expected error when providing " + i + " splits."));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_not_split_empty_token_range() {
        this.range(0L, 0L).splitEvenly(1);
    }

    @Test
    public void should_create_empty_token_ranges_if_too_many_splits() {
        TokenRange range = this.range(0L, 10L);
        List ranges = range.splitEvenly(255);
        Assertions.assertThat((List)ranges).hasSize(255);
        for (int i = 0; i < ranges.size(); ++i) {
            TokenRange tr = (TokenRange)ranges.get(i);
            if (i < 10) {
                Assertions.assertThat(tr).isEqualTo(this.range(i, i + 1));
                continue;
            }
            Assertions.assertThat((boolean)tr.isEmpty());
        }
    }

    @Test
    public void should_check_if_range_contains_token() {
        Assertions.assertThat(this.range(1L, 2L)).contains((Token)new Murmur3Token(2L), false).doesNotContain((Token)new Murmur3Token(2L), true);
        Assertions.assertThat(this.range(1L, 2L)).doesNotContain((Token)new Murmur3Token(1L), false).contains((Token)new Murmur3Token(1L), true);
        Assertions.assertThat(this.range(2L, 1L)).contains((Token)this.min, true);
        Assertions.assertThat(this.minTo(1L)).doesNotContain((Token)this.min, false).contains((Token)this.min, true);
        Assertions.assertThat(this.toMax(1L)).contains((Token)this.min, false).doesNotContain((Token)this.min, true);
        Assertions.assertThat(this.range(1L, 1L)).doesNotContain((Token)new Murmur3Token(1L), true).doesNotContain((Token)new Murmur3Token(1L), false).doesNotContain((Token)this.min, true).doesNotContain((Token)this.min, false);
        Assertions.assertThat(this.fullRing()).contains((Token)this.min, true).contains((Token)this.min, false).contains((Token)new Murmur3Token(1L), true).contains((Token)new Murmur3Token(1L), false);
    }

    private TokenRange range(long start, long end) {
        return new Murmur3TokenRange(new Murmur3Token(start), new Murmur3Token(end));
    }

    private TokenRange minTo(long end) {
        return new Murmur3TokenRange(this.min, new Murmur3Token(end));
    }

    private TokenRange toMax(long start) {
        return new Murmur3TokenRange(new Murmur3Token(start), this.min);
    }

    private TokenRange fullRing() {
        return new Murmur3TokenRange(Murmur3TokenFactory.MIN_TOKEN, Murmur3TokenFactory.MIN_TOKEN);
    }
}

