/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.TokenRangeBase;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class TokenRangeAssert
extends AbstractAssert<TokenRangeAssert, TokenRange> {
    public TokenRangeAssert(TokenRange actual) {
        super((Object)actual, TokenRangeAssert.class);
    }

    public TokenRangeAssert startsWith(Token token) {
        Assertions.assertThat((Comparable)((TokenRange)this.actual).getStart()).isEqualTo((Object)token);
        return this;
    }

    public TokenRangeAssert endsWith(Token token) {
        Assertions.assertThat((Comparable)((TokenRange)this.actual).getEnd()).isEqualTo((Object)token);
        return this;
    }

    public TokenRangeAssert isEmpty() {
        Assertions.assertThat((boolean)((TokenRange)this.actual).isEmpty()).isTrue();
        return this;
    }

    public TokenRangeAssert isNotEmpty() {
        Assertions.assertThat((boolean)((TokenRange)this.actual).isEmpty()).isFalse();
        return this;
    }

    public TokenRangeAssert isWrappedAround() {
        Assertions.assertThat((boolean)((TokenRange)this.actual).isWrappedAround()).isTrue();
        List unwrapped = ((TokenRange)this.actual).unwrap();
        ((AbstractIntegerAssert)Assertions.assertThat((int)unwrapped.size()).as("%s should unwrap to two ranges, but unwrapped to %s", new Object[]{this.actual, unwrapped})).isEqualTo(2);
        return this;
    }

    public TokenRangeAssert isNotWrappedAround() {
        Assertions.assertThat((boolean)((TokenRange)this.actual).isWrappedAround()).isFalse();
        Assertions.assertThat((List)((TokenRange)this.actual).unwrap()).containsExactly((Object[])new TokenRange[]{(TokenRange)this.actual});
        return this;
    }

    public TokenRangeAssert unwrapsTo(TokenRange ... subRanges) {
        Assertions.assertThat((List)((TokenRange)this.actual).unwrap()).containsExactly((Object[])subRanges);
        return this;
    }

    public TokenRangeAssert intersects(TokenRange that) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TokenRange)this.actual).intersects(that)).as("%s should intersect %s", new Object[]{this.actual, that})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)that.intersects((TokenRange)this.actual)).as("%s should intersect %s", new Object[]{that, this.actual})).isTrue();
        return this;
    }

    public TokenRangeAssert doesNotIntersect(TokenRange ... that) {
        for (TokenRange thatRange : that) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TokenRange)this.actual).intersects(thatRange)).as("%s should not intersect %s", new Object[]{this.actual, thatRange})).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)thatRange.intersects((TokenRange)this.actual)).as("%s should not intersect %s", new Object[]{thatRange, this.actual})).isFalse();
        }
        return this;
    }

    public TokenRangeAssert contains(Token token, boolean isStart) {
        Assertions.assertThat((boolean)((TokenRangeBase)this.actual).contains((TokenRange)this.actual, token, isStart)).isTrue();
        return this;
    }

    public TokenRangeAssert doesNotContain(Token token, boolean isStart) {
        Assertions.assertThat((boolean)((TokenRangeBase)this.actual).contains((TokenRange)this.actual, token, isStart)).isFalse();
        return this;
    }
}

