/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenRange;
import java.util.List;
import org.junit.Test;

public class Murmur3TokenRangeTest {
    private static final long MIN = Long.MIN_VALUE;
    private static final long MAX = Long.MAX_VALUE;

    @Test
    public void should_split_range() {
        Assertions.assertThat((List)this.range(Long.MIN_VALUE, 0x4000000000000000L).splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(Long.MIN_VALUE, -4611686018427387904L), this.range(-4611686018427387904L, 0L), this.range(0L, 0x4000000000000000L)});
    }

    @Test
    public void should_split_range_that_wraps_around_the_ring() {
        Assertions.assertThat((List)this.range(0x4000000000000000L, 0L).splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(0x4000000000000000L, -9223372036854775807L), this.range(-9223372036854775807L, -4611686018427387903L), this.range(-4611686018427387903L, 0L)});
    }

    @Test
    public void should_split_range_when_division_not_integral() {
        Assertions.assertThat((List)this.range(0L, 11L).splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(0L, 4L), this.range(4L, 8L), this.range(8L, 11L)});
    }

    @Test
    public void should_split_range_producing_empty_splits() {
        Assertions.assertThat((List)this.range(0L, 2L).splitEvenly(5)).containsExactly((Object[])new TokenRange[]{this.range(0L, 1L), this.range(1L, 2L), this.range(2L, 2L), this.range(2L, 2L), this.range(2L, 2L)});
    }

    @Test
    public void should_split_range_producing_empty_splits_near_ring_end() {
        Assertions.assertThat((List)this.range(Long.MAX_VALUE, Long.MIN_VALUE).splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(Long.MAX_VALUE, Long.MAX_VALUE), this.range(Long.MAX_VALUE, Long.MAX_VALUE), this.range(Long.MAX_VALUE, Long.MIN_VALUE)});
        Assertions.assertThat((List)this.range(Long.MIN_VALUE, -9223372036854775807L).splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(Long.MIN_VALUE, -9223372036854775807L), this.range(-9223372036854775807L, -9223372036854775807L), this.range(-9223372036854775807L, -9223372036854775807L)});
    }

    @Test
    public void should_split_whole_ring() {
        Assertions.assertThat((List)this.range(Long.MIN_VALUE, Long.MIN_VALUE).splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(Long.MIN_VALUE, -3074457345618258603L), this.range(-3074457345618258603L, 0x2AAAAAAAAAAAAAAAL), this.range(0x2AAAAAAAAAAAAAAAL, Long.MIN_VALUE)});
    }

    private Murmur3TokenRange range(long start, long end) {
        return new Murmur3TokenRange(new Murmur3Token(start), new Murmur3Token(end));
    }
}

